/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class TimeBucketCounter {
    private final ConcurrentHashMap<String, AtomicInteger> map = new ConcurrentHashMap();
    private final int numBits;
    private final double ratio;
    volatile boolean isRunning = false;

    public TimeBucketCounter(int bucketDuration) {
        int pof2;
        int durationMillis = bucketDuration * 1000;
        int bits = 0;
        int bitCheck = pof2 = TimeBucketCounter.nextPowerOf2(durationMillis);
        while (bitCheck > 1) {
            bitCheck = pof2 >> ++bits;
        }
        this.numBits = bits;
        this.ratio = TimeBucketCounter.ratioToPowerOf2(durationMillis);
        int cleanupsPerBucketDuration = durationMillis >= 60000 ? 6 : 3;
        MaintenanceThread mt = new MaintenanceThread(durationMillis / cleanupsPerBucketDuration);
        ((Thread)mt).start();
    }

    public final int increment(String identifier) {
        String key = this.getCurrentBucketPrefix() + "-" + identifier;
        AtomicInteger ai = this.map.computeIfAbsent(key, v -> new AtomicInteger());
        return ai.incrementAndGet();
    }

    public final int getCurrentBucketPrefix() {
        return (int)(System.currentTimeMillis() >> this.numBits);
    }

    public int getNumBits() {
        return this.numBits;
    }

    public int getActualDuration() {
        return (int)Math.pow(2.0, this.getNumBits());
    }

    public double getRatio() {
        return this.ratio;
    }

    static double ratioToPowerOf2(int value) {
        double nextPO2 = TimeBucketCounter.nextPowerOf2(value);
        return (double)Math.round(1000.0 * nextPO2 / (double)value) / 1000.0;
    }

    static int nextPowerOf2(int value) {
        int valueOfHighestBit = Integer.highestOneBit(value);
        if (valueOfHighestBit == value) {
            return value;
        }
        return valueOfHighestBit << 1;
    }

    public long getMillisUntilNextBucket() {
        long millis = System.currentTimeMillis();
        long nextTimeBucketMillis = millis + (long)Math.pow(2.0, this.numBits) >> this.numBits << this.numBits;
        long delta = nextTimeBucketMillis - millis;
        return delta;
    }

    public void destroy() {
        this.isRunning = false;
    }

    class MaintenanceThread
    extends Thread {
        final long sleeptime;

        MaintenanceThread(long sleeptime) {
            super.setDaemon(true);
            this.sleeptime = sleeptime;
        }

        @Override
        public void start() {
            TimeBucketCounter.this.isRunning = true;
            super.start();
        }

        @Override
        public void run() {
            while (TimeBucketCounter.this.isRunning) {
                String currentBucketPrefix = String.valueOf(TimeBucketCounter.this.getCurrentBucketPrefix());
                Set keys = TimeBucketCounter.this.map.keySet();
                keys.removeIf(k -> !k.startsWith(currentBucketPrefix));
                try {
                    Thread.sleep(this.sleeptime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

