/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.getpop;

import com.sun.mail.pop3.POP3SSLStore;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.MimeUtility;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.getpop.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryGetPOP
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String servername;
    private String username;
    private String password;
    private boolean usessl;
    private String sslport;
    private String outputdirectory;
    private String filenamepattern;
    private String firstmails;
    public int retrievemails;
    private boolean delete;

    public JobEntryGetPOP(String n) {
        super(n, "");
        this.servername = null;
        this.username = null;
        this.password = null;
        this.usessl = false;
        this.sslport = null;
        this.outputdirectory = null;
        this.filenamepattern = null;
        this.retrievemails = 0;
        this.firstmails = null;
        this.delete = false;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.GET_POP);
    }

    public JobEntryGetPOP() {
        this("");
    }

    public JobEntryGetPOP(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryGetPOP je = (JobEntryGetPOP)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"servername", (String)this.servername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.username));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"usessl", (boolean)this.usessl));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sslport", (String)this.sslport));
        retval.append("      ").append(XMLHandler.addTagValue((String)"outputdirectory", (String)this.outputdirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"filenamepattern", (String)this.filenamepattern));
        retval.append("      ").append(XMLHandler.addTagValue((String)"retrievemails", (int)this.retrievemails));
        retval.append("      ").append(XMLHandler.addTagValue((String)"firstmails", (String)this.firstmails));
        retval.append("      ").append(XMLHandler.addTagValue((String)"delete", (boolean)this.delete));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.servername = XMLHandler.getTagValue((Node)entrynode, (String)"servername");
            this.username = XMLHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"password"));
            this.usessl = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"usessl"));
            this.sslport = XMLHandler.getTagValue((Node)entrynode, (String)"sslport");
            this.outputdirectory = XMLHandler.getTagValue((Node)entrynode, (String)"outputdirectory");
            this.filenamepattern = XMLHandler.getTagValue((Node)entrynode, (String)"filenamepattern");
            this.retrievemails = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"retrievemails"), (int)-1);
            this.firstmails = XMLHandler.getTagValue((Node)entrynode, (String)"firstmails");
            this.delete = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"delete"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(Messages.getString("JobEntryGetPOP.UnableToLoadFromXml"), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.servername = rep.getJobEntryAttributeString(id_jobentry, "servername");
            this.username = rep.getJobEntryAttributeString(id_jobentry, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "password"));
            this.usessl = rep.getJobEntryAttributeBoolean(id_jobentry, "usessl");
            int intSSLPort = (int)rep.getJobEntryAttributeInteger(id_jobentry, "sslport");
            this.sslport = rep.getJobEntryAttributeString(id_jobentry, "sslport");
            if (intSSLPort > 0 && Const.isEmpty((String)this.sslport)) {
                this.sslport = Integer.toString(intSSLPort);
            }
            this.outputdirectory = rep.getJobEntryAttributeString(id_jobentry, "outputdirectory");
            this.filenamepattern = rep.getJobEntryAttributeString(id_jobentry, "filenamepattern");
            this.retrievemails = (int)rep.getJobEntryAttributeInteger(id_jobentry, "retrievemails");
            this.firstmails = rep.getJobEntryAttributeString(id_jobentry, "firstmails");
            this.delete = rep.getJobEntryAttributeBoolean(id_jobentry, "delete");
        }
        catch (KettleException dbe) {
            throw new KettleException(Messages.getString("JobEntryGetPOP.UnableToLoadFromRepo", String.valueOf(id_jobentry)), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "servername", this.servername);
            rep.saveJobEntryAttribute(id_job, this.getID(), "username", this.username);
            rep.saveJobEntryAttribute(id_job, this.getID(), "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveJobEntryAttribute(id_job, this.getID(), "usessl", this.usessl);
            rep.saveJobEntryAttribute(id_job, this.getID(), "sslport", this.sslport);
            rep.saveJobEntryAttribute(id_job, this.getID(), "outputdirectory", this.outputdirectory);
            rep.saveJobEntryAttribute(id_job, this.getID(), "filenamepattern", this.filenamepattern);
            rep.saveJobEntryAttribute(id_job, this.getID(), "retrievemails", this.retrievemails);
            rep.saveJobEntryAttribute(id_job, this.getID(), "firstmails", this.firstmails);
            rep.saveJobEntryAttribute(id_job, this.getID(), "delete", this.delete);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntryGetPOP.UnableToSaveToRepo", String.valueOf(id_job)), (Throwable)dbe);
        }
    }

    public String getSSLPort() {
        return this.sslport;
    }

    public String getRealSSLPort() {
        return this.environmentSubstitute(this.getSSLPort());
    }

    public void setSSLPort(String sslport) {
        this.sslport = sslport;
    }

    public void setFirstMails(String firstmails) {
        this.firstmails = firstmails;
    }

    public String getFirstMails() {
        return this.firstmails;
    }

    public String getRealFirstMails() {
        return this.environmentSubstitute(this.getFirstMails());
    }

    public void setServerName(String servername) {
        this.servername = servername;
    }

    public String getServerName() {
        return this.servername;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    public String getUserName() {
        return this.username;
    }

    public void setOutputDirectory(String outputdirectory) {
        this.outputdirectory = outputdirectory;
    }

    public void setFilenamePattern(String filenamepattern) {
        this.filenamepattern = filenamepattern;
    }

    public String getFilenamePattern() {
        return this.filenamepattern;
    }

    public String getOutputDirectory() {
        return this.outputdirectory;
    }

    public String getRealOutputDirectory() {
        return this.environmentSubstitute(this.getOutputDirectory());
    }

    public String getRealFilenamePattern() {
        return this.environmentSubstitute(this.getFilenamePattern());
    }

    public String getRealUsername() {
        return this.environmentSubstitute(this.getUserName());
    }

    public String getRealServername() {
        return this.environmentSubstitute(this.getServerName());
    }

    public String getPassword() {
        return this.password;
    }

    public String getRealPassword() {
        return this.environmentSubstitute(this.getPassword());
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean getDelete() {
        return this.delete;
    }

    public void setUseSSL(boolean usessl) {
        this.usessl = usessl;
    }

    public boolean getUseSSL() {
        return this.usessl;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        Result result;
        block56: {
            Folder f;
            Store st;
            FileObject fileObject;
            Session sess;
            LogWriter log;
            block54: {
                block53: {
                    log = LogWriter.getInstance();
                    result = previousResult;
                    result.setResult(false);
                    result.setNrErrors(1L);
                    Properties prop = new Properties();
                    prop.setProperty("mail.pop3s.rsetbeforequit", "true");
                    prop.setProperty("mail.pop3.rsetbeforequit", "true");
                    sess = Session.getDefaultInstance((Properties)prop, null);
                    fileObject = null;
                    st = null;
                    f = null;
                    int nbrmailtoretrieve = Const.toInt((String)this.firstmails, (int)0);
                    String realOutputFolder = this.getRealOutputDirectory();
                    fileObject = KettleVFS.getFileObject((String)realOutputFolder);
                    if (!fileObject.exists()) {
                        log.logError(this.toString(), Messages.getString("JobGetMailsFromPOP.FolderNotExists.Label", realOutputFolder), new Object[0]);
                        break block53;
                    }
                    if (fileObject.getType() == FileType.FOLDER) {
                        String host = this.getRealServername();
                        String user = this.getRealUsername();
                        String pwd = this.getRealPassword();
                        int port = -1;
                        if (!this.getUseSSL()) {
                            st = sess.getStore("pop3");
                            port = Const.toInt((String)this.getRealSSLPort(), (int)-1);
                            if (port != -1) {
                                st.connect(host, port, user, pwd);
                            } else {
                                st.connect(host, user, pwd);
                            }
                        } else {
                            String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
                            prop.setProperty("mail.pop3.socketFactory.class", SSL_FACTORY);
                            prop.setProperty("mail.pop3.socketFactory.fallback", "false");
                            prop.setProperty("mail.pop3.port", this.getRealSSLPort());
                            prop.setProperty("mail.pop3.socketFactory.port", this.getRealSSLPort());
                            port = Const.toInt((String)this.getRealSSLPort(), (int)995);
                            URLName url = new URLName("pop3", host, port, "", user, pwd);
                            st = new POP3SSLStore(sess, url);
                            st.connect();
                        }
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobGetMailsFromPOP.LoggedWithUser.Label") + user, new Object[0]);
                        }
                        if ((f = st.getFolder("INBOX")) == null) {
                            log.logError(this.toString(), Messages.getString("JobGetMailsFromPOP.InvalidFolder.Label"), new Object[0]);
                        } else {
                            Message[] msg_list;
                            if (this.delete) {
                                f.open(2);
                            } else {
                                f.open(1);
                            }
                            Message[] messageList = f.getMessages();
                            if (log.isDetailed()) {
                                log.logDetailed(this.toString(), Messages.getString("JobGetMailsFromPOP.TotalMessagesFolder.Label", f.getName(), String.valueOf(messageList.length)), new Object[0]);
                                log.logDetailed(this.toString(), Messages.getString("JobGetMailsFromPOP.TotalUnreadMessagesFolder.Label", f.getName(), String.valueOf(f.getUnreadMessageCount())), new Object[0]);
                            }
                            if ((msg_list = this.getPOPMessages(f, this.retrievemails)).length > 0) {
                                ArrayList<File> current_file_POP = new ArrayList<File>();
                                ArrayList<String> current_filepath_POP = new ArrayList<String>();
                                int nb_email_POP = 1;
                                String startpattern = "name";
                                if (!Const.isEmpty((String)this.getRealFilenamePattern())) {
                                    startpattern = this.getRealFilenamePattern();
                                }
                                for (int i = 0; i < msg_list.length && !parentJob.isStopped(); ++i) {
                                    if ((nb_email_POP > nbrmailtoretrieve || this.retrievemails != 2) && this.retrievemails == 2) continue;
                                    Message msg_POP = msg_list[i];
                                    if (log.isDetailed()) {
                                        log.logDetailed(this.toString(), Messages.getString("JobGetMailsFromPOP.EmailFrom.Label", msg_list[i].getFrom()[0].toString()), new Object[0]);
                                        log.logDetailed(this.toString(), Messages.getString("JobGetMailsFromPOP.EmailSubject.Label", msg_list[i].getSubject()), new Object[0]);
                                    }
                                    String localfilename_message = startpattern + "_" + StringUtil.getFormattedDateTimeNow((boolean)true) + "_" + (i + 1) + ".mail";
                                    if (log.isDetailed()) {
                                        log.logDetailed(this.toString(), Messages.getString("JobGetMailsFromPOP.LocalFilename.Label", localfilename_message), new Object[0]);
                                    }
                                    File filename_message = new File(realOutputFolder, localfilename_message);
                                    FileOutputStream os_filename = new FileOutputStream(filename_message);
                                    Enumeration enums_POP = msg_POP.getAllHeaders();
                                    while (enums_POP.hasMoreElements()) {
                                        Header header_POP = (Header)enums_POP.nextElement();
                                        ((OutputStream)os_filename).write(new StringBuffer(header_POP.getName()).append(": ").append(header_POP.getValue()).append("\r\n").toString().getBytes());
                                    }
                                    ((OutputStream)os_filename).write("\r\n".getBytes());
                                    InputStream in_POP = msg_POP.getInputStream();
                                    byte[] buffer_POP = new byte[1024];
                                    int length_POP = 0;
                                    while ((length_POP = in_POP.read(buffer_POP, 0, 1024)) != -1) {
                                        ((OutputStream)os_filename).write(buffer_POP, 0, length_POP);
                                    }
                                    ((OutputStream)os_filename).close();
                                    ++nb_email_POP;
                                    current_file_POP.add(filename_message);
                                    current_filepath_POP.add(filename_message.getPath());
                                    Object content = msg_POP.getContent();
                                    if (content instanceof Multipart) {
                                        JobEntryGetPOP.handleMultipart(realOutputFolder, (Multipart)content);
                                    }
                                    if (!this.delete) continue;
                                    if (log.isDetailed()) {
                                        log.logDetailed(this.toString(), Messages.getString("JobGetMailsFromPOP.DeleteEmail.Label"), new Object[0]);
                                    }
                                    msg_POP.setFlag(Flags.Flag.DELETED, true);
                                }
                            }
                            result.setNrErrors(0L);
                            result.setResult(true);
                        }
                        break block53;
                    }
                    log.logError(this.toString(), Messages.getString("JobGetMailsFromPOP.Error.NotAFolder", realOutputFolder), new Object[0]);
                }
                Object var35_37 = null;
                if (fileObject == null) break block54;
                try {
                    fileObject.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            try {
                if (f != null) {
                    f.close(true);
                }
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception e2) {
                log.logError(this.toString(), e2.getMessage(), new Object[0]);
            }
            f = null;
            st = null;
            sess = null;
            {
                break block56;
                catch (NoSuchProviderException e) {
                    log.logError(this.toString(), Messages.getString("JobEntryGetPOP.ProviderException", e.getMessage()), new Object[0]);
                    Object var35_38 = null;
                    if (fileObject != null) {
                        try {
                            fileObject.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    try {
                        if (f != null) {
                            f.close(true);
                        }
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (Exception e2) {
                        log.logError(this.toString(), e2.getMessage(), new Object[0]);
                    }
                    f = null;
                    st = null;
                    sess = null;
                    break block56;
                }
                catch (MessagingException e) {
                    log.logError(this.toString(), Messages.getString("JobEntryGetPOP.MessagingException", e.getMessage()), new Object[0]);
                    Object var35_39 = null;
                    if (fileObject != null) {
                        try {
                            fileObject.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    try {
                        if (f != null) {
                            f.close(true);
                        }
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (Exception e2) {
                        log.logError(this.toString(), e2.getMessage(), new Object[0]);
                    }
                    f = null;
                    st = null;
                    sess = null;
                    break block56;
                }
                catch (Exception e) {
                    log.logError(this.toString(), Messages.getString("JobEntryGetPOP.GeneralException", e.getMessage()), new Object[0]);
                    Object var35_40 = null;
                    if (fileObject != null) {
                        try {
                            fileObject.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    try {
                        if (f != null) {
                            f.close(true);
                        }
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (Exception e2) {
                        log.logError(this.toString(), e2.getMessage(), new Object[0]);
                    }
                    f = null;
                    st = null;
                    sess = null;
                }
            }
            catch (Throwable throwable) {
                Object var35_41 = null;
                if (fileObject != null) {
                    try {
                        fileObject.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                try {
                    if (f != null) {
                        f.close(true);
                    }
                    if (st != null) {
                        st.close();
                    }
                }
                catch (Exception e2) {
                    log.logError(this.toString(), e2.getMessage(), new Object[0]);
                }
                f = null;
                st = null;
                sess = null;
                throw throwable;
            }
        }
        return result;
    }

    public static void handleMultipart(String foldername, Multipart multipart) throws MessagingException, IOException {
        int n = multipart.getCount();
        for (int i = 0; i < n; ++i) {
            JobEntryGetPOP.handlePart(foldername, (Part)multipart.getBodyPart(i));
        }
    }

    public static void handlePart(String foldername, Part part) throws MessagingException, IOException {
        String disposition = part.getDisposition();
        if (disposition != null && (disposition.equalsIgnoreCase("attachment") || disposition.equalsIgnoreCase("inline"))) {
            JobEntryGetPOP.saveFile(foldername, MimeUtility.decodeText((String)part.getFileName()), part.getInputStream());
        }
    }

    public static void saveFile(String foldername, String filename, InputStream input) throws IOException {
        int aByte;
        if (filename == null) {
            filename = File.createTempFile("xx", ".out").getName();
        }
        File file = new File(foldername, filename);
        int i = 0;
        while (file.exists()) {
            file = new File(foldername, filename + i);
            ++i;
        }
        FileOutputStream fos = new FileOutputStream(file);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        BufferedInputStream bis = new BufferedInputStream(input);
        while ((aByte = bis.read()) != -1) {
            bos.write(aByte);
        }
        bos.flush();
        bos.close();
        bis.close();
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public Message[] getPOPMessages(Folder folder, int retrievemails) throws Exception {
        try {
            int unreadMsgs = folder.getUnreadMessageCount();
            Message[] msgsAll = folder.getMessages();
            int msgCount = msgsAll.length;
            if (retrievemails == 1) {
                Message[] msgsUnread = folder.getMessages(msgCount - unreadMsgs + 1, msgCount);
                return msgsUnread;
            }
            return msgsAll;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "serverName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "userName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "password", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "outputDirectory", remarks, ctx);
        JobEntryValidatorUtils.andValidator().validate(this, "SSLPort", remarks, AndValidator.putValidators(JobEntryValidatorUtils.integerValidator()));
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.servername)) {
            String realServername = jobMeta.environmentSubstitute(this.servername);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realServername, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }
}

