/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.List;
import org.gradle.cache.GlobalCache;
import org.gradle.cache.GlobalCacheLocations;
import org.gradle.internal.file.DefaultFileHierarchySet;
import org.gradle.internal.file.FileHierarchySet;

public class DefaultGlobalCacheLocations
implements GlobalCacheLocations {
    private final FileHierarchySet globalCacheRoots;

    public DefaultGlobalCacheLocations(List<GlobalCache> globalCaches) {
        FileHierarchySet globalCacheRoots = DefaultFileHierarchySet.of();
        for (GlobalCache globalCache : globalCaches) {
            for (File file : globalCache.getGlobalCacheRoots()) {
                globalCacheRoots = globalCacheRoots.plus(file);
            }
        }
        this.globalCacheRoots = globalCacheRoots;
    }

    @Override
    public boolean isInsideGlobalCache(String path) {
        return this.globalCacheRoots.contains(path);
    }

    public String toString() {
        return this.globalCacheRoots.toString();
    }
}

