/*
 * Decompiled with CFR 0.152.
 */
package com.vuze.plugins.mlab;

import edu.internet2.ndt.Tcpbw100;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.SSLEepGet;
import org.json.simple.JsonObject;
import org.json.simple.Jsoner;

public class MLabRunner {
    private static final String NS_URL_SSL = "https://mlab-ns.appspot.com/ndt?format=json";
    private static final String NS_URL_SSL_SSL = "https://mlab-ns.appspot.com/ndt_ssl?format=json";
    private static final String PROP_SSL = "routerconsole.bwtest.useSSL";
    private static final boolean DEFAULT_USE_SSL = false;
    private static final long NS_TIMEOUT = 20000L;
    private final I2PAppContext _context;
    private final Log _log;
    private final AtomicBoolean _running = new AtomicBoolean();
    private static MLabRunner _instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MLabRunner getInstance(I2PAppContext ctx) {
        Class<MLabRunner> clazz = MLabRunner.class;
        synchronized (MLabRunner.class) {
            if (_instance == null) {
                _instance = new MLabRunner(ctx);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _instance;
        }
    }

    private MLabRunner(I2PAppContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(MLabRunner.class);
    }

    public boolean isRunning() {
        return this._running.get();
    }

    public ToolRun runNDT(ToolListener listener) {
        boolean useSSL = this._context.getProperty(PROP_SSL, false);
        return this.runNDT(listener, useSSL, null);
    }

    public ToolRun runNDT(final ToolListener listener, final boolean use_SSL, final String serverHost) {
        if (!this._running.compareAndSet(false, true)) {
            listener.reportSummary("Test already running");
            listener.reportDetail("Test already running");
            this._log.warn("Test already running");
            return null;
        }
        final ToolRunImpl run = new ToolRunImpl();
        this.runTool(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean completed = false;
                try {
                    Tcpbw100 test;
                    String[] stringArray;
                    boolean useSSL;
                    String server_country;
                    String server_city;
                    String server_host;
                    block37: {
                        MLabRunner.this._log.warn("Starting NDT Test");
                        server_host = serverHost;
                        server_city = null;
                        server_country = null;
                        useSSL = use_SSL;
                        if (server_host == null) {
                            try {
                                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                                String nsURL = useSSL ? MLabRunner.NS_URL_SSL_SSL : MLabRunner.NS_URL_SSL;
                                SSLEepGet eepget = new SSLEepGet(MLabRunner.this._context, baos, nsURL);
                                boolean ok = eepget.fetch(20000L, 20000L, 20000L);
                                if (!ok) {
                                    throw new IOException("ns fetch failed");
                                }
                                int code = eepget.getStatusCode();
                                if (code != 200) {
                                    throw new IOException("ns fetch failed: " + code);
                                }
                                byte[] b = baos.toByteArray();
                                String s = new String(b, "ISO-8859-1");
                                JsonObject map = (JsonObject)Jsoner.deserialize(s);
                                if (map == null) {
                                    throw new IOException("no map");
                                }
                                if (MLabRunner.this._log.shouldWarn()) {
                                    MLabRunner.this._log.warn("Got response: " + DataHelper.getUTF8(b));
                                }
                                if ((server_host = (String)map.get("fqdn")) == null) {
                                    throw new IOException("no fqdn");
                                }
                                server_city = (String)map.get("city");
                                server_country = (String)map.get("country");
                                if (MLabRunner.this._log.shouldWarn()) {
                                    MLabRunner.this._log.warn("Selected server: " + server_host);
                                }
                            }
                            catch (Exception e) {
                                if (!MLabRunner.this._log.shouldWarn()) break block37;
                                MLabRunner.this._log.warn("Failed to get server", e);
                            }
                        }
                    }
                    if (server_host == null) {
                        server_host = "ndt.iupui.donar.measurement-lab.org";
                        useSSL = false;
                        if (MLabRunner.this._log.shouldWarn()) {
                            MLabRunner.this._log.warn("Failed to select server, falling back to donar method");
                        }
                    }
                    if (useSSL) {
                        String[] stringArray2 = new String[2];
                        stringArray2[0] = "-s";
                        stringArray = stringArray2;
                        stringArray2[1] = server_host;
                    } else {
                        String[] stringArray3 = new String[1];
                        stringArray = stringArray3;
                        stringArray3[0] = server_host;
                    }
                    String[] args = stringArray;
                    long start = System.currentTimeMillis();
                    try {
                        test = Tcpbw100.mainSupport(args);
                    }
                    catch (IllegalArgumentException iae) {
                        String err = "Failed to connect to bandwidth test server " + server_host;
                        MLabRunner.this._log.error(err, iae);
                        if (listener != null) {
                            listener.reportSummary(err);
                            listener.reportDetail(err);
                        }
                        if (!completed && listener != null) {
                            listener.complete(new HashMap<String, Object>());
                        }
                        MLabRunner.this._running.set(false);
                        return;
                    }
                    final AtomicBoolean cancelled = new AtomicBoolean();
                    run.addListener(new ToolRunListener(){

                        @Override
                        public void cancelled() {
                            cancelled.set(true);
                            MLabRunner.this._log.warn("TRL cancelling test");
                            test.killIt();
                            MLabRunner.this._log.warn("TRL cancelled test");
                        }

                        @Override
                        public String getStatus() {
                            return test.getStatus();
                        }
                    });
                    test.runIt();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ie) {
                        if (!completed && listener != null) {
                            listener.complete(new HashMap<String, Object>());
                        }
                        MLabRunner.this._running.set(false);
                        return;
                    }
                    for (int i = 0; i < 180 && !cancelled.get() && test.isTestInProgress(); ++i) {
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            break;
                        }
                    }
                    long up_bps = 0L;
                    try {
                        up_bps = (long)(Double.parseDouble(test.get_c2sspd()) * 1000000.0) / 8L;
                    }
                    catch (Throwable map) {
                        // empty catch block
                    }
                    long down_bps = 0L;
                    try {
                        down_bps = (long)(Double.parseDouble(test.get_s2cspd()) * 1000000.0) / 8L;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    String result_str = cancelled.get() ? "Test cancelled" : (up_bps == 0L || down_bps == 0L ? "No results were received. Either the test server is unavailable or network problems are preventing the test from running correctly. Please try again." : "Completed: up=" + DataHelper.formatSize2Decimal(up_bps, false) + "Bps, down=" + DataHelper.formatSize2Decimal(down_bps, false) + "Bps");
                    MLabRunner.this._log.warn(result_str);
                    completed = true;
                    if (listener != null) {
                        listener.reportSummary(result_str);
                        listener.reportDetail(result_str);
                        HashMap<String, Object> results = new HashMap<String, Object>();
                        results.put("up", up_bps);
                        results.put("down", down_bps);
                        results.put("server_host", server_host);
                        if (server_city != null) {
                            results.put("server_city", server_city.replace("_", ", "));
                        }
                        if (server_country != null) {
                            results.put("server_country", server_country);
                        }
                        listener.complete(results);
                    }
                    if (MLabRunner.this._log.shouldWarn()) {
                        long end = System.currentTimeMillis();
                        MLabRunner.this._log.warn("Test complete in " + DataHelper.formatDuration(end - start));
                    }
                }
                finally {
                    if (!completed && listener != null) {
                        listener.complete(new HashMap<String, Object>());
                    }
                    MLabRunner.this._running.set(false);
                }
            }
        });
        return run;
    }

    private void runTool(final Runnable target) {
        new I2PAppThread("MLabRunner"){

            @Override
            public void run() {
                target.run();
            }
        }.start();
    }

    public static void main(String[] args) {
        boolean useSSL;
        boolean bl = useSSL = args.length > 0 && args[0].equals("-s");
        String host = useSSL && args.length > 1 ? args[1] : (!useSSL && args.length > 0 ? args[0] : null);
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        MLabRunner mlab = MLabRunner.getInstance(ctx);
        TestListener lsnr = new TestListener();
        mlab.runNDT(lsnr, useSSL, host);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ie) {
            return;
        }
        for (int i = 0; i < 180 && !lsnr.isComplete(); ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException ie) {
                break;
            }
        }
    }

    private static class TestListener
    implements ToolListener {
        private final AtomicBoolean _complete = new AtomicBoolean();

        private TestListener() {
        }

        @Override
        public void reportSummary(String str) {
            System.out.println(str);
        }

        @Override
        public void reportDetail(String str) {
            System.out.println(str);
        }

        @Override
        public void complete(Map<String, Object> results) {
            System.out.println("**************** Results: " + DataHelper.toString(results) + "***********************");
            this._complete.set(true);
        }

        public boolean isComplete() {
            return this._complete.get();
        }
    }

    public static interface ToolListener {
        public void reportSummary(String var1);

        public void reportDetail(String var1);

        public void complete(Map<String, Object> var1);
    }

    public static interface ToolRunListener {
        public void cancelled();

        public String getStatus();
    }

    private class ToolRunImpl
    implements ToolRun {
        private List<ToolRunListener> listeners = new ArrayList<ToolRunListener>();
        private boolean cancelled;

        private ToolRunImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            ArrayList<ToolRunListener> copy;
            ToolRunImpl toolRunImpl = this;
            synchronized (toolRunImpl) {
                this.cancelled = true;
                copy = new ArrayList<ToolRunListener>(this.listeners);
            }
            for (ToolRunListener l : copy) {
                try {
                    l.cancelled();
                }
                catch (Throwable e) {
                    MLabRunner.this._log.warn("?", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListener(ToolRunListener l) {
            boolean inform = false;
            ToolRunImpl toolRunImpl = this;
            synchronized (toolRunImpl) {
                inform = this.cancelled;
                this.listeners.add(l);
            }
            if (inform) {
                try {
                    l.cancelled();
                }
                catch (Throwable e) {
                    MLabRunner.this._log.warn("?", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getStatus() {
            ToolRunImpl toolRunImpl = this;
            synchronized (toolRunImpl) {
                return this.listeners.isEmpty() ? "" : this.listeners.get(0).getStatus();
            }
        }
    }

    public static interface ToolRun {
        public void cancel();

        public void addListener(ToolRunListener var1);

        public String getStatus();
    }
}

