/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.openstreetmap.josm.data.osm.KeyValueVisitor;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Tag;

public interface Tagged {
    public static final int MAX_TAG_LENGTH = 255;

    public void setKeys(Map<String, String> var1);

    public Map<String, String> getKeys();

    default public void visitKeys(KeyValueVisitor visitor) {
        this.getKeys().forEach((k, v) -> visitor.visitKeyValue(this, (String)k, (String)v));
    }

    public void put(String var1, String var2);

    default public void put(Tag tag) {
        this.put(tag.getKey(), tag.getValue());
    }

    public String get(String var1);

    public void remove(String var1);

    public boolean hasKeys();

    default public boolean hasKey(String key) {
        return this.get(key) != null;
    }

    default public boolean hasTag(String key) {
        String v = this.get(key);
        return v != null && !v.isEmpty();
    }

    default public boolean hasTag(String key, String value) {
        return Objects.equals(value, this.get(key));
    }

    default public boolean hasTag(String key, String ... values) {
        return this.hasTag(key, Arrays.asList(values));
    }

    default public boolean hasTag(String key, Collection<String> values) {
        return values.contains(this.get(key));
    }

    default public boolean hasTagDifferent(String key, String value) {
        String v = this.get(key);
        return v != null && !v.equals(value);
    }

    default public boolean hasTagDifferent(String key, String ... values) {
        return this.hasTagDifferent(key, Arrays.asList(values));
    }

    default public boolean hasTagDifferent(String key, Collection<String> values) {
        String v = this.get(key);
        return v != null && !values.contains(v);
    }

    public Collection<String> keySet();

    public int getNumKeys();

    public void removeAll();

    default public boolean isKeyTrue(String key) {
        return OsmUtils.isTrue(this.get(key));
    }

    default public boolean isKeyFalse(String key) {
        return OsmUtils.isFalse(this.get(key));
    }
}

