/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tasks.impl;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.infinispan.commons.time.TimeService;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.security.Security;
import org.infinispan.tasks.Task;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskExecution;
import org.infinispan.tasks.TaskManager;
import org.infinispan.tasks.impl.SecurityActions;
import org.infinispan.tasks.impl.TaskExecutionImpl;
import org.infinispan.tasks.logging.Log;
import org.infinispan.tasks.logging.Messages;
import org.infinispan.tasks.spi.NonBlockingTaskEngine;
import org.infinispan.tasks.spi.TaskEngine;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.util.logging.events.EventLogger;

@Scope(value=Scopes.GLOBAL)
public class TaskManagerImpl
implements TaskManager {
    private static final Log log = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    @Inject
    EmbeddedCacheManager cacheManager;
    @Inject
    TimeService timeService;
    @Inject
    BlockingManager blockingManager;
    @Inject
    EventLogManager eventLogManager;
    private List<TaskEngine> engines = new ArrayList<TaskEngine>();
    private ConcurrentMap<UUID, TaskExecution> runningTasks = new ConcurrentHashMap<UUID, TaskExecution>();
    private boolean useSecurity;

    @Start
    public void start() {
        this.useSecurity = SecurityActions.getCacheManagerConfiguration(this.cacheManager).security().authorization().enabled();
    }

    @Override
    public synchronized void registerTaskEngine(TaskEngine engine) {
        if (!this.engines.contains(engine)) {
            this.engines.add(engine);
        }
    }

    @Override
    public <T> CompletionStage<T> runTask(String name, TaskContext context) {
        CompletionStage engineStage = Flowable.fromIterable(this.engines).concatMapMaybe(engine -> {
            if (engine instanceof NonBlockingTaskEngine) {
                return Maybe.fromCompletionStage(((NonBlockingTaskEngine)engine).handlesAsync(name)).concatMap(canHandle -> canHandle != false ? Maybe.just((Object)engine) : Maybe.empty());
            }
            return engine.handles(name) ? Maybe.just((Object)engine) : Maybe.empty();
        }).firstElement().toCompletionStage(null);
        return engineStage.thenCompose(engine -> {
            if (engine == null) {
                throw log.unknownTask(name);
            }
            context.cacheManager(this.cacheManager);
            Address address = this.cacheManager.getAddress();
            Subject subject = context.getSubject().orElseGet(() -> {
                if (this.useSecurity) {
                    return Security.getSubject();
                }
                return null;
            });
            Optional<Object> who = Optional.ofNullable(subject == null ? null : Security.getSubjectUserPrincipal((Subject)subject).getName());
            TaskExecutionImpl exec = new TaskExecutionImpl(name, address == null ? "local" : address.toString(), who, context);
            exec.setStart(this.timeService.instant());
            this.runningTasks.put(exec.getUUID(), exec);
            CompletionStage<Object> task = engine.runTask(name, context, this.blockingManager);
            return task.whenComplete((r, e) -> {
                if (context.isLogEvent()) {
                    EventLogger eventLog = this.eventLogManager.getEventLogger().scope(this.cacheManager.getAddress());
                    who.ifPresent(arg_0 -> ((EventLogger)eventLog).who(arg_0));
                    context.getCache().ifPresent(arg_0 -> ((EventLogger)eventLog).context(arg_0));
                    if (e != null) {
                        eventLog.detail(e).error(EventLogCategory.TASKS, Messages.MESSAGES.taskFailure(name));
                    } else {
                        eventLog.detail(String.valueOf(r)).info(EventLogCategory.TASKS, Messages.MESSAGES.taskSuccess(name));
                    }
                }
                this.runningTasks.remove(exec.getUUID());
            });
        });
    }

    @Override
    public List<TaskExecution> getCurrentTasks() {
        return new ArrayList<TaskExecution>(this.runningTasks.values());
    }

    @Override
    public List<TaskEngine> getEngines() {
        return Collections.unmodifiableList(this.engines);
    }

    @Override
    public List<Task> getTasks() {
        ArrayList<Task> tasks = new ArrayList<Task>();
        this.engines.forEach(engine -> tasks.addAll(engine.getTasks()));
        return tasks;
    }

    @Override
    public CompletionStage<List<Task>> getTasksAsync() {
        return this.taskFlowable().collect(Collectors.toList()).toCompletionStage();
    }

    private Flowable<Task> taskFlowable() {
        return Flowable.fromIterable(this.engines).flatMap(engine -> {
            if (engine instanceof NonBlockingTaskEngine) {
                return Flowable.fromCompletionStage(((NonBlockingTaskEngine)engine).getTasksAsync()).flatMap(Flowable::fromIterable);
            }
            return Flowable.fromIterable(engine.getTasks());
        });
    }

    @Override
    public List<Task> getUserTasks() {
        return this.engines.stream().flatMap(engine -> engine.getTasks().stream()).filter(t -> !t.getName().startsWith("@@")).collect(Collectors.toList());
    }

    @Override
    public CompletionStage<List<Task>> getUserTasksAsync() {
        return this.taskFlowable().filter(t -> !t.getName().startsWith("@@")).collect(Collectors.toList()).toCompletionStage();
    }
}

