/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.events;

import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.common.util.Time;
import org.keycloak.events.Event;
import org.keycloak.events.EventQuery;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.AdminEventQuery;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.common.ExpirableEntity;
import org.keycloak.models.map.common.ExpirationUtils;
import org.keycloak.models.map.common.HasRealmId;
import org.keycloak.models.map.events.EventUtils;
import org.keycloak.models.map.events.MapAdminEventEntity;
import org.keycloak.models.map.events.MapAdminEventQuery;
import org.keycloak.models.map.events.MapAuthEventEntity;
import org.keycloak.models.map.events.MapAuthEventQuery;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;

public class MapEventStoreProvider
implements EventStoreProvider {
    private static final Logger LOG = Logger.getLogger(MapEventStoreProvider.class);
    private final KeycloakSession session;
    private final MapKeycloakTransaction<MapAuthEventEntity, Event> authEventsTX;
    private final MapKeycloakTransaction<MapAdminEventEntity, AdminEvent> adminEventsTX;
    private final boolean adminTxHasRealmId;
    private final boolean authTxHasRealmId;

    public MapEventStoreProvider(KeycloakSession session, MapStorage<MapAuthEventEntity, Event> loginEventsStore, MapStorage<MapAdminEventEntity, AdminEvent> adminEventsStore) {
        this.session = session;
        this.authEventsTX = loginEventsStore.createTransaction(session);
        this.adminEventsTX = adminEventsStore.createTransaction(session);
        session.getTransactionManager().enlistAfterCompletion(this.authEventsTX);
        session.getTransactionManager().enlistAfterCompletion(this.adminEventsTX);
        this.authTxHasRealmId = this.authEventsTX instanceof HasRealmId;
        this.adminTxHasRealmId = this.adminEventsTX instanceof HasRealmId;
    }

    private MapKeycloakTransaction<MapAdminEventEntity, AdminEvent> adminTxInRealm(String realmId) {
        if (this.adminTxHasRealmId) {
            ((HasRealmId)((Object)this.adminEventsTX)).setRealmId(realmId);
        }
        return this.adminEventsTX;
    }

    private MapKeycloakTransaction<MapAdminEventEntity, AdminEvent> adminTxInRealm(RealmModel realm) {
        return this.adminTxInRealm(realm == null ? null : realm.getId());
    }

    private MapKeycloakTransaction<MapAuthEventEntity, Event> authTxInRealm(String realmId) {
        if (this.authTxHasRealmId) {
            ((HasRealmId)((Object)this.authEventsTX)).setRealmId(realmId);
        }
        return this.authEventsTX;
    }

    private MapKeycloakTransaction<MapAuthEventEntity, Event> authTxInRealm(RealmModel realm) {
        return this.authTxInRealm(realm == null ? null : realm.getId());
    }

    public void onEvent(Event event) {
        RealmModel realm;
        LOG.tracef("onEvent(%s)%s", (Object)event, StackUtil.getShortStackTrace());
        String id = event.getId();
        String realmId = event.getRealmId();
        if (id != null && this.authTxInRealm(realmId).exists(id)) {
            throw new ModelDuplicateException("Event already exists: " + id);
        }
        MapAuthEventEntity entity = EventUtils.modelToEntity(event);
        if (realmId != null && (realm = this.session.realms().getRealm(realmId)) != null && realm.getEventsExpiration() > 0L) {
            entity.setExpiration(Time.currentTimeMillis() + realm.getEventsExpiration() * 1000L);
        }
        this.authTxInRealm(realmId).create(entity);
    }

    public EventQuery createQuery() {
        LOG.tracef("createQuery()%s", StackUtil.getShortStackTrace());
        return new MapAuthEventQuery(){

            private boolean filterExpired(ExpirableEntity event) {
                if (ExpirationUtils.isExpired(event, true)) {
                    MapEventStoreProvider.this.authTxInRealm(this.realmId).delete(event.getId());
                    return false;
                }
                return true;
            }

            @Override
            protected Stream<Event> read(QueryParameters<Event> queryParameters) {
                return MapEventStoreProvider.this.authTxInRealm(this.realmId).read(queryParameters).filter(this::filterExpired).map(EventUtils::entityToModel);
            }
        };
    }

    public void clear() {
        LOG.tracef("clear()%s", StackUtil.getShortStackTrace());
        this.authTxInRealm((String)null).delete(QueryParameters.withCriteria(DefaultModelCriteria.criteria()));
    }

    public void clear(RealmModel realm) {
        LOG.tracef("clear(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        this.authTxInRealm(realm).delete(QueryParameters.withCriteria((DefaultModelCriteria)DefaultModelCriteria.criteria().compare(Event.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})));
    }

    public void clear(RealmModel realm, long olderThan) {
        LOG.tracef("clear(%s, %d)%s", (Object)realm, (Object)olderThan, StackUtil.getShortStackTrace());
        this.authTxInRealm(realm).delete(QueryParameters.withCriteria((DefaultModelCriteria)((DefaultModelCriteria)DefaultModelCriteria.criteria().compare(Event.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(Event.SearchableFields.TIMESTAMP, ModelCriteriaBuilder.Operator.LT, new Object[]{olderThan})));
    }

    public void clearExpiredEvents() {
        LOG.tracef("clearExpiredEvents()%s", StackUtil.getShortStackTrace());
        LOG.warnf("Clearing expired entities should not be triggered manually. It is responsibility of the store to clear these.", new Object[0]);
    }

    public void onEvent(AdminEvent event, boolean includeRepresentation) {
        Long expiration;
        RealmModel realm;
        LOG.tracef("onEvent(%s, %s)%s", (Object)event, (Object)includeRepresentation, StackUtil.getShortStackTrace());
        String id = event.getId();
        String realmId = event.getRealmId();
        if (id != null && this.adminTxInRealm(realmId).exists(id)) {
            throw new ModelDuplicateException("Event already exists: " + id);
        }
        MapAdminEventEntity entity = EventUtils.modelToEntity(event, includeRepresentation);
        if (realmId != null && (realm = this.session.realms().getRealm(realmId)) != null && (expiration = realm.getAttribute("adminEventsExpiration", Long.valueOf(0L))) > 0L) {
            entity.setExpiration(Time.currentTimeMillis() + expiration * 1000L);
        }
        this.adminTxInRealm(realmId).create(entity);
    }

    public AdminEventQuery createAdminQuery() {
        LOG.tracef("createAdminQuery()%s", StackUtil.getShortStackTrace());
        return new MapAdminEventQuery(){

            private boolean filterExpired(ExpirableEntity event) {
                if (ExpirationUtils.isExpired(event, true)) {
                    MapEventStoreProvider.this.authTxInRealm(this.realmId).delete(event.getId());
                    return false;
                }
                return true;
            }

            @Override
            protected Stream<AdminEvent> read(QueryParameters<AdminEvent> queryParameters) {
                return MapEventStoreProvider.this.adminTxInRealm(this.realmId).read(queryParameters).filter(this::filterExpired).map(EventUtils::entityToModel);
            }
        };
    }

    public void clearAdmin() {
        LOG.tracef("clearAdmin()%s", StackUtil.getShortStackTrace());
        this.adminTxInRealm((String)null).delete(QueryParameters.withCriteria(DefaultModelCriteria.criteria()));
    }

    public void clearAdmin(RealmModel realm) {
        LOG.tracef("clearAdmin(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        this.adminTxInRealm(realm).delete(QueryParameters.withCriteria((DefaultModelCriteria)DefaultModelCriteria.criteria().compare(AdminEvent.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})));
    }

    public void clearAdmin(RealmModel realm, long olderThan) {
        LOG.tracef("clearAdmin(%s, %d)%s", (Object)realm, (Object)olderThan, StackUtil.getShortStackTrace());
        this.adminTxInRealm(realm).delete(QueryParameters.withCriteria((DefaultModelCriteria)((DefaultModelCriteria)DefaultModelCriteria.criteria().compare(AdminEvent.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(AdminEvent.SearchableFields.TIMESTAMP, ModelCriteriaBuilder.Operator.LT, new Object[]{olderThan})));
    }

    public void close() {
    }
}

