/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.user;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.models.map.annotations.IgnoreForEntityImplementationGenerator;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.EntityWithAttributes;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.credential.DefaultMapSubjectCredentialManagerEntity;
import org.keycloak.models.map.credential.MapSubjectCredentialManagerEntity;
import org.keycloak.models.map.user.MapUserConsentEntity;
import org.keycloak.models.map.user.MapUserCredentialEntity;
import org.keycloak.models.map.user.MapUserFederatedIdentityEntity;
import org.keycloak.models.map.user.MapUserProvider;
import org.keycloak.models.utils.KeycloakModelUtils;

@DeepCloner.Root
public interface MapUserEntity
extends UpdatableEntity,
AbstractEntity,
EntityWithAttributes {
    public String getRealmId();

    public void setRealmId(String var1);

    public String getUsername();

    public void setUsername(String var1);

    public String getFirstName();

    public void setFirstName(String var1);

    public Long getCreatedTimestamp();

    public void setCreatedTimestamp(Long var1);

    public String getLastName();

    public void setLastName(String var1);

    public String getEmail();

    public void setEmail(String var1);

    @IgnoreForEntityImplementationGenerator
    public void setEmail(String var1, boolean var2);

    public Boolean isEnabled();

    public void setEnabled(Boolean var1);

    public Boolean isEmailVerified();

    public void setEmailVerified(Boolean var1);

    public String getEmailConstraint();

    public void setEmailConstraint(String var1);

    public Set<String> getRequiredActions();

    public void setRequiredActions(Set<String> var1);

    public void addRequiredAction(String var1);

    public void removeRequiredAction(String var1);

    public List<MapUserCredentialEntity> getCredentials();

    public Optional<MapUserCredentialEntity> getCredential(String var1);

    public void setCredentials(List<MapUserCredentialEntity> var1);

    public void addCredential(MapUserCredentialEntity var1);

    public Boolean removeCredential(MapUserCredentialEntity var1);

    public Boolean removeCredential(String var1);

    @IgnoreForEntityImplementationGenerator
    public Boolean moveCredential(String var1, String var2);

    public Set<MapUserFederatedIdentityEntity> getFederatedIdentities();

    public Optional<MapUserFederatedIdentityEntity> getFederatedIdentity(String var1);

    public void setFederatedIdentities(Set<MapUserFederatedIdentityEntity> var1);

    public void addFederatedIdentity(MapUserFederatedIdentityEntity var1);

    public Boolean removeFederatedIdentity(MapUserFederatedIdentityEntity var1);

    public Boolean removeFederatedIdentity(String var1);

    public Set<MapUserConsentEntity> getUserConsents();

    public Optional<MapUserConsentEntity> getUserConsent(String var1);

    public void setUserConsents(Set<MapUserConsentEntity> var1);

    public void addUserConsent(MapUserConsentEntity var1);

    public Boolean removeUserConsent(MapUserConsentEntity var1);

    public Boolean removeUserConsent(String var1);

    public Set<String> getGroupsMembership();

    public void setGroupsMembership(Set<String> var1);

    public void addGroupsMembership(String var1);

    public void removeGroupsMembership(String var1);

    public Set<String> getRolesMembership();

    public void setRolesMembership(Set<String> var1);

    public void addRolesMembership(String var1);

    public void removeRolesMembership(String var1);

    public String getFederationLink();

    public void setFederationLink(String var1);

    public String getServiceAccountClientLink();

    public void setServiceAccountClientLink(String var1);

    public Long getNotBefore();

    public void setNotBefore(Long var1);

    default public MapSubjectCredentialManagerEntity credentialManager() {
        return new DefaultMapSubjectCredentialManagerEntity();
    }

    public static abstract class AbstractUserEntity
    extends UpdatableEntity.Impl
    implements MapUserEntity {
        private static final Logger LOG = Logger.getLogger(MapUserProvider.class);
        private String id;

        @Override
        public boolean isUpdated() {
            return this.updated || Optional.ofNullable(this.getUserConsents()).orElseGet(Collections::emptySet).stream().anyMatch(UpdatableEntity::isUpdated) || Optional.ofNullable(this.getCredentials()).orElseGet(Collections::emptyList).stream().anyMatch(UpdatableEntity::isUpdated) || Optional.ofNullable(this.getFederatedIdentities()).orElseGet(Collections::emptySet).stream().anyMatch(UpdatableEntity::isUpdated);
        }

        @Override
        public void clearUpdatedFlag() {
            this.updated = false;
            Optional.ofNullable(this.getUserConsents()).orElseGet(Collections::emptySet).forEach(UpdatableEntity::clearUpdatedFlag);
            Optional.ofNullable(this.getCredentials()).orElseGet(Collections::emptyList).forEach(UpdatableEntity::clearUpdatedFlag);
            Optional.ofNullable(this.getFederatedIdentities()).orElseGet(Collections::emptySet).forEach(UpdatableEntity::clearUpdatedFlag);
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void setId(String id) {
            if (this.id != null) {
                throw new IllegalStateException("Id cannot be changed");
            }
            this.id = id;
            this.updated |= id != null;
        }

        @Override
        public void setEmail(String email, boolean duplicateEmailsAllowed) {
            this.setEmail(email);
            this.setEmailConstraint(email == null || duplicateEmailsAllowed ? KeycloakModelUtils.generateId() : email);
        }

        @Override
        public Boolean moveCredential(String credentialId, String newPreviousCredentialId) {
            int toMoveIndex;
            List<MapUserCredentialEntity> credentialsList = this.getCredentials();
            int ourCredentialIndex = -1;
            int newPreviousCredentialIndex = -1;
            MapUserCredentialEntity ourCredential = null;
            int i = 0;
            for (MapUserCredentialEntity credential : credentialsList) {
                if (credentialId.equals(credential.getId())) {
                    ourCredentialIndex = i;
                    ourCredential = credential;
                } else if (newPreviousCredentialId != null && newPreviousCredentialId.equals(credential.getId())) {
                    newPreviousCredentialIndex = i;
                }
                ++i;
            }
            if (ourCredentialIndex == -1) {
                LOG.warnf("Not found credential with id [%s] of user [%s]", (Object)credentialId, (Object)this.getUsername());
                return false;
            }
            if (newPreviousCredentialId != null && newPreviousCredentialIndex == -1) {
                LOG.warnf("Can't move up credential with id [%s] of user [%s]", (Object)credentialId, (Object)this.getUsername());
                return false;
            }
            int n = toMoveIndex = newPreviousCredentialId == null ? 0 : newPreviousCredentialIndex + 1;
            if (toMoveIndex == ourCredentialIndex) {
                return true;
            }
            credentialsList.add(toMoveIndex, ourCredential);
            int indexToRemove = toMoveIndex < ourCredentialIndex ? ourCredentialIndex + 1 : ourCredentialIndex;
            credentialsList.remove(indexToRemove);
            this.updated = true;
            return true;
        }
    }
}

