/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.multipart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.multipart.FormDataParser;
import org.jboss.resteasy.reactive.server.core.multipart.FormEncodedDataDefinition;
import org.jboss.resteasy.reactive.server.core.multipart.MultiPartParserDefinition;

public class FormParserFactory {
    private final ParserDefinition[] parserDefinitions;

    FormParserFactory(List<ParserDefinition> parserDefinitions) {
        this.parserDefinitions = parserDefinitions.toArray(new ParserDefinition[parserDefinitions.size()]);
    }

    public FormDataParser createParser(ResteasyReactiveRequestContext exchange) {
        for (int i = 0; i < this.parserDefinitions.length; ++i) {
            FormDataParser parser = this.parserDefinitions[i].create(exchange);
            if (parser == null) continue;
            return parser;
        }
        return null;
    }

    public static Builder builder(Supplier<Executor> executorSupplier) {
        return FormParserFactory.builder(true, executorSupplier);
    }

    public static Builder builder(boolean includeDefault, Supplier<Executor> executorSupplier) {
        Builder builder = new Builder();
        if (includeDefault) {
            builder.addParsers(new FormEncodedDataDefinition(), new MultiPartParserDefinition(executorSupplier));
        }
        return builder;
    }

    public static class Builder {
        private List<ParserDefinition> parsers = new ArrayList<ParserDefinition>();
        private String defaultCharset = null;

        public Builder addParser(ParserDefinition definition) {
            this.parsers.add(definition);
            return this;
        }

        public Builder addParsers(ParserDefinition ... definition) {
            this.parsers.addAll(Arrays.asList(definition));
            return this;
        }

        public Builder addParsers(List<ParserDefinition> definition) {
            this.parsers.addAll(definition);
            return this;
        }

        public List<ParserDefinition> getParsers() {
            return this.parsers;
        }

        public void setParsers(List<ParserDefinition> parsers) {
            this.parsers = parsers;
        }

        public Builder withParsers(List<ParserDefinition> parsers) {
            this.setParsers(parsers);
            return this;
        }

        public String getDefaultCharset() {
            return this.defaultCharset;
        }

        public void setDefaultCharset(String defaultCharset) {
            this.defaultCharset = defaultCharset;
        }

        public Builder withDefaultCharset(String defaultCharset) {
            this.setDefaultCharset(defaultCharset);
            return this;
        }

        public FormParserFactory build() {
            if (this.defaultCharset != null) {
                for (ParserDefinition parser : this.parsers) {
                    parser.setDefaultCharset(this.defaultCharset);
                }
            }
            return new FormParserFactory(this.parsers);
        }
    }

    public static interface ParserDefinition<T> {
        public FormDataParser create(ResteasyReactiveRequestContext var1);

        public T setDefaultCharset(String var1);
    }
}

