/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.impl.ComputingCache;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class AnnotationLiteralGenerator
extends AbstractGenerator {
    private static final Logger LOGGER = Logger.getLogger(AnnotationLiteralGenerator.class);

    AnnotationLiteralGenerator(boolean generateSources) {
        super(generateSources);
    }

    Collection<ResourceOutput.Resource> generate(ComputingCache<AnnotationLiteralProcessor.CacheKey, AnnotationLiteralProcessor.AnnotationLiteralClassInfo> cache, Set<String> existingClasses) {
        ArrayList<ResourceOutput.Resource> resources = new ArrayList<ResourceOutput.Resource>();
        cache.forEachExistingValue(literal -> {
            ResourceClassOutput classOutput = new ResourceClassOutput(literal.isApplicationClass, this.generateSources);
            this.createAnnotationLiteralClass(classOutput, (AnnotationLiteralProcessor.AnnotationLiteralClassInfo)literal, existingClasses);
            resources.addAll(classOutput.getResources());
        });
        return resources;
    }

    Collection<Future<Collection<ResourceOutput.Resource>>> generate(ComputingCache<AnnotationLiteralProcessor.CacheKey, AnnotationLiteralProcessor.AnnotationLiteralClassInfo> cache, final Set<String> existingClasses, ExecutorService executor) {
        ArrayList<Future<Collection<ResourceOutput.Resource>>> futures = new ArrayList<Future<Collection<ResourceOutput.Resource>>>();
        cache.forEachExistingValue(literal -> futures.add(executor.submit(new Callable<Collection<ResourceOutput.Resource>>(){

            @Override
            public Collection<ResourceOutput.Resource> call() throws Exception {
                ResourceClassOutput classOutput = new ResourceClassOutput(literal.isApplicationClass, AnnotationLiteralGenerator.this.generateSources);
                AnnotationLiteralGenerator.this.createAnnotationLiteralClass(classOutput, literal, existingClasses);
                return classOutput.getResources();
            }
        })));
        return futures;
    }

    private void createAnnotationLiteralClass(ClassOutput classOutput, AnnotationLiteralProcessor.AnnotationLiteralClassInfo literal, Set<String> existingClasses) {
        String signature = String.format("L%1$s<L%2$s;>;L%2$s;", AnnotationLiteral.class.getName().replace('.', '/'), literal.annotationClass.toString().replace('.', '/'));
        String generatedName = literal.generatedClassName.replace('.', '/');
        if (existingClasses.contains(generatedName)) {
            return;
        }
        ClassCreator annotationLiteral = ClassCreator.builder().classOutput(classOutput).className(generatedName).superClass(AnnotationLiteral.class).interfaces(new String[]{literal.annotationName().toString()}).signature(signature).build();
        MethodCreator constructor = annotationLiteral.getMethodCreator("<init>", (Object)"V", literal.annotationMembers().stream().map(m -> m.returnType().name().toString()).toArray());
        constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(AnnotationLiteral.class, (Class[])new Class[0]), constructor.getThis(), new ResultHandle[0]);
        int constructorParameterIndex = 0;
        for (MethodInfo annotationMember : literal.annotationMembers()) {
            String type = annotationMember.returnType().name().toString();
            annotationLiteral.getFieldCreator(annotationMember.name(), type).setModifiers(18);
            constructor.writeInstanceField(FieldDescriptor.of((String)annotationLiteral.getClassName(), (String)annotationMember.name(), (String)type), constructor.getThis(), constructor.getMethodParam(constructorParameterIndex));
            MethodCreator value = (MethodCreator)annotationLiteral.getMethodCreator(annotationMember.name(), type, new String[0]).setModifiers(1);
            value.returnValue(value.readInstanceField(FieldDescriptor.of((String)annotationLiteral.getClassName(), (String)annotationMember.name(), (String)type), value.getThis()));
            ++constructorParameterIndex;
        }
        constructor.returnValue(null);
        AnnotationLiteralGenerator.generateStaticFieldsWithDefaultValues(annotationLiteral, literal.annotationMembers());
        annotationLiteral.close();
        LOGGER.debugf("Annotation literal class generated: %s", (Object)literal.generatedClassName);
    }

    static String defaultValueStaticFieldName(MethodInfo annotationMember) {
        return annotationMember.name() + "_default_value";
    }

    private static boolean returnsClassOrClassArray(MethodInfo annotationMember) {
        boolean returnsClass = DotNames.CLASS.equals((Object)annotationMember.returnType().name());
        boolean returnsClassArray = annotationMember.returnType().kind() == Type.Kind.ARRAY && DotNames.CLASS.equals((Object)annotationMember.returnType().asArrayType().component().name());
        return returnsClass || returnsClassArray;
    }

    private static void generateStaticFieldsWithDefaultValues(ClassCreator classCreator, List<MethodInfo> annotationMembers) {
        ArrayList<MethodInfo> defaultOfClassType = new ArrayList<MethodInfo>();
        for (MethodInfo annotationMember : annotationMembers) {
            if (annotationMember.defaultValue() == null || !AnnotationLiteralGenerator.returnsClassOrClassArray(annotationMember)) continue;
            defaultOfClassType.add(annotationMember);
        }
        if (defaultOfClassType.isEmpty()) {
            return;
        }
        MethodCreator staticConstructor = classCreator.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);
        staticConstructor.setModifiers(8);
        for (MethodInfo annotationMember : defaultOfClassType) {
            String type = annotationMember.returnType().name().toString();
            AnnotationValue defaultValue = annotationMember.defaultValue();
            FieldCreator fieldCreator = classCreator.getFieldCreator(AnnotationLiteralGenerator.defaultValueStaticFieldName(annotationMember), type);
            fieldCreator.setModifiers(25);
            if (defaultValue.kind() == AnnotationValue.Kind.ARRAY) {
                Type[] clazzArray = defaultValue.asClassArray();
                ResultHandle array = staticConstructor.newArray(type, clazzArray.length);
                for (int i = 0; i < clazzArray.length; ++i) {
                    staticConstructor.writeArrayValue(array, staticConstructor.load(i), staticConstructor.loadClass(clazzArray[i].name().toString()));
                }
                staticConstructor.writeStaticField(fieldCreator.getFieldDescriptor(), array);
                continue;
            }
            staticConstructor.writeStaticField(fieldCreator.getFieldDescriptor(), staticConstructor.loadClass(defaultValue.asClass().name().toString()));
        }
        staticConstructor.returnValue(null);
    }
}

