/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.check;

import org.jboss.byteman.agent.check.ClassChecker;
import org.jboss.byteman.agent.check.ClassStructureAdapter;
import org.jboss.byteman.objectweb.asm.ClassReader;
import org.jboss.byteman.rule.type.TypeHelper;

public class BytecodeChecker
implements ClassChecker {
    private boolean isInterface;
    private String[] interfaces;
    private String superName;
    private String outerClass;
    private int bytesize;

    public BytecodeChecker(byte[] buffer) {
        ClassReader cr = new ClassReader(buffer);
        ClassStructureAdapter adapter = new ClassStructureAdapter();
        cr.accept(adapter, 7);
        this.isInterface = adapter.isInterface();
        this.interfaces = adapter.getInterfaces();
        for (int i = 0; i < this.interfaces.length; ++i) {
            this.interfaces[i] = TypeHelper.internalizeClass(this.interfaces[i]);
        }
        this.superName = adapter.getSuper();
        if (this.superName != null) {
            this.superName = TypeHelper.internalizeClass(this.superName);
        }
        this.outerClass = adapter.getOuterClass();
        this.bytesize = buffer.length;
    }

    @Override
    public boolean isInterface() {
        return this.isInterface;
    }

    @Override
    public String getSuper() {
        return this.superName;
    }

    @Override
    public boolean hasOuterClass() {
        return this.outerClass != null;
    }

    @Override
    public int getInterfaceCount() {
        return this.interfaces.length;
    }

    @Override
    public String getInterface(int idx) {
        return this.interfaces[idx];
    }

    public int getBytesize() {
        return this.bytesize;
    }
}

