/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.management;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanConstructorInfoSupport;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import twitter4j.management.APIStatistics;
import twitter4j.management.APIStatisticsMBean;
import twitter4j.management.InvocationStatistics;

public class APIStatisticsOpenMBean
implements DynamicMBean {
    private static final String[] ITEM_NAMES = new String[]{"methodName", "callCount", "errorCount", "totalTime", "avgTime"};
    private static final OpenType[] ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG};
    private static final String[] ITEM_DESCRIPTIONS = new String[]{"The method name", "The number of times this method has been called", "The number of calls that failed", "The total amount of time spent invoking this method in milliseconds", "The average amount of time spent invoking this method in milliseconds"};
    private final CompositeType METHOD_STATS_TYPE;
    private final APIStatisticsMBean API_STATISTICS;
    private final TabularType API_STATISTICS_TYPE;

    public APIStatisticsOpenMBean(APIStatistics apiStatistics) {
        this.API_STATISTICS = apiStatistics;
        try {
            this.METHOD_STATS_TYPE = new CompositeType("method statistics", "method statistics", ITEM_NAMES, ITEM_DESCRIPTIONS, ITEM_TYPES);
            String[] index = new String[]{"methodName"};
            this.API_STATISTICS_TYPE = new TabularType("API statistics", "list of methods", this.METHOD_STATS_TYPE, index);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        OpenMBeanAttributeInfo[] attributes = new OpenMBeanAttributeInfoSupport[5];
        OpenMBeanConstructorInfo[] constructors = new OpenMBeanConstructorInfoSupport[1];
        OpenMBeanOperationInfo[] operations = new OpenMBeanOperationInfoSupport[1];
        MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[]{};
        int attrIdx = 0;
        attributes[attrIdx++] = new OpenMBeanAttributeInfoSupport("callCount", "Total number of API calls", SimpleType.LONG, true, false, false);
        attributes[attrIdx++] = new OpenMBeanAttributeInfoSupport("errorCount", "The number of failed API calls", SimpleType.LONG, true, false, false);
        attributes[attrIdx++] = new OpenMBeanAttributeInfoSupport("averageTime", "Average time spent invoking any API method", SimpleType.LONG, true, false, false);
        attributes[attrIdx++] = new OpenMBeanAttributeInfoSupport("totalTime", "Average time spent invoking any API method", SimpleType.LONG, true, false, false);
        attributes[attrIdx++] = new OpenMBeanAttributeInfoSupport("statisticsTable", "Table of statisics for all API methods", this.API_STATISTICS_TYPE, true, false, false);
        constructors[0] = new OpenMBeanConstructorInfoSupport("APIStatisticsOpenMBean", "Constructs an APIStatisticsOpenMBean instance", new OpenMBeanParameterInfoSupport[0]);
        OpenMBeanParameterInfo[] params = new OpenMBeanParameterInfoSupport[]{};
        operations[0] = new OpenMBeanOperationInfoSupport("reset", "reset the statistics", params, SimpleType.VOID, 0);
        OpenMBeanInfoSupport info = new OpenMBeanInfoSupport(this.getClass().getName(), "API Statistics Open MBean", attributes, constructors, operations, notifications);
        return info;
    }

    public synchronized TabularDataSupport getStatistics() {
        TabularDataSupport apiStatisticsTable = new TabularDataSupport(this.API_STATISTICS_TYPE);
        for (InvocationStatistics invocationStatistics : this.API_STATISTICS.getInvocationStatistics()) {
            Object[] itemValues = new Object[]{invocationStatistics.getName(), invocationStatistics.getCallCount(), invocationStatistics.getErrorCount(), invocationStatistics.getTotalTime(), invocationStatistics.getAverageTime()};
            try {
                CompositeDataSupport result = new CompositeDataSupport(this.METHOD_STATS_TYPE, ITEM_NAMES, itemValues);
                apiStatisticsTable.put(result);
            }
            catch (OpenDataException e) {
                throw new RuntimeException(e);
            }
        }
        return apiStatisticsTable;
    }

    public void reset() {
        this.API_STATISTICS.reset();
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        switch (attribute) {
            case "statisticsTable": {
                return this.getStatistics();
            }
            case "callCount": {
                return this.API_STATISTICS.getCallCount();
            }
            case "errorCount": {
                return this.API_STATISTICS.getErrorCount();
            }
            case "totalTime": {
                return this.API_STATISTICS.getTotalTime();
            }
            case "averageTime": {
                return this.API_STATISTICS.getAverageTime();
            }
        }
        throw new AttributeNotFoundException("Cannot find " + attribute + " attribute ");
    }

    @Override
    public AttributeList getAttributes(String[] attributeNames) {
        AttributeList resultList = new AttributeList();
        if (attributeNames.length == 0) {
            return resultList;
        }
        for (String attributeName : attributeNames) {
            try {
                Object value = this.getAttribute(attributeName);
                resultList.add(new Attribute(attributeName, value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName.equals("reset")) {
            this.reset();
            return "Statistics reset";
        }
        throw new ReflectionException(new NoSuchMethodException(actionName), "Cannot find the operation " + actionName);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException("No attributes can be set in this MBean");
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return new AttributeList();
    }
}

