/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.backup.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.BackupManager;
import org.infinispan.server.core.backup.resources.AbstractContainerResource;
import org.infinispan.server.core.backup.resources.SecurityActions;
import org.infinispan.util.concurrent.BlockingManager;

class CacheConfigResource
extends AbstractContainerResource {
    private final ParserRegistry parserRegistry;
    private final EmbeddedCacheManager cm;

    CacheConfigResource(BlockingManager blockingManager, ParserRegistry parserRegistry, EmbeddedCacheManager cm, BackupManager.Resources params, Path root) {
        super(BackupManager.Resources.Type.TEMPLATES, params, blockingManager, root);
        this.cm = cm;
        this.parserRegistry = parserRegistry;
    }

    @Override
    public void prepareAndValidateBackup() {
        Set configs = this.wildcard ? this.cm.getCacheConfigurationNames() : this.resources;
        for (String configName : configs) {
            Configuration config = SecurityActions.getCacheConfiguration(this.cm, configName);
            if (this.wildcard) {
                if (!config.isTemplate()) continue;
                this.resources.add(configName);
                continue;
            }
            if (config == null) {
                throw log.unableToFindResource(this.type.toString(), configName);
            }
            if (config.isTemplate()) continue;
            throw new CacheException(String.format("Unable to backup %s '%s' as it is not a template", new Object[]{this.type, configName}));
        }
    }

    @Override
    public CompletionStage<Void> backup() {
        return this.blockingManager.runBlocking(() -> {
            this.mkdirs(this.root);
            for (String configName : this.resources) {
                Configuration config = SecurityActions.getCacheConfiguration(this.cm, configName);
                String fileName = this.configFile(configName);
                Path xmlPath = this.root.resolve(String.format("%s.xml", configName));
                try (OutputStream os = Files.newOutputStream(xmlPath, new OpenOption[0]);){
                    this.parserRegistry.serialize(os, configName, config);
                }
                catch (IOException e) {
                    throw new CacheException(String.format("Unable to create backup file '%s'", fileName), (Throwable)e);
                }
                log.debugf("Backing up template %s: %s", configName, config.toStringConfiguration(configName));
            }
        }, (Object)"cache-config-write");
    }

    @Override
    public CompletionStage<Void> restore(ZipFile zip) {
        return this.blockingManager.runBlocking(() -> {
            for (String configName : this.resources) {
                String configFile = this.configFile(configName);
                String zipPath = this.root.resolve(configFile).toString();
                ZipEntry entry = zip.getEntry(zipPath);
                try {
                    InputStream is = zip.getInputStream(entry);
                    try {
                        ConfigurationBuilderHolder builderHolder = this.parserRegistry.parse(is, null, MediaType.fromExtension((String)entry.getName()));
                        ConfigurationBuilder builder = (ConfigurationBuilder)builderHolder.getNamedConfigurationBuilders().get(configName);
                        Configuration cfg = builder.template(true).build();
                        SecurityActions.getOrCreateTemplate(this.cm, configName, cfg);
                        log.debugf("Restoring template %s: %s", configName, cfg.toStringConfiguration(configName));
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException e) {
                    throw new CacheException((Throwable)e);
                }
            }
        }, (Object)"cache-config-read");
    }

    private String configFile(String config) {
        return String.format("%s.xml", config);
    }
}

