/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.InjectableReferenceProvider;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.CurrentInjectionPointProvider;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;

public final class InjectableReferenceProviders {
    private InjectableReferenceProviders() {
    }

    public static <T> void destroy(InjectableReferenceProvider<T> provider, T instance, CreationalContext<T> creationalContext) {
        if (provider instanceof CurrentInjectionPointProvider) {
            provider = ((CurrentInjectionPointProvider)provider).getDelegate();
        }
        if (provider instanceof Contextual) {
            Contextual contextual = (Contextual)provider;
            contextual.destroy(instance, creationalContext);
            CreationalContextImpl<T> ctx = CreationalContextImpl.unwrap(creationalContext);
            CreationalContextImpl<?> parent = ctx.getParent();
            if (parent != null) {
                parent.removeDependentInstance(instance, false);
            }
        } else {
            throw new IllegalArgumentException("Injetable reference provider is not a bean: " + provider.getClass());
        }
    }
}

