/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.delegate;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelIllegalStateException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;

public class ClientModelLazyDelegate
implements ClientModel {
    private final Supplier<ClientModel> delegateSupplier;
    private final AtomicMarkableReference<ClientModel> delegate = new AtomicMarkableReference<Object>(null, false);

    public ClientModelLazyDelegate(Supplier<ClientModel> delegateSupplier) {
        this.delegateSupplier = delegateSupplier;
    }

    private ClientModel getDelegate() {
        ClientModel ref;
        if (!this.delegate.isMarked()) {
            this.delegate.compareAndSet(null, this.delegateSupplier == null ? null : this.delegateSupplier.get(), false, true);
        }
        if ((ref = this.delegate.getReference()) == null) {
            throw new ModelIllegalStateException("Invalid delegate obtained");
        }
        return ref;
    }

    public void updateClient() {
        this.getDelegate().updateClient();
    }

    public String getId() {
        return this.getDelegate().getId();
    }

    public String getClientId() {
        return this.getDelegate().getClientId();
    }

    public void setClientId(String clientId) {
        this.getDelegate().setClientId(clientId);
    }

    public String getName() {
        return this.getDelegate().getName();
    }

    public void setName(String name) {
        this.getDelegate().setName(name);
    }

    public String getDescription() {
        return this.getDelegate().getDescription();
    }

    public void setDescription(String description) {
        this.getDelegate().setDescription(description);
    }

    public boolean isEnabled() {
        return this.getDelegate().isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.getDelegate().setEnabled(enabled);
    }

    public boolean isAlwaysDisplayInConsole() {
        return this.getDelegate().isAlwaysDisplayInConsole();
    }

    public void setAlwaysDisplayInConsole(boolean alwaysDisplayInConsole) {
        this.getDelegate().setAlwaysDisplayInConsole(alwaysDisplayInConsole);
    }

    public boolean isSurrogateAuthRequired() {
        return this.getDelegate().isSurrogateAuthRequired();
    }

    public void setSurrogateAuthRequired(boolean surrogateAuthRequired) {
        this.getDelegate().setSurrogateAuthRequired(surrogateAuthRequired);
    }

    public Set<String> getWebOrigins() {
        return this.getDelegate().getWebOrigins();
    }

    public void setWebOrigins(Set<String> webOrigins) {
        this.getDelegate().setWebOrigins(webOrigins);
    }

    public void addWebOrigin(String webOrigin) {
        this.getDelegate().addWebOrigin(webOrigin);
    }

    public void removeWebOrigin(String webOrigin) {
        this.getDelegate().removeWebOrigin(webOrigin);
    }

    public Set<String> getRedirectUris() {
        return this.getDelegate().getRedirectUris();
    }

    public void setRedirectUris(Set<String> redirectUris) {
        this.getDelegate().setRedirectUris(redirectUris);
    }

    public void addRedirectUri(String redirectUri) {
        this.getDelegate().addRedirectUri(redirectUri);
    }

    public void removeRedirectUri(String redirectUri) {
        this.getDelegate().removeRedirectUri(redirectUri);
    }

    public String getManagementUrl() {
        return this.getDelegate().getManagementUrl();
    }

    public void setManagementUrl(String url) {
        this.getDelegate().setManagementUrl(url);
    }

    public String getRootUrl() {
        return this.getDelegate().getRootUrl();
    }

    public void setRootUrl(String url) {
        this.getDelegate().setRootUrl(url);
    }

    public String getBaseUrl() {
        return this.getDelegate().getBaseUrl();
    }

    public void setBaseUrl(String url) {
        this.getDelegate().setBaseUrl(url);
    }

    public boolean isBearerOnly() {
        return this.getDelegate().isBearerOnly();
    }

    public void setBearerOnly(boolean only) {
        this.getDelegate().setBearerOnly(only);
    }

    public int getNodeReRegistrationTimeout() {
        return this.getDelegate().getNodeReRegistrationTimeout();
    }

    public void setNodeReRegistrationTimeout(int timeout) {
        this.getDelegate().setNodeReRegistrationTimeout(timeout);
    }

    public String getClientAuthenticatorType() {
        return this.getDelegate().getClientAuthenticatorType();
    }

    public void setClientAuthenticatorType(String clientAuthenticatorType) {
        this.getDelegate().setClientAuthenticatorType(clientAuthenticatorType);
    }

    public boolean validateSecret(String secret) {
        return this.getDelegate().validateSecret(secret);
    }

    public String getSecret() {
        return this.getDelegate().getSecret();
    }

    public void setSecret(String secret) {
        this.getDelegate().setSecret(secret);
    }

    public String getRegistrationToken() {
        return this.getDelegate().getRegistrationToken();
    }

    public void setRegistrationToken(String registrationToken) {
        this.getDelegate().setRegistrationToken(registrationToken);
    }

    public String getProtocol() {
        return this.getDelegate().getProtocol();
    }

    public void setProtocol(String protocol) {
        this.getDelegate().setProtocol(protocol);
    }

    public void setAttribute(String name, String value) {
        this.getDelegate().setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.getDelegate().removeAttribute(name);
    }

    public String getAttribute(String name) {
        return this.getDelegate().getAttribute(name);
    }

    public Map<String, String> getAttributes() {
        return this.getDelegate().getAttributes();
    }

    public String getAuthenticationFlowBindingOverride(String binding) {
        return this.getDelegate().getAuthenticationFlowBindingOverride(binding);
    }

    public Map<String, String> getAuthenticationFlowBindingOverrides() {
        return this.getDelegate().getAuthenticationFlowBindingOverrides();
    }

    public void removeAuthenticationFlowBindingOverride(String binding) {
        this.getDelegate().removeAuthenticationFlowBindingOverride(binding);
    }

    public void setAuthenticationFlowBindingOverride(String binding, String flowId) {
        this.getDelegate().setAuthenticationFlowBindingOverride(binding, flowId);
    }

    public boolean isFrontchannelLogout() {
        return this.getDelegate().isFrontchannelLogout();
    }

    public void setFrontchannelLogout(boolean flag) {
        this.getDelegate().setFrontchannelLogout(flag);
    }

    public boolean isFullScopeAllowed() {
        return this.getDelegate().isFullScopeAllowed();
    }

    public void setFullScopeAllowed(boolean value) {
        this.getDelegate().setFullScopeAllowed(value);
    }

    public boolean isPublicClient() {
        return this.getDelegate().isPublicClient();
    }

    public void setPublicClient(boolean flag) {
        this.getDelegate().setPublicClient(flag);
    }

    public boolean isConsentRequired() {
        return this.getDelegate().isConsentRequired();
    }

    public void setConsentRequired(boolean consentRequired) {
        this.getDelegate().setConsentRequired(consentRequired);
    }

    public boolean isStandardFlowEnabled() {
        return this.getDelegate().isStandardFlowEnabled();
    }

    public void setStandardFlowEnabled(boolean standardFlowEnabled) {
        this.getDelegate().setStandardFlowEnabled(standardFlowEnabled);
    }

    public boolean isImplicitFlowEnabled() {
        return this.getDelegate().isImplicitFlowEnabled();
    }

    public void setImplicitFlowEnabled(boolean implicitFlowEnabled) {
        this.getDelegate().setImplicitFlowEnabled(implicitFlowEnabled);
    }

    public boolean isDirectAccessGrantsEnabled() {
        return this.getDelegate().isDirectAccessGrantsEnabled();
    }

    public void setDirectAccessGrantsEnabled(boolean directAccessGrantsEnabled) {
        this.getDelegate().setDirectAccessGrantsEnabled(directAccessGrantsEnabled);
    }

    public boolean isServiceAccountsEnabled() {
        return this.getDelegate().isServiceAccountsEnabled();
    }

    public void setServiceAccountsEnabled(boolean serviceAccountsEnabled) {
        this.getDelegate().setServiceAccountsEnabled(serviceAccountsEnabled);
    }

    public RealmModel getRealm() {
        return this.getDelegate().getRealm();
    }

    public void addClientScope(ClientScopeModel clientScope, boolean defaultScope) {
        this.getDelegate().addClientScope(clientScope, defaultScope);
    }

    public void addClientScopes(Set<ClientScopeModel> clientScopes, boolean defaultScope) {
        this.getDelegate().addClientScopes(clientScopes, defaultScope);
    }

    public void removeClientScope(ClientScopeModel clientScope) {
        this.getDelegate().removeClientScope(clientScope);
    }

    public Map<String, ClientScopeModel> getClientScopes(boolean defaultScope) {
        return this.getDelegate().getClientScopes(defaultScope);
    }

    public ClientScopeModel getDynamicClientScope(String scope) {
        return this.getDelegate().getDynamicClientScope(scope);
    }

    public int getNotBefore() {
        return this.getDelegate().getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.getDelegate().setNotBefore(notBefore);
    }

    public Map<String, Integer> getRegisteredNodes() {
        return this.getDelegate().getRegisteredNodes();
    }

    public void registerNode(String nodeHost, int registrationTime) {
        this.getDelegate().registerNode(nodeHost, registrationTime);
    }

    public void unregisterNode(String nodeHost) {
        this.getDelegate().unregisterNode(nodeHost);
    }

    public boolean isDisplayOnConsentScreen() {
        return this.getDelegate().isDisplayOnConsentScreen();
    }

    public String getConsentScreenText() {
        return this.getDelegate().getConsentScreenText();
    }

    public void setDisplayOnConsentScreen(boolean displayOnConsentScreen) {
        this.getDelegate().setDisplayOnConsentScreen(displayOnConsentScreen);
    }

    public void setConsentScreenText(String consentScreenText) {
        this.getDelegate().setConsentScreenText(consentScreenText);
    }

    public String getGuiOrder() {
        return this.getDelegate().getGuiOrder();
    }

    public void setGuiOrder(String guiOrder) {
        this.getDelegate().setGuiOrder(guiOrder);
    }

    public boolean isIncludeInTokenScope() {
        return this.getDelegate().isIncludeInTokenScope();
    }

    public void setIncludeInTokenScope(boolean includeInTokenScope) {
        this.getDelegate().setIncludeInTokenScope(includeInTokenScope);
    }

    public boolean isDynamicScope() {
        return this.getDelegate().isDynamicScope();
    }

    public void setIsDynamicScope(boolean isDynamicScope) {
        this.getDelegate().setIsDynamicScope(isDynamicScope);
    }

    public String getDynamicScopeRegexp() {
        return this.getDelegate().getDynamicScopeRegexp();
    }

    public Stream<RoleModel> getScopeMappingsStream() {
        return this.getDelegate().getScopeMappingsStream();
    }

    public Stream<RoleModel> getRealmScopeMappingsStream() {
        return this.getDelegate().getRealmScopeMappingsStream();
    }

    public void addScopeMapping(RoleModel role) {
        this.getDelegate().addScopeMapping(role);
    }

    public void deleteScopeMapping(RoleModel role) {
        this.getDelegate().deleteScopeMapping(role);
    }

    public boolean hasDirectScope(RoleModel role) {
        return this.getDelegate().hasDirectScope(role);
    }

    public boolean hasScope(RoleModel role) {
        return this.getDelegate().hasScope(role);
    }

    public RoleModel getRole(String name) {
        return this.getDelegate().getRole(name);
    }

    public RoleModel addRole(String name) {
        return this.getDelegate().addRole(name);
    }

    public RoleModel addRole(String id, String name) {
        return this.getDelegate().addRole(id, name);
    }

    public boolean removeRole(RoleModel role) {
        return this.getDelegate().removeRole(role);
    }

    public Stream<RoleModel> getRolesStream() {
        return this.getDelegate().getRolesStream();
    }

    public Stream<RoleModel> getRolesStream(Integer firstResult, Integer maxResults) {
        return this.getDelegate().getRolesStream(firstResult, maxResults);
    }

    public Stream<RoleModel> searchForRolesStream(String search, Integer first, Integer max) {
        return this.getDelegate().searchForRolesStream(search, first, max);
    }

    public Stream<String> getDefaultRolesStream() {
        return this.getDelegate().getDefaultRolesStream();
    }

    public void addDefaultRole(String name) {
        this.getDelegate().addDefaultRole(name);
    }

    public void updateDefaultRoles(String ... defaultRoles) {
        this.getDelegate().updateDefaultRoles(defaultRoles);
    }

    public void removeDefaultRoles(String ... defaultRoles) {
        this.getDelegate().removeDefaultRoles(defaultRoles);
    }

    public Stream<ProtocolMapperModel> getProtocolMappersStream() {
        return this.getDelegate().getProtocolMappersStream();
    }

    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        return this.getDelegate().addProtocolMapper(model);
    }

    public void removeProtocolMapper(ProtocolMapperModel mapping) {
        this.getDelegate().removeProtocolMapper(mapping);
    }

    public void updateProtocolMapper(ProtocolMapperModel mapping) {
        this.getDelegate().updateProtocolMapper(mapping);
    }

    public ProtocolMapperModel getProtocolMapperById(String id) {
        return this.getDelegate().getProtocolMapperById(id);
    }

    public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
        return this.getDelegate().getProtocolMapperByName(protocol, name);
    }

    public static class WithId
    extends ClientModelLazyDelegate {
        private final String id;

        public WithId(String id, Supplier<ClientModel> delegateSupplier) {
            super(delegateSupplier);
            this.id = id;
        }

        public WithId(KeycloakSession session, RealmModel realm, String id) {
            super(() -> session.clients().getClientById(realm, id));
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof ClientModel)) {
                return false;
            }
            ClientModel that = (ClientModel)o;
            return that.getId().equals(this.getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }
    }
}

