/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient;

import com.openshift.internal.restclient.ApiTypeMapper;
import com.openshift.internal.restclient.AuthorizationEndpoints;
import com.openshift.internal.restclient.OpenShiftMajorVersion;
import com.openshift.internal.restclient.RequestingSupplier;
import com.openshift.internal.restclient.URLBuilder;
import com.openshift.internal.restclient.authorization.AuthorizationContext;
import com.openshift.internal.restclient.capability.CapabilityInitializer;
import com.openshift.internal.restclient.okhttp.OpenShiftRequestBuilder;
import com.openshift.internal.restclient.okhttp.WatchClient;
import com.openshift.restclient.IApiTypeMapper;
import com.openshift.restclient.IClient;
import com.openshift.restclient.IOpenShiftWatchListener;
import com.openshift.restclient.IResourceFactory;
import com.openshift.restclient.IWatcher;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.UnsupportedOperationException;
import com.openshift.restclient.api.ITypeFactory;
import com.openshift.restclient.authorization.IAuthorizationContext;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.ICapability;
import com.openshift.restclient.http.IHttpConstants;
import com.openshift.restclient.model.IList;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.JSONSerializeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.dmr.ModelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClient
implements IClient,
IHttpConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClient.class);
    public static final String PATH_KUBERNETES_VERSION = "version";
    public static final String PATH_OPENSHIFT_VERSION = "version/openshift";
    public static final String PATH_HEALTH_CHECK = "healthz";
    public static final String PATH_DEFAULT_OAUTH_TOKEN = "oauth/token";
    public static final String PATH_DEFAULT_OAUTH_AUTHORIZE = "oauth/authorize";
    public static final String SYSTEM_PROP_K8E_API_VERSION = "osjc.k8e.apiversion";
    public static final String SYSTEM_PROP_OPENSHIFT_API_VERSION = "osjc.openshift.apiversion";
    private static final String OS_API_ENDPOINT = "oapi";
    private URL baseUrl;
    private OkHttpClient client;
    private IResourceFactory factory;
    private Map<Class<? extends ICapability>, ICapability> capabilities = new HashMap<Class<? extends ICapability>, ICapability>();
    private boolean capabilitiesInitialized = false;
    private final AuthorizationContext authContext;
    private final IApiTypeMapper typeMapper;
    private final ClusterVersion kubernetesVersion;
    private final ClusterVersion openShiftVersion;
    private final AuthorizationEndpoints authorizationEndpoints;
    private OpenShiftMajorVersion openShiftMajorVersion;

    public DefaultClient(URL baseUrl, OkHttpClient client, IResourceFactory factory, IApiTypeMapper typeMapper, AuthorizationContext authContext) {
        this.baseUrl = baseUrl;
        this.client = client;
        this.factory = factory;
        if (this.factory != null) {
            this.factory.setClient(this);
        }
        this.typeMapper = typeMapper != null ? typeMapper : new ApiTypeMapper(baseUrl.toString(), client, authContext);
        this.authContext = authContext;
        this.kubernetesVersion = new ClusterVersion(baseUrl.toExternalForm() + "/" + PATH_KUBERNETES_VERSION, "Kubernetes Version", client);
        this.openShiftVersion = new ClusterVersion(baseUrl.toExternalForm() + "/" + PATH_OPENSHIFT_VERSION, "OpenShift Version", client);
        this.authorizationEndpoints = new AuthorizationEndpoints(baseUrl.toExternalForm(), client);
    }

    @Override
    public IClient clone() {
        AuthorizationContext context = this.authContext.clone();
        DefaultClient clone = new DefaultClient(this.baseUrl, this.client, this.factory, this.typeMapper, context);
        context.setClient(clone);
        return clone;
    }

    @Override
    public IResourceFactory getResourceFactory() {
        return this.factory;
    }

    @Override
    public IWatcher watch(String namespace, IOpenShiftWatchListener listener, String ... kinds) {
        WatchClient watcher = new WatchClient(this, this.typeMapper, this.client);
        return watcher.watch(Arrays.asList(kinds), namespace, listener);
    }

    @Override
    public IWatcher watch(IOpenShiftWatchListener listener, String ... kinds) {
        return this.watch("", listener, kinds);
    }

    @Override
    public String getResourceURI(IResource resource) {
        return new URLBuilder(this.getBaseURL(), this.typeMapper, resource).build().toString();
    }

    @Override
    public <T extends IResource> List<T> list(String kind) {
        return this.list(kind, "");
    }

    @Override
    public <T extends IResource> List<T> list(String kind, Map<String, String> labels) {
        return this.list(kind, "", labels);
    }

    @Override
    public <T extends IResource> List<T> list(String kind, String namespace) {
        return this.list(kind, namespace, new HashMap<String, String>());
    }

    @Override
    public <T extends IResource> List<T> list(String kind, String namespace, Map<String, String> labels) {
        String labelQuery = "";
        if (labels != null && !labels.isEmpty()) {
            labelQuery = labels.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(","));
        }
        return this.list(kind, namespace, labelQuery);
    }

    @Override
    public <T extends IResource> List<T> list(String kind, String namespace, String labelQuery) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (labelQuery != null && !labelQuery.isEmpty()) {
            params.put("labelSelector", labelQuery);
        }
        IList resources = (IList)this.execute(HttpMethod.GET.toString(), kind, namespace, null, null, null, params);
        ArrayList<IResource> items = new ArrayList<IResource>();
        items.addAll(resources.getItems());
        return items;
    }

    @Override
    public Collection<IResource> create(IList list, String namespace) {
        ArrayList<IResource> results = new ArrayList<IResource>(list.getItems().size());
        for (IResource resource : list.getItems()) {
            try {
                results.add(this.create(resource, namespace));
            }
            catch (OpenShiftException e) {
                if (e.getStatus() != null) {
                    results.add(e.getStatus());
                    continue;
                }
                throw e;
            }
        }
        return results;
    }

    @Override
    public <T extends IResource> T create(T resource) {
        return this.create(resource, resource.getNamespaceName());
    }

    @Override
    public <T extends IResource> T create(T resource, String namespace) {
        return this.execute(HttpMethod.POST, resource.getKind(), namespace, null, null, resource);
    }

    @Override
    public <T extends IResource> T create(String kind, String namespace, String name, String subresource, IResource payload) {
        return this.execute(HttpMethod.POST, kind, namespace, name, subresource, payload);
    }

    @Override
    public <T extends IResource> T create(String kind, String version, String namespace, String name, String subresource, InputStream payload) {
        return this.create(kind, version, namespace, name, subresource, payload, Collections.emptyMap());
    }

    @Override
    public <T extends IResource> T create(String kind, String version, String namespace, String name, String subresource, InputStream payload, Map<String, String> parameters) {
        return this.execute(HttpMethod.POST, kind, version, namespace, name, subresource, payload, parameters);
    }

    private <T extends IResource> T execute(HttpMethod method, String kind, String namespace, String name, String subresource, IResource payload) {
        return this.execute(method.toString(), kind, namespace, name, subresource, payload);
    }

    private <T extends IResource> T execute(HttpMethod method, String kind, String version, String namespace, String name, String subresource, InputStream payload, Map<String, String> parameters) {
        return this.execute(method.toString(), kind, version, namespace, name, subresource, payload, parameters);
    }

    @Override
    public <T extends IResource> T execute(String method, String kind, String namespace, String name, String subresource, IResource payload, String subContext) {
        return (T)((IResource)this.execute(this.factory, method, kind, namespace, name, subresource, subContext, payload, Collections.emptyMap()));
    }

    @Override
    public <T extends IResource> T execute(String method, String kind, String namespace, String name, String subresource, IResource payload) {
        return (T)((IResource)this.execute(this.factory, method, kind, namespace, name, subresource, null, payload, Collections.emptyMap()));
    }

    @Override
    public <T extends IResource> T execute(String method, String kind, String version, String namespace, String name, String subresource, InputStream payload) {
        return (T)((IResource)this.execute((ITypeFactory)this.factory, method, kind, version, namespace, name, subresource, null, payload, Collections.emptyMap()));
    }

    @Override
    public <T extends IResource> T execute(String method, String kind, String version, String namespace, String name, String subresource, InputStream payload, Map<String, String> parameters) {
        return (T)((IResource)this.execute((ITypeFactory)this.factory, method, kind, version, namespace, name, subresource, null, payload, parameters));
    }

    @Override
    public <T extends IResource> T execute(String method, String kind, String namespace, String name, String subresource, IResource payload, Map<String, String> params) {
        return (T)((IResource)this.execute(this.factory, method, kind, namespace, name, subresource, null, payload, params));
    }

    public <T> T execute(ITypeFactory factory, String method, String kind, String version, String namespace, String name, String subresource, String subContext, InputStream payload, Map<String, String> params) {
        return this.execute(factory, method, kind, version, namespace, name, subresource, subContext, this.getPayload(payload, method), params);
    }

    @Override
    public <T> T execute(ITypeFactory factory, String method, String kind, String namespace, String name, String subresource, String subContext, JSONSerializeable payload, Map<String, String> params) {
        return this.execute(factory, method, kind, this.getApiVersion(payload), namespace, name, subresource, subContext, this.getPayload(payload, method), params);
    }

    private <T> T execute(ITypeFactory factory, String method, String kind, String version, String namespace, String name, String subresource, String subContext, RequestBody requestBody, Map<String, String> params) {
        if (factory == null) {
            throw new OpenShiftException(ITypeFactory.class.getSimpleName() + " is null while trying to call IClient#execute", new Object[0]);
        }
        if (params == null) {
            params = Collections.emptyMap();
        }
        if ("List".equals(kind)) {
            throw new UnsupportedOperationException("Generic create operation not supported for resource type 'List'");
        }
        URL endpoint = new URLBuilder(this.baseUrl, this.typeMapper).apiVersion(version).kind(kind).name(name).namespace(namespace).subresource(subresource).subContext(subContext).addParameters(params).build();
        Request request = this.newRequestBuilder().url(endpoint).method(method, requestBody).acceptJson().authorization(this.authContext).build();
        LOGGER.debug("About to make {} request: {}", (Object)request.method(), (Object)request);
        try {
            String body = this.request(request);
            return (T)factory.createInstanceFrom(body);
        }
        catch (IOException e) {
            throw new OpenShiftException((Throwable)e, "Unable to execute request to %s", endpoint);
        }
    }

    private String request(Request request) throws IOException {
        try (Response response = this.client.newCall(request).execute();){
            String body = response.body().string();
            LOGGER.debug("Response: {}", (Object)body);
            String string = body;
            return string;
        }
    }

    private String getApiVersion(JSONSerializeable payload) {
        String apiVersion = null;
        if (payload instanceof IResource) {
            apiVersion = ((IResource)payload).getApiVersion();
        }
        return apiVersion;
    }

    private RequestBody getPayload(JSONSerializeable payload, String method) {
        if (this.isPayloadlessMethod(method)) {
            return null;
        }
        String json = payload == null ? "" : payload.toJson(true);
        LOGGER.debug("About to send payload: {}", (Object)json);
        return RequestBody.create((String)json, (MediaType)MediaType.parse((String)"application/json;charset=utf-8"));
    }

    RequestBody getPayload(InputStream payload, String method) {
        if (this.isPayloadlessMethod(method)) {
            return null;
        }
        final InputStream input = payload == null ? IOUtils.toInputStream((String)"", (Charset)StandardCharsets.UTF_8) : payload;
        LOGGER.debug("About to send binary payload");
        return new RequestBody(){

            public void writeTo(BufferedSink sink) throws IOException {
                Source source = Okio.source((InputStream)input);
                sink.writeAll(source);
            }

            public MediaType contentType() {
                return MediaType.parse((String)"application/octet-stream");
            }
        };
    }

    private boolean isPayloadlessMethod(String method) {
        String uppercaseMethod = StringUtils.upperCase((String)method);
        return HttpMethod.GET.name().equals(uppercaseMethod) || HttpMethod.HEAD.name().equals(uppercaseMethod);
    }

    @Override
    public String getServerReadyStatus() {
        try {
            Request request = new Request.Builder().url(new URL(this.baseUrl, PATH_HEALTH_CHECK)).header("Accept", "*/*").build();
            return this.request(request);
        }
        catch (IOException e) {
            throw new OpenShiftException((Throwable)e, "Exception while trying to determine the health/ready response of the server", new Object[0]);
        }
    }

    protected OpenShiftRequestBuilder newRequestBuilder() {
        return new OpenShiftRequestBuilder();
    }

    @Override
    public <T extends IResource> T update(T resource) {
        return this.execute(HttpMethod.PUT, resource.getKind(), resource.getNamespaceName(), resource.getName(), null, resource);
    }

    @Override
    public <T extends IResource> void delete(T resource) {
        this.delete(resource.getKind(), resource.getNamespaceName(), resource.getName());
    }

    @Override
    public void delete(String resourceKind, String namespaceName, String name) {
        this.execute(HttpMethod.DELETE, resourceKind, namespaceName, name, null, null);
    }

    @Override
    public IList get(String kind, String namespace) {
        return (IList)this.execute(HttpMethod.GET, kind, namespace, null, null, (IResource)null);
    }

    @Override
    public <T extends IResource> T get(String kind, String name, String namespace) {
        return this.execute(HttpMethod.GET, kind, namespace, name, null, (IResource)null);
    }

    public synchronized void initializeCapabilities() {
        if (this.capabilitiesInitialized) {
            return;
        }
        CapabilityInitializer.initializeClientCapabilities(this.capabilities, this);
        this.capabilitiesInitialized = true;
    }

    @Override
    public <T extends ICapability> T getCapability(Class<T> capability) {
        return (T)this.capabilities.get(capability);
    }

    @Override
    public boolean supports(Class<? extends ICapability> capability) {
        if (!this.capabilitiesInitialized) {
            this.initializeCapabilities();
        }
        return this.capabilities.containsKey(capability);
    }

    @Override
    public <T extends ICapability, R> R accept(CapabilityVisitor<T, R> visitor, R unsupportedCapabililityValue) {
        if (!this.capabilitiesInitialized) {
            this.initializeCapabilities();
        }
        if (this.capabilities.containsKey(visitor.getCapabilityType())) {
            ICapability capability = this.capabilities.get(visitor.getCapabilityType());
            return visitor.visit(capability);
        }
        return unsupportedCapabililityValue;
    }

    @Override
    public String getOpenShiftAPIVersion() {
        return this.typeMapper.getPreferedVersionFor(OS_API_ENDPOINT);
    }

    @Override
    public String getOpenshiftMasterVersion() {
        return (String)this.openShiftVersion.get();
    }

    @Override
    public String getKubernetesMasterVersion() {
        return (String)this.kubernetesVersion.get();
    }

    @Override
    public URL getBaseURL() {
        return this.baseUrl;
    }

    @Override
    public URL getAuthorizationEndpoint() {
        URL url = this.authorizationEndpoints.getAuthorizationEndpoint();
        if (url != null) {
            return url;
        }
        return this.getDefaultAuthorizationEndpoint();
    }

    protected URL getDefaultAuthorizationEndpoint() {
        try {
            return new URL(this.getBaseURL(), PATH_DEFAULT_OAUTH_AUTHORIZE);
        }
        catch (MalformedURLException e) {
            throw new OpenShiftException((Throwable)e, e.getLocalizedMessage(), new Object[0]);
        }
    }

    @Override
    public URL getTokenEndpoint() {
        URL url = this.authorizationEndpoints.getTokenEndpoint();
        if (url != null) {
            return url;
        }
        return this.getDefaultTokenEndpoint();
    }

    protected URL getDefaultTokenEndpoint() {
        try {
            return new URL(this.getBaseURL(), PATH_DEFAULT_OAUTH_TOKEN);
        }
        catch (MalformedURLException e) {
            throw new OpenShiftException((Throwable)e, e.getLocalizedMessage(), new Object[0]);
        }
    }

    @Override
    public IAuthorizationContext getAuthorizationContext() {
        return this.authContext;
    }

    public void setToken(String token) {
        this.authContext.setToken(token);
    }

    public String getToken() {
        return this.getAuthorizationContext().getToken();
    }

    @Override
    public int getOpenShiftMajorVersion() {
        if (this.openShiftMajorVersion == null) {
            this.openShiftMajorVersion = new OpenShiftMajorVersion(this.getOpenShiftAPIVersion(), this.getKubernetesMasterVersion());
        }
        return this.openShiftMajorVersion.get();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.baseUrl == null ? 0 : this.baseUrl.toString().hashCode());
        result = 31 * result + (this.kubernetesVersion == null ? 0 : this.kubernetesVersion.hashCode());
        result = 31 * result + (this.openShiftVersion == null ? 0 : this.openShiftVersion.hashCode());
        result = 31 * result + (this.authContext == null || this.authContext.getToken() == null ? 0 : this.authContext.getToken().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultClient)) {
            return false;
        }
        DefaultClient other = (DefaultClient)obj;
        if (this.baseUrl == null ? other.baseUrl != null : !this.baseUrl.toString().equals(other.baseUrl.toString())) {
            return false;
        }
        if (this.authContext == null) {
            return other.authContext == null;
        }
        if (other.authContext == null) {
            return false;
        }
        return Objects.equals(this.authContext.getUserName(), other.authContext.getUserName());
    }

    @Override
    public <T> T adapt(Class<T> klass) {
        if (DefaultClient.class.equals(klass)) {
            return (T)this;
        }
        if (OkHttpClient.class.equals(klass)) {
            return (T)this.client;
        }
        if (IApiTypeMapper.class.equals(klass)) {
            return (T)this.typeMapper;
        }
        if (ICapability.class.isAssignableFrom(klass) && this.supports(klass)) {
            return this.getCapability(klass);
        }
        if (IResourceFactory.class.equals(klass)) {
            return (T)this.factory;
        }
        return null;
    }

    private class ClusterVersion
    extends RequestingSupplier<String> {
        protected ClusterVersion(String url, String description, OkHttpClient client) {
            super(url, description, client);
        }

        @Override
        protected String extractValue(String response) {
            try {
                return ModelNode.fromJSONString((String)response).get("gitVersion").asString();
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Could not retrieve {}: Invalid JSON.", (Object)this.description);
                return null;
            }
        }

        @Override
        protected String getDefaultValue() {
            return "";
        }
    }

    static enum HttpMethod {
        GET,
        PUT,
        POST,
        DELETE,
        HEAD;

    }
}

