/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class KubernetesVersion {
    public static final int NO_VERSION = -1;
    private static final Pattern REGEX_KUBERVERSION = Pattern.compile("v(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})(\\+(\\p{ASCII}+)){0,1}");
    private boolean detected = false;
    private int major = -1;
    private int minor = -1;
    private int patch = -1;
    private String git;

    public KubernetesVersion(String kubernetesVersion) {
        this.parse(kubernetesVersion);
    }

    private void parse(String kubernetesVersion) {
        this.reset();
        if (StringUtils.isEmpty((String)kubernetesVersion)) {
            return;
        }
        Matcher matcher = REGEX_KUBERVERSION.matcher(kubernetesVersion);
        if (!matcher.matches() || matcher.groupCount() < 5) {
            return;
        }
        try {
            this.detected = true;
            this.major = this.parseGroup(matcher.group(1));
            this.minor = this.parseGroup(matcher.group(2));
            this.patch = this.parseGroup(matcher.group(3));
            this.git = matcher.group(5);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private int parseGroup(String version) {
        return Integer.parseInt(version);
    }

    private void reset() {
        this.detected = false;
        this.major = -1;
        this.minor = -1;
        this.patch = -1;
        this.git = null;
    }

    public boolean isDetected() {
        return this.detected;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getGit() {
        return this.git;
    }
}

