/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.shaderc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct shaderc_spvc_binding_info")
public class ShadercSPVCBindingInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SET;
    public static final int BINDING;
    public static final int ID;
    public static final int BASE_TYPE_ID;
    public static final int BINDING_TYPE;
    public static final int TEXTURE_DIMENSION;
    public static final int TEXTURE_COMPONENT_TYPE;
    public static final int MULTISAMPLED;

    public ShadercSPVCBindingInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ShadercSPVCBindingInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int set() {
        return ShadercSPVCBindingInfo.nset(this.address());
    }

    @NativeType(value="uint32_t")
    public int binding() {
        return ShadercSPVCBindingInfo.nbinding(this.address());
    }

    @NativeType(value="uint32_t")
    public int id() {
        return ShadercSPVCBindingInfo.nid(this.address());
    }

    @NativeType(value="uint32_t")
    public int base_type_id() {
        return ShadercSPVCBindingInfo.nbase_type_id(this.address());
    }

    @NativeType(value="shaderc_spvc_binding_type")
    public int binding_type() {
        return ShadercSPVCBindingInfo.nbinding_type(this.address());
    }

    @NativeType(value="shaderc_spvc_texture_view_dimension")
    public int texture_dimension() {
        return ShadercSPVCBindingInfo.ntexture_dimension(this.address());
    }

    @NativeType(value="shaderc_spvc_texture_format_type")
    public int texture_component_type() {
        return ShadercSPVCBindingInfo.ntexture_component_type(this.address());
    }

    @NativeType(value="bool")
    public boolean multisampled() {
        return ShadercSPVCBindingInfo.nmultisampled(this.address());
    }

    public static ShadercSPVCBindingInfo malloc() {
        return (ShadercSPVCBindingInfo)ShadercSPVCBindingInfo.wrap(ShadercSPVCBindingInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static ShadercSPVCBindingInfo calloc() {
        return (ShadercSPVCBindingInfo)ShadercSPVCBindingInfo.wrap(ShadercSPVCBindingInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static ShadercSPVCBindingInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (ShadercSPVCBindingInfo)ShadercSPVCBindingInfo.wrap(ShadercSPVCBindingInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static ShadercSPVCBindingInfo create(long address) {
        return (ShadercSPVCBindingInfo)ShadercSPVCBindingInfo.wrap(ShadercSPVCBindingInfo.class, (long)address);
    }

    @Nullable
    public static ShadercSPVCBindingInfo createSafe(long address) {
        return address == 0L ? null : (ShadercSPVCBindingInfo)ShadercSPVCBindingInfo.wrap(ShadercSPVCBindingInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)ShadercSPVCBindingInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)ShadercSPVCBindingInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)ShadercSPVCBindingInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ShadercSPVCBindingInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)ShadercSPVCBindingInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)ShadercSPVCBindingInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)ShadercSPVCBindingInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static ShadercSPVCBindingInfo mallocStack() {
        return ShadercSPVCBindingInfo.mallocStack(MemoryStack.stackGet());
    }

    public static ShadercSPVCBindingInfo callocStack() {
        return ShadercSPVCBindingInfo.callocStack(MemoryStack.stackGet());
    }

    public static ShadercSPVCBindingInfo mallocStack(MemoryStack stack) {
        return (ShadercSPVCBindingInfo)ShadercSPVCBindingInfo.wrap(ShadercSPVCBindingInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ShadercSPVCBindingInfo callocStack(MemoryStack stack) {
        return (ShadercSPVCBindingInfo)ShadercSPVCBindingInfo.wrap(ShadercSPVCBindingInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return ShadercSPVCBindingInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return ShadercSPVCBindingInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)ShadercSPVCBindingInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)ShadercSPVCBindingInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nset(long struct) {
        return UNSAFE.getInt(null, struct + (long)SET);
    }

    public static int nbinding(long struct) {
        return UNSAFE.getInt(null, struct + (long)BINDING);
    }

    public static int nid(long struct) {
        return UNSAFE.getInt(null, struct + (long)ID);
    }

    public static int nbase_type_id(long struct) {
        return UNSAFE.getInt(null, struct + (long)BASE_TYPE_ID);
    }

    public static int nbinding_type(long struct) {
        return UNSAFE.getInt(null, struct + (long)BINDING_TYPE);
    }

    public static int ntexture_dimension(long struct) {
        return UNSAFE.getInt(null, struct + (long)TEXTURE_DIMENSION);
    }

    public static int ntexture_component_type(long struct) {
        return UNSAFE.getInt(null, struct + (long)TEXTURE_COMPONENT_TYPE);
    }

    public static boolean nmultisampled(long struct) {
        return UNSAFE.getByte(null, struct + (long)MULTISAMPLED) != 0;
    }

    static {
        Struct.Layout layout = ShadercSPVCBindingInfo.__struct((Struct.Member[])new Struct.Member[]{ShadercSPVCBindingInfo.__member((int)4), ShadercSPVCBindingInfo.__member((int)4), ShadercSPVCBindingInfo.__member((int)4), ShadercSPVCBindingInfo.__member((int)4), ShadercSPVCBindingInfo.__member((int)4), ShadercSPVCBindingInfo.__member((int)4), ShadercSPVCBindingInfo.__member((int)4), ShadercSPVCBindingInfo.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SET = layout.offsetof(0);
        BINDING = layout.offsetof(1);
        ID = layout.offsetof(2);
        BASE_TYPE_ID = layout.offsetof(3);
        BINDING_TYPE = layout.offsetof(4);
        TEXTURE_DIMENSION = layout.offsetof(5);
        TEXTURE_COMPONENT_TYPE = layout.offsetof(6);
        MULTISAMPLED = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<ShadercSPVCBindingInfo, Buffer>
    implements NativeResource {
        private static final ShadercSPVCBindingInfo ELEMENT_FACTORY = ShadercSPVCBindingInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected ShadercSPVCBindingInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int set() {
            return ShadercSPVCBindingInfo.nset(this.address());
        }

        @NativeType(value="uint32_t")
        public int binding() {
            return ShadercSPVCBindingInfo.nbinding(this.address());
        }

        @NativeType(value="uint32_t")
        public int id() {
            return ShadercSPVCBindingInfo.nid(this.address());
        }

        @NativeType(value="uint32_t")
        public int base_type_id() {
            return ShadercSPVCBindingInfo.nbase_type_id(this.address());
        }

        @NativeType(value="shaderc_spvc_binding_type")
        public int binding_type() {
            return ShadercSPVCBindingInfo.nbinding_type(this.address());
        }

        @NativeType(value="shaderc_spvc_texture_view_dimension")
        public int texture_dimension() {
            return ShadercSPVCBindingInfo.ntexture_dimension(this.address());
        }

        @NativeType(value="shaderc_spvc_texture_format_type")
        public int texture_component_type() {
            return ShadercSPVCBindingInfo.ntexture_component_type(this.address());
        }

        @NativeType(value="bool")
        public boolean multisampled() {
            return ShadercSPVCBindingInfo.nmultisampled(this.address());
        }
    }
}

