/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bullet;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct b3VisualShapeData")
public class B3VisualShapeData
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_OBJECTUNIQUEID;
    public static final int M_LINKINDEX;
    public static final int M_VISUALGEOMETRYTYPE;
    public static final int M_DIMENSIONS;
    public static final int M_MESHASSETFILENAME;
    public static final int M_LOCALVISUALFRAME;
    public static final int M_RGBACOLOR;
    public static final int M_TINYRENDERERTEXTUREID;
    public static final int M_TEXTUREUNIQUEID;
    public static final int M_OPENGLTEXTUREID;

    public B3VisualShapeData(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), B3VisualShapeData.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int m_objectUniqueId() {
        return B3VisualShapeData.nm_objectUniqueId(this.address());
    }

    public int m_linkIndex() {
        return B3VisualShapeData.nm_linkIndex(this.address());
    }

    public int m_visualGeometryType() {
        return B3VisualShapeData.nm_visualGeometryType(this.address());
    }

    @NativeType(value="double[3]")
    public DoubleBuffer m_dimensions() {
        return B3VisualShapeData.nm_dimensions(this.address());
    }

    public double m_dimensions(int index) {
        return B3VisualShapeData.nm_dimensions(this.address(), index);
    }

    @NativeType(value="char[VISUAL_SHAPE_MAX_PATH_LEN]")
    public ByteBuffer m_meshAssetFileName() {
        return B3VisualShapeData.nm_meshAssetFileName(this.address());
    }

    @NativeType(value="char[VISUAL_SHAPE_MAX_PATH_LEN]")
    public String m_meshAssetFileNameString() {
        return B3VisualShapeData.nm_meshAssetFileNameString(this.address());
    }

    @NativeType(value="double[7]")
    public DoubleBuffer m_localVisualFrame() {
        return B3VisualShapeData.nm_localVisualFrame(this.address());
    }

    public double m_localVisualFrame(int index) {
        return B3VisualShapeData.nm_localVisualFrame(this.address(), index);
    }

    @NativeType(value="double[4]")
    public DoubleBuffer m_rgbaColor() {
        return B3VisualShapeData.nm_rgbaColor(this.address());
    }

    public double m_rgbaColor(int index) {
        return B3VisualShapeData.nm_rgbaColor(this.address(), index);
    }

    public int m_tinyRendererTextureId() {
        return B3VisualShapeData.nm_tinyRendererTextureId(this.address());
    }

    public int m_textureUniqueId() {
        return B3VisualShapeData.nm_textureUniqueId(this.address());
    }

    public int m_openglTextureId() {
        return B3VisualShapeData.nm_openglTextureId(this.address());
    }

    public B3VisualShapeData m_objectUniqueId(int value) {
        B3VisualShapeData.nm_objectUniqueId(this.address(), value);
        return this;
    }

    public B3VisualShapeData m_linkIndex(int value) {
        B3VisualShapeData.nm_linkIndex(this.address(), value);
        return this;
    }

    public B3VisualShapeData m_visualGeometryType(int value) {
        B3VisualShapeData.nm_visualGeometryType(this.address(), value);
        return this;
    }

    public B3VisualShapeData m_dimensions(@NativeType(value="double[3]") DoubleBuffer value) {
        B3VisualShapeData.nm_dimensions(this.address(), value);
        return this;
    }

    public B3VisualShapeData m_dimensions(int index, double value) {
        B3VisualShapeData.nm_dimensions(this.address(), index, value);
        return this;
    }

    public B3VisualShapeData m_meshAssetFileName(@NativeType(value="char[VISUAL_SHAPE_MAX_PATH_LEN]") ByteBuffer value) {
        B3VisualShapeData.nm_meshAssetFileName(this.address(), value);
        return this;
    }

    public B3VisualShapeData m_localVisualFrame(@NativeType(value="double[7]") DoubleBuffer value) {
        B3VisualShapeData.nm_localVisualFrame(this.address(), value);
        return this;
    }

    public B3VisualShapeData m_localVisualFrame(int index, double value) {
        B3VisualShapeData.nm_localVisualFrame(this.address(), index, value);
        return this;
    }

    public B3VisualShapeData m_rgbaColor(@NativeType(value="double[4]") DoubleBuffer value) {
        B3VisualShapeData.nm_rgbaColor(this.address(), value);
        return this;
    }

    public B3VisualShapeData m_rgbaColor(int index, double value) {
        B3VisualShapeData.nm_rgbaColor(this.address(), index, value);
        return this;
    }

    public B3VisualShapeData m_tinyRendererTextureId(int value) {
        B3VisualShapeData.nm_tinyRendererTextureId(this.address(), value);
        return this;
    }

    public B3VisualShapeData m_textureUniqueId(int value) {
        B3VisualShapeData.nm_textureUniqueId(this.address(), value);
        return this;
    }

    public B3VisualShapeData m_openglTextureId(int value) {
        B3VisualShapeData.nm_openglTextureId(this.address(), value);
        return this;
    }

    public B3VisualShapeData set(int m_objectUniqueId, int m_linkIndex, int m_visualGeometryType, DoubleBuffer m_dimensions, ByteBuffer m_meshAssetFileName, DoubleBuffer m_localVisualFrame, DoubleBuffer m_rgbaColor, int m_tinyRendererTextureId, int m_textureUniqueId, int m_openglTextureId) {
        this.m_objectUniqueId(m_objectUniqueId);
        this.m_linkIndex(m_linkIndex);
        this.m_visualGeometryType(m_visualGeometryType);
        this.m_dimensions(m_dimensions);
        this.m_meshAssetFileName(m_meshAssetFileName);
        this.m_localVisualFrame(m_localVisualFrame);
        this.m_rgbaColor(m_rgbaColor);
        this.m_tinyRendererTextureId(m_tinyRendererTextureId);
        this.m_textureUniqueId(m_textureUniqueId);
        this.m_openglTextureId(m_openglTextureId);
        return this;
    }

    public B3VisualShapeData set(B3VisualShapeData src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static B3VisualShapeData malloc() {
        return (B3VisualShapeData)B3VisualShapeData.wrap(B3VisualShapeData.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static B3VisualShapeData calloc() {
        return (B3VisualShapeData)B3VisualShapeData.wrap(B3VisualShapeData.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static B3VisualShapeData create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (B3VisualShapeData)B3VisualShapeData.wrap(B3VisualShapeData.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static B3VisualShapeData create(long address) {
        return (B3VisualShapeData)B3VisualShapeData.wrap(B3VisualShapeData.class, (long)address);
    }

    @Nullable
    public static B3VisualShapeData createSafe(long address) {
        return address == 0L ? null : (B3VisualShapeData)B3VisualShapeData.wrap(B3VisualShapeData.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)B3VisualShapeData.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)B3VisualShapeData.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)B3VisualShapeData.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = B3VisualShapeData.__create((int)capacity, (int)SIZEOF);
        return (Buffer)B3VisualShapeData.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)B3VisualShapeData.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)B3VisualShapeData.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static B3VisualShapeData mallocStack() {
        return B3VisualShapeData.mallocStack(MemoryStack.stackGet());
    }

    public static B3VisualShapeData callocStack() {
        return B3VisualShapeData.callocStack(MemoryStack.stackGet());
    }

    public static B3VisualShapeData mallocStack(MemoryStack stack) {
        return (B3VisualShapeData)B3VisualShapeData.wrap(B3VisualShapeData.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static B3VisualShapeData callocStack(MemoryStack stack) {
        return (B3VisualShapeData)B3VisualShapeData.wrap(B3VisualShapeData.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return B3VisualShapeData.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return B3VisualShapeData.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)B3VisualShapeData.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)B3VisualShapeData.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nm_objectUniqueId(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_OBJECTUNIQUEID);
    }

    public static int nm_linkIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_LINKINDEX);
    }

    public static int nm_visualGeometryType(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_VISUALGEOMETRYTYPE);
    }

    public static DoubleBuffer nm_dimensions(long struct) {
        return MemoryUtil.memDoubleBuffer((long)(struct + (long)M_DIMENSIONS), (int)3);
    }

    public static double nm_dimensions(long struct, int index) {
        return UNSAFE.getDouble(null, struct + (long)M_DIMENSIONS + Checks.check((int)index, (int)3) * 8L);
    }

    public static ByteBuffer nm_meshAssetFileName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)M_MESHASSETFILENAME), (int)1024);
    }

    public static String nm_meshAssetFileNameString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)M_MESHASSETFILENAME));
    }

    public static DoubleBuffer nm_localVisualFrame(long struct) {
        return MemoryUtil.memDoubleBuffer((long)(struct + (long)M_LOCALVISUALFRAME), (int)7);
    }

    public static double nm_localVisualFrame(long struct, int index) {
        return UNSAFE.getDouble(null, struct + (long)M_LOCALVISUALFRAME + Checks.check((int)index, (int)7) * 8L);
    }

    public static DoubleBuffer nm_rgbaColor(long struct) {
        return MemoryUtil.memDoubleBuffer((long)(struct + (long)M_RGBACOLOR), (int)4);
    }

    public static double nm_rgbaColor(long struct, int index) {
        return UNSAFE.getDouble(null, struct + (long)M_RGBACOLOR + Checks.check((int)index, (int)4) * 8L);
    }

    public static int nm_tinyRendererTextureId(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_TINYRENDERERTEXTUREID);
    }

    public static int nm_textureUniqueId(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_TEXTUREUNIQUEID);
    }

    public static int nm_openglTextureId(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_OPENGLTEXTUREID);
    }

    public static void nm_objectUniqueId(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_OBJECTUNIQUEID, value);
    }

    public static void nm_linkIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_LINKINDEX, value);
    }

    public static void nm_visualGeometryType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_VISUALGEOMETRYTYPE, value);
    }

    public static void nm_dimensions(long struct, DoubleBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)3);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((DoubleBuffer)value), (long)(struct + (long)M_DIMENSIONS), (long)(value.remaining() * 8));
    }

    public static void nm_dimensions(long struct, int index, double value) {
        UNSAFE.putDouble(null, struct + (long)M_DIMENSIONS + Checks.check((int)index, (int)3) * 8L, value);
    }

    public static void nm_meshAssetFileName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)1024);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)M_MESHASSETFILENAME), (long)value.remaining());
    }

    public static void nm_localVisualFrame(long struct, DoubleBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)7);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((DoubleBuffer)value), (long)(struct + (long)M_LOCALVISUALFRAME), (long)(value.remaining() * 8));
    }

    public static void nm_localVisualFrame(long struct, int index, double value) {
        UNSAFE.putDouble(null, struct + (long)M_LOCALVISUALFRAME + Checks.check((int)index, (int)7) * 8L, value);
    }

    public static void nm_rgbaColor(long struct, DoubleBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)4);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((DoubleBuffer)value), (long)(struct + (long)M_RGBACOLOR), (long)(value.remaining() * 8));
    }

    public static void nm_rgbaColor(long struct, int index, double value) {
        UNSAFE.putDouble(null, struct + (long)M_RGBACOLOR + Checks.check((int)index, (int)4) * 8L, value);
    }

    public static void nm_tinyRendererTextureId(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_TINYRENDERERTEXTUREID, value);
    }

    public static void nm_textureUniqueId(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_TEXTUREUNIQUEID, value);
    }

    public static void nm_openglTextureId(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_OPENGLTEXTUREID, value);
    }

    static {
        Struct.Layout layout = B3VisualShapeData.__struct((Struct.Member[])new Struct.Member[]{B3VisualShapeData.__member((int)4), B3VisualShapeData.__member((int)4), B3VisualShapeData.__member((int)4), B3VisualShapeData.__array((int)8, (int)3), B3VisualShapeData.__array((int)1, (int)1024), B3VisualShapeData.__array((int)8, (int)7), B3VisualShapeData.__array((int)8, (int)4), B3VisualShapeData.__member((int)4), B3VisualShapeData.__member((int)4), B3VisualShapeData.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_OBJECTUNIQUEID = layout.offsetof(0);
        M_LINKINDEX = layout.offsetof(1);
        M_VISUALGEOMETRYTYPE = layout.offsetof(2);
        M_DIMENSIONS = layout.offsetof(3);
        M_MESHASSETFILENAME = layout.offsetof(4);
        M_LOCALVISUALFRAME = layout.offsetof(5);
        M_RGBACOLOR = layout.offsetof(6);
        M_TINYRENDERERTEXTUREID = layout.offsetof(7);
        M_TEXTUREUNIQUEID = layout.offsetof(8);
        M_OPENGLTEXTUREID = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<B3VisualShapeData, Buffer>
    implements NativeResource {
        private static final B3VisualShapeData ELEMENT_FACTORY = B3VisualShapeData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected B3VisualShapeData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int m_objectUniqueId() {
            return B3VisualShapeData.nm_objectUniqueId(this.address());
        }

        public int m_linkIndex() {
            return B3VisualShapeData.nm_linkIndex(this.address());
        }

        public int m_visualGeometryType() {
            return B3VisualShapeData.nm_visualGeometryType(this.address());
        }

        @NativeType(value="double[3]")
        public DoubleBuffer m_dimensions() {
            return B3VisualShapeData.nm_dimensions(this.address());
        }

        public double m_dimensions(int index) {
            return B3VisualShapeData.nm_dimensions(this.address(), index);
        }

        @NativeType(value="char[VISUAL_SHAPE_MAX_PATH_LEN]")
        public ByteBuffer m_meshAssetFileName() {
            return B3VisualShapeData.nm_meshAssetFileName(this.address());
        }

        @NativeType(value="char[VISUAL_SHAPE_MAX_PATH_LEN]")
        public String m_meshAssetFileNameString() {
            return B3VisualShapeData.nm_meshAssetFileNameString(this.address());
        }

        @NativeType(value="double[7]")
        public DoubleBuffer m_localVisualFrame() {
            return B3VisualShapeData.nm_localVisualFrame(this.address());
        }

        public double m_localVisualFrame(int index) {
            return B3VisualShapeData.nm_localVisualFrame(this.address(), index);
        }

        @NativeType(value="double[4]")
        public DoubleBuffer m_rgbaColor() {
            return B3VisualShapeData.nm_rgbaColor(this.address());
        }

        public double m_rgbaColor(int index) {
            return B3VisualShapeData.nm_rgbaColor(this.address(), index);
        }

        public int m_tinyRendererTextureId() {
            return B3VisualShapeData.nm_tinyRendererTextureId(this.address());
        }

        public int m_textureUniqueId() {
            return B3VisualShapeData.nm_textureUniqueId(this.address());
        }

        public int m_openglTextureId() {
            return B3VisualShapeData.nm_openglTextureId(this.address());
        }

        public Buffer m_objectUniqueId(int value) {
            B3VisualShapeData.nm_objectUniqueId(this.address(), value);
            return this;
        }

        public Buffer m_linkIndex(int value) {
            B3VisualShapeData.nm_linkIndex(this.address(), value);
            return this;
        }

        public Buffer m_visualGeometryType(int value) {
            B3VisualShapeData.nm_visualGeometryType(this.address(), value);
            return this;
        }

        public Buffer m_dimensions(@NativeType(value="double[3]") DoubleBuffer value) {
            B3VisualShapeData.nm_dimensions(this.address(), value);
            return this;
        }

        public Buffer m_dimensions(int index, double value) {
            B3VisualShapeData.nm_dimensions(this.address(), index, value);
            return this;
        }

        public Buffer m_meshAssetFileName(@NativeType(value="char[VISUAL_SHAPE_MAX_PATH_LEN]") ByteBuffer value) {
            B3VisualShapeData.nm_meshAssetFileName(this.address(), value);
            return this;
        }

        public Buffer m_localVisualFrame(@NativeType(value="double[7]") DoubleBuffer value) {
            B3VisualShapeData.nm_localVisualFrame(this.address(), value);
            return this;
        }

        public Buffer m_localVisualFrame(int index, double value) {
            B3VisualShapeData.nm_localVisualFrame(this.address(), index, value);
            return this;
        }

        public Buffer m_rgbaColor(@NativeType(value="double[4]") DoubleBuffer value) {
            B3VisualShapeData.nm_rgbaColor(this.address(), value);
            return this;
        }

        public Buffer m_rgbaColor(int index, double value) {
            B3VisualShapeData.nm_rgbaColor(this.address(), index, value);
            return this;
        }

        public Buffer m_tinyRendererTextureId(int value) {
            B3VisualShapeData.nm_tinyRendererTextureId(this.address(), value);
            return this;
        }

        public Buffer m_textureUniqueId(int value) {
            B3VisualShapeData.nm_textureUniqueId(this.address(), value);
            return this;
        }

        public Buffer m_openglTextureId(int value) {
            B3VisualShapeData.nm_openglTextureId(this.address(), value);
            return this;
        }
    }
}

