/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.par;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct par_octasphere_config")
public class ParOctasphereConfig
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CORNER_RADIUS;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int DEPTH;
    public static final int NUM_SUBDIVISIONS;
    public static final int UV_MODE;
    public static final int NORMALS_MODE;

    public ParOctasphereConfig(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ParOctasphereConfig.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float corner_radius() {
        return ParOctasphereConfig.ncorner_radius(this.address());
    }

    public float width() {
        return ParOctasphereConfig.nwidth(this.address());
    }

    public float height() {
        return ParOctasphereConfig.nheight(this.address());
    }

    public float depth() {
        return ParOctasphereConfig.ndepth(this.address());
    }

    public int num_subdivisions() {
        return ParOctasphereConfig.nnum_subdivisions(this.address());
    }

    @NativeType(value="par_octasphere_uv_mode")
    public int uv_mode() {
        return ParOctasphereConfig.nuv_mode(this.address());
    }

    @NativeType(value="par_octasphere_normals_mode")
    public int normals_mode() {
        return ParOctasphereConfig.nnormals_mode(this.address());
    }

    public ParOctasphereConfig corner_radius(float value) {
        ParOctasphereConfig.ncorner_radius(this.address(), value);
        return this;
    }

    public ParOctasphereConfig width(float value) {
        ParOctasphereConfig.nwidth(this.address(), value);
        return this;
    }

    public ParOctasphereConfig height(float value) {
        ParOctasphereConfig.nheight(this.address(), value);
        return this;
    }

    public ParOctasphereConfig depth(float value) {
        ParOctasphereConfig.ndepth(this.address(), value);
        return this;
    }

    public ParOctasphereConfig num_subdivisions(int value) {
        ParOctasphereConfig.nnum_subdivisions(this.address(), value);
        return this;
    }

    public ParOctasphereConfig uv_mode(@NativeType(value="par_octasphere_uv_mode") int value) {
        ParOctasphereConfig.nuv_mode(this.address(), value);
        return this;
    }

    public ParOctasphereConfig normals_mode(@NativeType(value="par_octasphere_normals_mode") int value) {
        ParOctasphereConfig.nnormals_mode(this.address(), value);
        return this;
    }

    public ParOctasphereConfig set(float corner_radius, float width, float height, float depth, int num_subdivisions, int uv_mode, int normals_mode) {
        this.corner_radius(corner_radius);
        this.width(width);
        this.height(height);
        this.depth(depth);
        this.num_subdivisions(num_subdivisions);
        this.uv_mode(uv_mode);
        this.normals_mode(normals_mode);
        return this;
    }

    public ParOctasphereConfig set(ParOctasphereConfig src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static ParOctasphereConfig malloc() {
        return (ParOctasphereConfig)ParOctasphereConfig.wrap(ParOctasphereConfig.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static ParOctasphereConfig calloc() {
        return (ParOctasphereConfig)ParOctasphereConfig.wrap(ParOctasphereConfig.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static ParOctasphereConfig create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (ParOctasphereConfig)ParOctasphereConfig.wrap(ParOctasphereConfig.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static ParOctasphereConfig create(long address) {
        return (ParOctasphereConfig)ParOctasphereConfig.wrap(ParOctasphereConfig.class, (long)address);
    }

    @Nullable
    public static ParOctasphereConfig createSafe(long address) {
        return address == 0L ? null : (ParOctasphereConfig)ParOctasphereConfig.wrap(ParOctasphereConfig.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)ParOctasphereConfig.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)ParOctasphereConfig.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)ParOctasphereConfig.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ParOctasphereConfig.__create((int)capacity, (int)SIZEOF);
        return (Buffer)ParOctasphereConfig.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)ParOctasphereConfig.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)ParOctasphereConfig.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static ParOctasphereConfig mallocStack() {
        return ParOctasphereConfig.mallocStack(MemoryStack.stackGet());
    }

    public static ParOctasphereConfig callocStack() {
        return ParOctasphereConfig.callocStack(MemoryStack.stackGet());
    }

    public static ParOctasphereConfig mallocStack(MemoryStack stack) {
        return (ParOctasphereConfig)ParOctasphereConfig.wrap(ParOctasphereConfig.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ParOctasphereConfig callocStack(MemoryStack stack) {
        return (ParOctasphereConfig)ParOctasphereConfig.wrap(ParOctasphereConfig.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return ParOctasphereConfig.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return ParOctasphereConfig.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)ParOctasphereConfig.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)ParOctasphereConfig.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static float ncorner_radius(long struct) {
        return UNSAFE.getFloat(null, struct + (long)CORNER_RADIUS);
    }

    public static float nwidth(long struct) {
        return UNSAFE.getFloat(null, struct + (long)WIDTH);
    }

    public static float nheight(long struct) {
        return UNSAFE.getFloat(null, struct + (long)HEIGHT);
    }

    public static float ndepth(long struct) {
        return UNSAFE.getFloat(null, struct + (long)DEPTH);
    }

    public static int nnum_subdivisions(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUM_SUBDIVISIONS);
    }

    public static int nuv_mode(long struct) {
        return UNSAFE.getInt(null, struct + (long)UV_MODE);
    }

    public static int nnormals_mode(long struct) {
        return UNSAFE.getInt(null, struct + (long)NORMALS_MODE);
    }

    public static void ncorner_radius(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)CORNER_RADIUS, value);
    }

    public static void nwidth(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)HEIGHT, value);
    }

    public static void ndepth(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)DEPTH, value);
    }

    public static void nnum_subdivisions(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NUM_SUBDIVISIONS, value);
    }

    public static void nuv_mode(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)UV_MODE, value);
    }

    public static void nnormals_mode(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NORMALS_MODE, value);
    }

    static {
        Struct.Layout layout = ParOctasphereConfig.__struct((Struct.Member[])new Struct.Member[]{ParOctasphereConfig.__member((int)4), ParOctasphereConfig.__member((int)4), ParOctasphereConfig.__member((int)4), ParOctasphereConfig.__member((int)4), ParOctasphereConfig.__member((int)4), ParOctasphereConfig.__member((int)4), ParOctasphereConfig.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CORNER_RADIUS = layout.offsetof(0);
        WIDTH = layout.offsetof(1);
        HEIGHT = layout.offsetof(2);
        DEPTH = layout.offsetof(3);
        NUM_SUBDIVISIONS = layout.offsetof(4);
        UV_MODE = layout.offsetof(5);
        NORMALS_MODE = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<ParOctasphereConfig, Buffer>
    implements NativeResource {
        private static final ParOctasphereConfig ELEMENT_FACTORY = ParOctasphereConfig.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected ParOctasphereConfig getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float corner_radius() {
            return ParOctasphereConfig.ncorner_radius(this.address());
        }

        public float width() {
            return ParOctasphereConfig.nwidth(this.address());
        }

        public float height() {
            return ParOctasphereConfig.nheight(this.address());
        }

        public float depth() {
            return ParOctasphereConfig.ndepth(this.address());
        }

        public int num_subdivisions() {
            return ParOctasphereConfig.nnum_subdivisions(this.address());
        }

        @NativeType(value="par_octasphere_uv_mode")
        public int uv_mode() {
            return ParOctasphereConfig.nuv_mode(this.address());
        }

        @NativeType(value="par_octasphere_normals_mode")
        public int normals_mode() {
            return ParOctasphereConfig.nnormals_mode(this.address());
        }

        public Buffer corner_radius(float value) {
            ParOctasphereConfig.ncorner_radius(this.address(), value);
            return this;
        }

        public Buffer width(float value) {
            ParOctasphereConfig.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(float value) {
            ParOctasphereConfig.nheight(this.address(), value);
            return this;
        }

        public Buffer depth(float value) {
            ParOctasphereConfig.ndepth(this.address(), value);
            return this;
        }

        public Buffer num_subdivisions(int value) {
            ParOctasphereConfig.nnum_subdivisions(this.address(), value);
            return this;
        }

        public Buffer uv_mode(@NativeType(value="par_octasphere_uv_mode") int value) {
            ParOctasphereConfig.nuv_mode(this.address(), value);
            return this;
        }

        public Buffer normals_mode(@NativeType(value="par_octasphere_normals_mode") int value) {
            ParOctasphereConfig.nnormals_mode(this.address(), value);
            return this;
        }
    }
}

