/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.nuklear.NkPopupBuffer;
import org.lwjgl.nuklear.NkRect;
import org.lwjgl.nuklear.NkWindow;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_popup_state")
public class NkPopupState
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIN;
    public static final int TYPE;
    public static final int BUF;
    public static final int NAME;
    public static final int ACTIVE;
    public static final int COMBO_COUNT;
    public static final int CON_COUNT;
    public static final int CON_OLD;
    public static final int ACTIVE_CON;
    public static final int HEADER;

    public NkPopupState(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkPopupState.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_window *")
    public NkWindow win() {
        return NkPopupState.nwin(this.address());
    }

    @NativeType(value="enum nk_panel_type")
    public int type() {
        return NkPopupState.ntype(this.address());
    }

    @NativeType(value="struct nk_popup_buffer")
    public NkPopupBuffer buf() {
        return NkPopupState.nbuf(this.address());
    }

    @NativeType(value="nk_hash")
    public int name() {
        return NkPopupState.nname(this.address());
    }

    public int active() {
        return NkPopupState.nactive(this.address());
    }

    @NativeType(value="unsigned")
    public int combo_count() {
        return NkPopupState.ncombo_count(this.address());
    }

    @NativeType(value="unsigned")
    public int con_count() {
        return NkPopupState.ncon_count(this.address());
    }

    @NativeType(value="unsigned")
    public int con_old() {
        return NkPopupState.ncon_old(this.address());
    }

    @NativeType(value="unsigned")
    public int active_con() {
        return NkPopupState.nactive_con(this.address());
    }

    @NativeType(value="struct nk_rect")
    public NkRect header() {
        return NkPopupState.nheader(this.address());
    }

    public static NkPopupState create(long address) {
        return (NkPopupState)NkPopupState.wrap(NkPopupState.class, (long)address);
    }

    @Nullable
    public static NkPopupState createSafe(long address) {
        return address == 0L ? null : (NkPopupState)NkPopupState.wrap(NkPopupState.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkPopupState.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkPopupState.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static NkWindow nwin(long struct) {
        return NkWindow.create(MemoryUtil.memGetAddress((long)(struct + (long)WIN)));
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static NkPopupBuffer nbuf(long struct) {
        return NkPopupBuffer.create(struct + (long)BUF);
    }

    public static int nname(long struct) {
        return UNSAFE.getInt(null, struct + (long)NAME);
    }

    public static int nactive(long struct) {
        return UNSAFE.getInt(null, struct + (long)ACTIVE);
    }

    public static int ncombo_count(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMBO_COUNT);
    }

    public static int ncon_count(long struct) {
        return UNSAFE.getInt(null, struct + (long)CON_COUNT);
    }

    public static int ncon_old(long struct) {
        return UNSAFE.getInt(null, struct + (long)CON_OLD);
    }

    public static int nactive_con(long struct) {
        return UNSAFE.getInt(null, struct + (long)ACTIVE_CON);
    }

    public static NkRect nheader(long struct) {
        return NkRect.create(struct + (long)HEADER);
    }

    static {
        Struct.Layout layout = NkPopupState.__struct((Struct.Member[])new Struct.Member[]{NkPopupState.__member((int)POINTER_SIZE), NkPopupState.__member((int)4), NkPopupState.__member((int)NkPopupBuffer.SIZEOF, (int)NkPopupBuffer.ALIGNOF), NkPopupState.__member((int)4), NkPopupState.__member((int)4), NkPopupState.__member((int)4), NkPopupState.__member((int)4), NkPopupState.__member((int)4), NkPopupState.__member((int)4), NkPopupState.__member((int)NkRect.SIZEOF, (int)NkRect.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIN = layout.offsetof(0);
        TYPE = layout.offsetof(1);
        BUF = layout.offsetof(2);
        NAME = layout.offsetof(3);
        ACTIVE = layout.offsetof(4);
        COMBO_COUNT = layout.offsetof(5);
        CON_COUNT = layout.offsetof(6);
        CON_OLD = layout.offsetof(7);
        ACTIVE_CON = layout.offsetof(8);
        HEADER = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<NkPopupState, Buffer> {
        private static final NkPopupState ELEMENT_FACTORY = NkPopupState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkPopupState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_window *")
        public NkWindow win() {
            return NkPopupState.nwin(this.address());
        }

        @NativeType(value="enum nk_panel_type")
        public int type() {
            return NkPopupState.ntype(this.address());
        }

        @NativeType(value="struct nk_popup_buffer")
        public NkPopupBuffer buf() {
            return NkPopupState.nbuf(this.address());
        }

        @NativeType(value="nk_hash")
        public int name() {
            return NkPopupState.nname(this.address());
        }

        public int active() {
            return NkPopupState.nactive(this.address());
        }

        @NativeType(value="unsigned")
        public int combo_count() {
            return NkPopupState.ncombo_count(this.address());
        }

        @NativeType(value="unsigned")
        public int con_count() {
            return NkPopupState.ncon_count(this.address());
        }

        @NativeType(value="unsigned")
        public int con_old() {
            return NkPopupState.ncon_old(this.address());
        }

        @NativeType(value="unsigned")
        public int active_con() {
            return NkPopupState.nactive_con(this.address());
        }

        @NativeType(value="struct nk_rect")
        public NkRect header() {
            return NkPopupState.nheader(this.address());
        }
    }
}

