/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.tinyexr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class EXRVersion
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERSION;
    public static final int TILED;
    public static final int LONG_NAME;
    public static final int NON_IMAGE;
    public static final int MULTIPART;

    public EXRVersion(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), EXRVersion.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int version() {
        return EXRVersion.nversion(this.address());
    }

    @NativeType(value="int")
    public boolean tiled() {
        return EXRVersion.ntiled(this.address()) != 0;
    }

    @NativeType(value="int")
    public boolean long_name() {
        return EXRVersion.nlong_name(this.address()) != 0;
    }

    @NativeType(value="int")
    public boolean non_image() {
        return EXRVersion.nnon_image(this.address()) != 0;
    }

    @NativeType(value="int")
    public boolean multipart() {
        return EXRVersion.nmultipart(this.address()) != 0;
    }

    public EXRVersion version(int value) {
        EXRVersion.nversion(this.address(), value);
        return this;
    }

    public EXRVersion tiled(@NativeType(value="int") boolean value) {
        EXRVersion.ntiled(this.address(), value ? 1 : 0);
        return this;
    }

    public EXRVersion long_name(@NativeType(value="int") boolean value) {
        EXRVersion.nlong_name(this.address(), value ? 1 : 0);
        return this;
    }

    public EXRVersion non_image(@NativeType(value="int") boolean value) {
        EXRVersion.nnon_image(this.address(), value ? 1 : 0);
        return this;
    }

    public EXRVersion multipart(@NativeType(value="int") boolean value) {
        EXRVersion.nmultipart(this.address(), value ? 1 : 0);
        return this;
    }

    public EXRVersion set(int version, boolean tiled, boolean long_name, boolean non_image, boolean multipart) {
        this.version(version);
        this.tiled(tiled);
        this.long_name(long_name);
        this.non_image(non_image);
        this.multipart(multipart);
        return this;
    }

    public EXRVersion set(EXRVersion src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static EXRVersion malloc() {
        return (EXRVersion)EXRVersion.wrap(EXRVersion.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static EXRVersion calloc() {
        return (EXRVersion)EXRVersion.wrap(EXRVersion.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static EXRVersion create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (EXRVersion)EXRVersion.wrap(EXRVersion.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static EXRVersion create(long address) {
        return (EXRVersion)EXRVersion.wrap(EXRVersion.class, (long)address);
    }

    @Nullable
    public static EXRVersion createSafe(long address) {
        return address == 0L ? null : (EXRVersion)EXRVersion.wrap(EXRVersion.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)EXRVersion.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)EXRVersion.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)EXRVersion.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = EXRVersion.__create((int)capacity, (int)SIZEOF);
        return (Buffer)EXRVersion.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)EXRVersion.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)EXRVersion.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static EXRVersion mallocStack() {
        return EXRVersion.mallocStack(MemoryStack.stackGet());
    }

    public static EXRVersion callocStack() {
        return EXRVersion.callocStack(MemoryStack.stackGet());
    }

    public static EXRVersion mallocStack(MemoryStack stack) {
        return (EXRVersion)EXRVersion.wrap(EXRVersion.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static EXRVersion callocStack(MemoryStack stack) {
        return (EXRVersion)EXRVersion.wrap(EXRVersion.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return EXRVersion.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return EXRVersion.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)EXRVersion.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)EXRVersion.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nversion(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERSION);
    }

    public static int ntiled(long struct) {
        return UNSAFE.getInt(null, struct + (long)TILED);
    }

    public static int nlong_name(long struct) {
        return UNSAFE.getInt(null, struct + (long)LONG_NAME);
    }

    public static int nnon_image(long struct) {
        return UNSAFE.getInt(null, struct + (long)NON_IMAGE);
    }

    public static int nmultipart(long struct) {
        return UNSAFE.getInt(null, struct + (long)MULTIPART);
    }

    public static void nversion(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VERSION, value);
    }

    public static void ntiled(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TILED, value);
    }

    public static void nlong_name(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LONG_NAME, value);
    }

    public static void nnon_image(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NON_IMAGE, value);
    }

    public static void nmultipart(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MULTIPART, value);
    }

    static {
        Struct.Layout layout = EXRVersion.__struct((Struct.Member[])new Struct.Member[]{EXRVersion.__member((int)4), EXRVersion.__member((int)4), EXRVersion.__member((int)4), EXRVersion.__member((int)4), EXRVersion.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERSION = layout.offsetof(0);
        TILED = layout.offsetof(1);
        LONG_NAME = layout.offsetof(2);
        NON_IMAGE = layout.offsetof(3);
        MULTIPART = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<EXRVersion, Buffer>
    implements NativeResource {
        private static final EXRVersion ELEMENT_FACTORY = EXRVersion.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected EXRVersion getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int version() {
            return EXRVersion.nversion(this.address());
        }

        @NativeType(value="int")
        public boolean tiled() {
            return EXRVersion.ntiled(this.address()) != 0;
        }

        @NativeType(value="int")
        public boolean long_name() {
            return EXRVersion.nlong_name(this.address()) != 0;
        }

        @NativeType(value="int")
        public boolean non_image() {
            return EXRVersion.nnon_image(this.address()) != 0;
        }

        @NativeType(value="int")
        public boolean multipart() {
            return EXRVersion.nmultipart(this.address()) != 0;
        }

        public Buffer version(int value) {
            EXRVersion.nversion(this.address(), value);
            return this;
        }

        public Buffer tiled(@NativeType(value="int") boolean value) {
            EXRVersion.ntiled(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer long_name(@NativeType(value="int") boolean value) {
            EXRVersion.nlong_name(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer non_image(@NativeType(value="int") boolean value) {
            EXRVersion.nnon_image(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer multipart(@NativeType(value="int") boolean value) {
            EXRVersion.nmultipart(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

