"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _constants = require("../utils/constants");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class DetectorService {
  constructor(osDriver) {
    _defineProperty(this, "osDriver", void 0);

    _defineProperty(this, "createDetector", async (_context, request, response) => {
      try {
        const detector = request.body;
        const params = {
          body: detector
        };
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const createDetectorResponse = await callWithRequest(_constants.CLIENT_DETECTOR_METHODS.CREATE_DETECTOR, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: createDetectorResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - DetectorsService - createDetector:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    _defineProperty(this, "getDetector", async (_context, request, response) => {
      try {
        const {
          detectorId
        } = request.params;
        const params = {
          detectorId
        };
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const getDetectorResponse = await callWithRequest(_constants.CLIENT_DETECTOR_METHODS.GET_DETECTOR, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getDetectorResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - DetectorsService - getDetector:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    _defineProperty(this, "searchDetectors", async (_context, request, response) => {
      try {
        const {
          query
        } = request.body;
        const params = {
          body: {
            size: 10000,
            query
          }
        };
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const searchDetectorResponse = await callWithRequest(_constants.CLIENT_DETECTOR_METHODS.SEARCH_DETECTORS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: searchDetectorResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - DetectorsService - searchDetectors:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    _defineProperty(this, "deleteDetector", async (_context, request, response) => {
      try {
        const {
          detectorId
        } = request.params;
        const params = {
          detectorId
        };
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const deleteDetectorResponse = await callWithRequest(_constants.CLIENT_DETECTOR_METHODS.DELETE_DETECTOR, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: deleteDetectorResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - DetectorsService - deleteDetector:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    _defineProperty(this, "updateDetector", async (_context, request, response) => {
      try {
        const detector = request.body;
        const {
          detectorId
        } = request.params;
        const params = {
          body: detector,
          detectorId
        };
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const updateDetectorResponse = await callWithRequest(_constants.CLIENT_DETECTOR_METHODS.UPDATE_DETECTOR, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: updateDetectorResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - DetectorsService - updateDetector:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    this.osDriver = osDriver;
  }
  /**
   * Calls backend POST Detectors API.
   */


}

exports.default = DetectorService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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