/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioMetaData;
import ddf.minim.Controller;
import ddf.minim.Playable;
import ddf.minim.spi.AudioRecording;

public class AudioSnippet
extends Controller
implements Playable {
    private AudioRecording recording;

    public AudioSnippet(AudioRecording rec) {
        super(rec.getControls());
        rec.open();
        this.recording = rec;
    }

    public void play() {
        this.recording.play();
    }

    public void play(int millis) {
        this.cue(millis);
        this.play();
    }

    public void pause() {
        this.recording.pause();
    }

    public void rewind() {
        this.cue(0);
    }

    public void loop() {
        this.recording.loop(-1);
    }

    public void loop(int n) {
        this.recording.loop(n);
    }

    public int loopCount() {
        return this.recording.getLoopCount();
    }

    public int length() {
        return this.recording.getMillisecondLength();
    }

    public int position() {
        return this.recording.getMillisecondPosition();
    }

    public void cue(int millis) {
        if (millis < 0) {
            millis = 0;
        }
        if (millis > this.length()) {
            millis = this.length();
        }
        this.recording.setMillisecondPosition(millis);
    }

    public void skip(int millis) {
        int pos = this.position() + millis;
        if (pos < 0) {
            pos = 0;
        } else if (pos > this.length()) {
            pos = this.length();
        }
        this.recording.setMillisecondPosition(pos);
    }

    public boolean isLooping() {
        return this.recording.getLoopCount() != 0;
    }

    public boolean isPlaying() {
        return this.recording.isPlaying();
    }

    public void close() {
        this.recording.close();
    }

    public AudioMetaData getMetaData() {
        return this.recording.getMetaData();
    }

    public void setLoopPoints(int start, int stop) {
        this.recording.setLoopPoints(start, stop);
    }
}

