/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.JRAlignment;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.export.oasis.BorderStyle;
import net.sf.jasperreports.engine.export.oasis.ParagraphStyle;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class CellStyle
extends BorderStyle {
    private String backcolor = null;
    private final String verticalAlignment;

    public CellStyle(Writer styleWriter, JRPrintElement element) {
        super(styleWriter, element);
        JRAlignment alignment;
        if (element.getMode() == 1) {
            this.backcolor = JRColorUtil.getColorHexa(element.getBackcolor());
        }
        byte rotation = element instanceof JRPrintText ? ((JRPrintText)element).getRotation() : (byte)0;
        byte vAlign = 1;
        byte hAlign = 1;
        JRAlignment jRAlignment = alignment = element instanceof JRAlignment ? (JRAlignment)((Object)element) : null;
        if (alignment != null) {
            vAlign = alignment.getVerticalAlignment();
            hAlign = alignment.getHorizontalAlignment();
        }
        this.verticalAlignment = ParagraphStyle.getVerticalAlignment(hAlign, vAlign, rotation);
    }

    public String getId() {
        return this.backcolor + super.getId() + "|" + this.verticalAlignment;
    }

    public void write(String cellStyleName) throws IOException {
        this.styleWriter.write("<style:style style:name=\"");
        this.styleWriter.write(cellStyleName);
        this.styleWriter.write("\"");
        this.styleWriter.write(" style:family=\"table-cell\">\n");
        this.styleWriter.write(" <style:table-cell-properties");
        this.styleWriter.write(" fo:wrap-option=\"wrap\"");
        this.styleWriter.write(" style:shrink-to-fit=\"false\"");
        if (this.backcolor != null) {
            this.styleWriter.write(" fo:background-color=\"#");
            this.styleWriter.write(this.backcolor);
            this.styleWriter.write("\"");
        }
        this.writeBorder(0);
        this.writeBorder(1);
        this.writeBorder(2);
        this.writeBorder(3);
        if (this.verticalAlignment != null) {
            this.styleWriter.write(" style:vertical-align=\"");
            this.styleWriter.write(this.verticalAlignment);
            this.styleWriter.write("\"");
        }
        this.styleWriter.write("/>\n");
        this.styleWriter.write("</style:style>\n");
    }
}

