/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.annotations;

import com.thoughtworks.xstream.annotations.AnnotationProvider;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Field;

public class AnnotationReflectionConverter
extends ReflectionConverter {
    private final AnnotationProvider annotationProvider;

    public AnnotationReflectionConverter(Mapper mapper, ReflectionProvider reflectionProvider, AnnotationProvider annotationProvider) {
        super(mapper, reflectionProvider);
        this.annotationProvider = annotationProvider;
    }

    protected void marshallField(MarshallingContext context, Object newObj, Field field) {
        XStreamConverter annotation = this.annotationProvider.getAnnotation(field, XStreamConverter.class);
        if (annotation != null) {
            context.convertAnother(newObj, (Converter)this.reflectionProvider.newInstance(annotation.value()));
        } else {
            context.convertAnother(newObj);
        }
    }

    protected Object unmarshallField(UnmarshallingContext context, Object result, Class type, Field field) {
        XStreamConverter annotation = this.annotationProvider.getAnnotation(field, XStreamConverter.class);
        if (annotation != null) {
            return context.convertAnother(result, type, (Converter)this.reflectionProvider.newInstance(annotation.value()));
        }
        return context.convertAnother(result, type);
    }
}

