/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class PortmanProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN_STANDARD = new PatternBuilder().text("$PTMLA,").expression("([^,]+),").expression("([ABCL]),").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").expression("([NS])").number("(dd)(dd.d+)").expression("([EW])").number("(d{2,3})(dd.d+),").number("(d+),").number("(d+),").number("(?:NA|C(-?d+)),").number("(x{8}),").number("(?:NA|(d+)),").number("(d+),").number("(d+),").number("(d+.d+),").number("(d+),").number("(?:G(d+)|[^,]*)").compile();
    private static final Pattern PATTERN_EXTENDED = new PatternBuilder().text("$EXT,").expression("([^,]+),").expression("([ABCL]),").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").expression("([NS])").number("(dd)(dd.d+)").expression("([EW])").number("(d{2,3})(dd.d+),").number("(d+),").number("(d+),").number("(?:NA|C(-?d+)),").number("(?:NA|F(d+)),").number("(d+),").number("(d+),").number("(d+.d+),").number("(?:NA|(d+)),").number("(x{8}),").number("(d+)").any().compile();

    public PortmanProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Object decodeStandard(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_STANDARD, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setValid(!parser.next().equals("L"));
        position.setTime(parser.nextDateTime());
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN));
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt().intValue()));
        position.setCourse(parser.nextInt().intValue());
        position.set("temp1", parser.next());
        position.set("status", parser.nextHexLong());
        position.set("driverUniqueId", parser.next());
        int event = parser.nextInt();
        position.set("event", event);
        if (event == 253) {
            position.set("ignition", true);
        } else if (event == 254) {
            position.set("ignition", false);
        }
        position.set("sat", parser.nextInt());
        position.set("odometer", parser.nextDouble() * 1000.0);
        position.set("rssi", parser.nextInt());
        position.set("fuel", parser.nextInt());
        return position;
    }

    private Object decodeExtended(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_EXTENDED, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setValid(!parser.next().equals("L"));
        position.setTime(parser.nextDateTime());
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN));
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt().intValue()));
        position.setCourse(parser.nextInt().intValue());
        position.set("temp1", parser.next());
        position.set("fuel", parser.nextInt());
        position.set("sat", parser.nextInt());
        position.set("rssi", parser.nextInt());
        position.set("odometer", parser.nextDouble() * 1000.0);
        position.set("driverUniqueId", parser.next());
        position.set("status", parser.nextHexLong());
        position.set("event", parser.nextInt());
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        if (sentence.startsWith("$PTMLA")) {
            return this.decodeStandard(channel, remoteAddress, sentence);
        }
        if (sentence.startsWith("$EXT")) {
            return this.decodeExtended(channel, remoteAddress, sentence);
        }
        return null;
    }
}

