/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.reports;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.jxls.common.Context;
import org.jxls.util.JxlsHelper;
import org.traccar.api.security.PermissionsService;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.helper.UnitsConverter;
import org.traccar.helper.model.PositionUtil;
import org.traccar.helper.model.UserUtil;
import org.traccar.model.Device;
import org.traccar.model.Position;
import org.traccar.reports.common.ReportUtils;
import org.traccar.reports.model.SummaryReportItem;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;

public class SummaryReportProvider {
    private final Config config;
    private final ReportUtils reportUtils;
    private final PermissionsService permissionsService;
    private final Storage storage;

    @Inject
    public SummaryReportProvider(Config config, ReportUtils reportUtils, PermissionsService permissionsService, Storage storage) {
        this.config = config;
        this.reportUtils = reportUtils;
        this.permissionsService = permissionsService;
        this.storage = storage;
    }

    private SummaryReportItem calculateSummaryResult(Device device, Collection<Position> positions) {
        SummaryReportItem result = new SummaryReportItem();
        result.setDeviceId(device.getId());
        result.setDeviceName(device.getName());
        if (positions != null && !positions.isEmpty()) {
            long durationMilliseconds;
            Position firstPosition = null;
            Position previousPosition = null;
            for (Position position : positions) {
                if (firstPosition == null) {
                    firstPosition = position;
                }
                previousPosition = position;
                if (!(position.getSpeed() > result.getMaxSpeed())) continue;
                result.setMaxSpeed(position.getSpeed());
            }
            boolean ignoreOdometer = this.config.getBoolean(Keys.REPORT_IGNORE_ODOMETER);
            result.setDistance(PositionUtil.calculateDistance(firstPosition, previousPosition, !ignoreOdometer));
            result.setSpentFuel(this.reportUtils.calculateFuel(firstPosition, previousPosition));
            if (firstPosition.hasAttribute("hours") && previousPosition.hasAttribute("hours")) {
                durationMilliseconds = previousPosition.getLong("hours") - firstPosition.getLong("hours");
                result.setEngineHours(durationMilliseconds);
            } else {
                durationMilliseconds = previousPosition.getFixTime().getTime() - firstPosition.getFixTime().getTime();
            }
            if (durationMilliseconds > 0L) {
                result.setAverageSpeed(UnitsConverter.knotsFromMps(result.getDistance() * 1000.0 / (double)durationMilliseconds));
            }
            if (!ignoreOdometer && firstPosition.getDouble("odometer") != 0.0 && previousPosition.getDouble("odometer") != 0.0) {
                result.setStartOdometer(firstPosition.getDouble("odometer"));
                result.setEndOdometer(previousPosition.getDouble("odometer"));
            } else {
                result.setStartOdometer(firstPosition.getDouble("totalDistance"));
                result.setEndOdometer(previousPosition.getDouble("totalDistance"));
            }
            result.setStartTime(firstPosition.getFixTime());
            result.setEndTime(previousPosition.getFixTime());
        }
        return result;
    }

    private int getDay(long userId, Date date) throws StorageException {
        Calendar calendar = Calendar.getInstance(UserUtil.getTimezone(this.permissionsService.getServer(), this.permissionsService.getUser(userId)));
        calendar.setTime(date);
        return calendar.get(5);
    }

    private Collection<SummaryReportItem> calculateSummaryResults(long userId, Device device, Date from, Date to, boolean daily) throws StorageException {
        List<Position> positions = PositionUtil.getPositions(this.storage, device.getId(), from, to);
        ArrayList<SummaryReportItem> results = new ArrayList<SummaryReportItem>();
        if (daily && !positions.isEmpty()) {
            int startIndex = 0;
            int startDay = this.getDay(userId, positions.iterator().next().getFixTime());
            for (int i = 0; i < positions.size(); ++i) {
                int currentDay = this.getDay(userId, positions.get(i).getFixTime());
                if (currentDay == startDay) continue;
                results.add(this.calculateSummaryResult(device, positions.subList(startIndex, i)));
                startIndex = i;
                startDay = currentDay;
            }
            results.add(this.calculateSummaryResult(device, positions.subList(startIndex, positions.size())));
        } else {
            results.add(this.calculateSummaryResult(device, positions));
        }
        return results;
    }

    public Collection<SummaryReportItem> getObjects(long userId, Collection<Long> deviceIds, Collection<Long> groupIds, Date from, Date to, boolean daily) throws StorageException {
        this.reportUtils.checkPeriodLimit(from, to);
        ArrayList<SummaryReportItem> result = new ArrayList<SummaryReportItem>();
        for (Device device : this.reportUtils.getAccessibleDevices(userId, deviceIds, groupIds)) {
            Collection<SummaryReportItem> deviceResults = this.calculateSummaryResults(userId, device, from, to, daily);
            for (SummaryReportItem summaryReport : deviceResults) {
                if (summaryReport.getStartTime() == null || summaryReport.getEndTime() == null) continue;
                result.add(summaryReport);
            }
        }
        return result;
    }

    public void getExcel(OutputStream outputStream, long userId, Collection<Long> deviceIds, Collection<Long> groupIds, Date from, Date to, boolean daily) throws StorageException, IOException {
        Collection<SummaryReportItem> summaries = this.getObjects(userId, deviceIds, groupIds, from, to, daily);
        File file = Paths.get(this.config.getString(Keys.TEMPLATES_ROOT), "export", "summary.xlsx").toFile();
        try (FileInputStream inputStream = new FileInputStream(file);){
            Context context = this.reportUtils.initializeContext(userId);
            context.putVar("summaries", summaries);
            context.putVar("from", (Object)from);
            context.putVar("to", (Object)to);
            JxlsHelper.getInstance().setUseFastFormulaProcessor(false).processTemplate((InputStream)inputStream, outputStream, context);
        }
    }
}

