/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.decompiler.component.BasicDecompilerCodeComparisonPanel;
import ghidra.app.decompiler.component.CDisplayPanel;
import ghidra.app.decompiler.component.DecompilerCodeComparisonPanel;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.DualDecompilerFieldPanelCoordinator;
import ghidra.program.util.ProgramLocation;

public class BasicDecompilerFieldPanelCoordinator
extends DualDecompilerFieldPanelCoordinator {
    private DecompilerCodeComparisonPanel<BasicDecompilerFieldPanelCoordinator> dualDecompilerPanel;
    private boolean syncLineLocation;

    public BasicDecompilerFieldPanelCoordinator(BasicDecompilerCodeComparisonPanel dualDecompilerPanel, boolean syncLineLocation) {
        super(dualDecompilerPanel);
        this.dualDecompilerPanel = dualDecompilerPanel;
        this.syncLineLocation = syncLineLocation;
    }

    @Override
    public void leftLocationChanged(ProgramLocation leftProgramLocation) {
        if (this.syncLineLocation) {
            CDisplayPanel focusedDecompilerPanel = this.dualDecompilerPanel.getFocusedDecompilerPanel();
            CDisplayPanel leftPanel = this.dualDecompilerPanel.getLeftPanel();
            CDisplayPanel rightPanel = this.dualDecompilerPanel.getRightPanel();
            if (focusedDecompilerPanel != leftPanel) {
                return;
            }
            DecompilerPanel leftDecompilerPanel = leftPanel.getDecompilerPanel();
            DecompilerPanel rightDecompilerPanel = rightPanel.getDecompilerPanel();
            FieldLocation leftFieldLocation = leftDecompilerPanel.getCursorPosition();
            rightDecompilerPanel.setCursorPosition(leftFieldLocation);
        }
    }

    @Override
    public void rightLocationChanged(ProgramLocation rightProgramLocation) {
        if (this.syncLineLocation) {
            CDisplayPanel focusedDecompilerPanel = this.dualDecompilerPanel.getFocusedDecompilerPanel();
            CDisplayPanel leftPanel = this.dualDecompilerPanel.getLeftPanel();
            CDisplayPanel rightPanel = this.dualDecompilerPanel.getRightPanel();
            if (focusedDecompilerPanel != rightPanel) {
                return;
            }
            DecompilerPanel leftDecompilerPanel = leftPanel.getDecompilerPanel();
            DecompilerPanel rightDecompilerPanel = rightPanel.getDecompilerPanel();
            FieldLocation rightFieldLocation = rightDecompilerPanel.getCursorPosition();
            leftDecompilerPanel.setCursorPosition(rightFieldLocation);
        }
    }
}

