/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.validator;

import docking.widgets.conditiontestpanel.ConditionResult;
import docking.widgets.conditiontestpanel.ConditionStatus;
import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.decompiler.parallel.DecompileConfigurer;
import ghidra.app.decompiler.parallel.DecompilerCallback;
import ghidra.app.decompiler.parallel.ParallelDecompiler;
import ghidra.app.plugin.core.analysis.validator.PostAnalysisValidator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DecompilerValidator
extends PostAnalysisValidator {
    private static final String NAME = "Decompiler Validator";

    public DecompilerValidator(Program program) {
        super(program);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConditionResult doRun(TaskMonitor monitor) {
        Listing listing = this.program.getListing();
        FunctionIterator iter = listing.getFunctions((AddressSetView)this.program.getMemory(), true);
        List<Function> functions = this.filterFunctions(this.program, iter, monitor);
        DecompilerCallback<String> callback = new DecompilerCallback<String>(this.program, (DecompileConfigurer)new DecompilerValidatorConfigurer()){

            @Override
            public String process(DecompileResults results, TaskMonitor m) throws Exception {
                Function f = results.getFunction();
                String errorMessage = results.getErrorMessage();
                if (!StringUtils.isBlank((CharSequence)errorMessage)) {
                    return f.getName() + " (" + f.getEntryPoint() + "): " + errorMessage;
                }
                return null;
            }
        };
        try {
            List<String> results = ParallelDecompiler.decompileFunctions(callback, this.program, functions, monitor);
            ConditionResult conditionResult = this.processResults(results);
            return conditionResult;
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)"Unexpected Exception validating functions", (Throwable)e);
        }
        finally {
            callback.dispose();
        }
        return new ConditionResult(ConditionStatus.Error, "Unable to validate functions (see log)");
    }

    private List<Function> filterFunctions(Program p, FunctionIterator iter, TaskMonitor monitor) {
        ArrayList<Function> results = new ArrayList<Function>();
        Listing listing = p.getListing();
        while (iter.hasNext()) {
            Function f = (Function)iter.next();
            if (monitor.isCancelled()) {
                return Collections.emptyList();
            }
            Address entryPoint = f.getEntryPoint();
            CodeUnit codeUnitAt = listing.getCodeUnitAt(entryPoint);
            if (codeUnitAt == null || !(codeUnitAt instanceof Instruction)) continue;
            results.add(f);
        }
        return results;
    }

    private ConditionResult processResults(Collection<String> results) {
        ConditionStatus status = ConditionStatus.Passed;
        StringBuilder warnings = new StringBuilder();
        for (String errorMessage : results) {
            if (errorMessage == null) continue;
            status = ConditionStatus.Warning;
            warnings.append(errorMessage);
            warnings.append("\n");
        }
        return new ConditionResult(status, warnings.toString());
    }

    public String getDescription() {
        return "make sure all the defined functions decompile without exception";
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        return this.getName();
    }

    private class DecompilerValidatorConfigurer
    implements DecompileConfigurer {
        DecompileOptions options = this.getDecompilerOptions();

        private DecompilerValidatorConfigurer() {
        }

        @Override
        public void configure(DecompInterface decompiler) {
            decompiler.setOptions(this.options);
            decompiler.openProgram(DecompilerValidator.this.program);
        }

        private DecompileOptions getDecompilerOptions() {
            try {
                CompilerSpec spec = DecompilerValidator.this.program.getCompilerSpec();
                PrototypeModel model = (PrototypeModel)spec.getPrototypeEvaluationModel(DecompilerValidator.this.program);
                this.options.setProtoEvalModel(model.getName());
            }
            catch (Exception e) {
                Msg.warn((Object)this, (Object)("problem setting prototype evaluation model: " + e.getMessage()));
            }
            return this.options;
        }
    }
}

