/*
 * Decompiled with CFR 0.152.
 */
package generic.text;

import generic.text.TextInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

public class TextLayoutGraphics
extends Graphics2D {
    private static final Component COMPONENT = new JPanel();
    private int transX;
    private int transY;
    private Shape clip;
    private StringBuilder buffer = new StringBuilder();
    private Font lastFont = new Font("SansSerif", 0, 12);
    private FontMetrics fontMetrics = TextLayoutGraphics.getFontMetricsForFont(this.lastFont);
    private List<TextInfo> textInfos = new ArrayList<TextInfo>();

    private static FontMetrics getFontMetricsForFont(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    @Override
    public void drawString(String str, float x, float y) {
        this.drawString(str, (int)x, (int)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator.toString(), x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.drawString(iterator.toString(), (int)x, (int)y);
    }

    @Override
    public void drawString(String str, int x, int y) {
        TextInfo newTextInfo = new TextInfo();
        newTextInfo.point = new Point(x + this.transX, y + this.transY);
        newTextInfo.text = str;
        newTextInfo.font = this.lastFont;
        this.textInfos.add(newTextInfo);
    }

    @Override
    public void setFont(Font font) {
        this.lastFont = font;
        this.fontMetrics = this.getFontMetrics(font);
    }

    public void flush() {
        if (this.textInfos.isEmpty()) {
            return;
        }
        Comparator pointComparator = (o1, o2) -> {
            TextInfo t1 = o1;
            TextInfo t2 = o2;
            int diff = t1.point.y - t2.point.y;
            if (diff != 0) {
                return diff;
            }
            diff = t1.point.x - t2.point.x;
            return diff;
        };
        Comparator rowComparator = (o1, o2) -> {
            TextInfo t1 = o1;
            TextInfo t2 = o2;
            int diff = t1.row - t2.row;
            if (diff != 0) {
                return diff;
            }
            diff = t1.point.x - t2.point.x;
            return diff;
        };
        TextInfo[] sortedTextInfos = new TextInfo[this.textInfos.size()];
        this.textInfos.toArray(sortedTextInfos);
        Arrays.sort(sortedTextInfos, pointComparator);
        int lastPos = sortedTextInfos[0].point.y;
        int curRow = 0;
        for (int i = 0; i < sortedTextInfos.length; ++i) {
            if (sortedTextInfos[i].point.y != lastPos) {
                lastPos = sortedTextInfos[i].point.y;
            }
            sortedTextInfos[i].row = ++curRow;
        }
        Arrays.sort(sortedTextInfos, rowComparator);
        int lastRow = 0;
        int lastXPos = 0;
        for (TextInfo sortedTextInfo : sortedTextInfos) {
            for (int j = lastRow; j < sortedTextInfo.row; ++j) {
                this.buffer.append('\n');
            }
            if (lastRow != sortedTextInfo.row) {
                lastXPos = 0;
            }
            lastRow = sortedTextInfo.row;
            FontMetrics metrics = COMPONENT.getFontMetrics(sortedTextInfo.font);
            int spaceWidth = metrics.charWidth(' ');
            int fillSpaces = Math.round((float)(sortedTextInfo.point.x - lastXPos) / (float)spaceWidth);
            if (fillSpaces == 0 && sortedTextInfo.point.x > lastXPos) {
                fillSpaces = 1;
            }
            for (int j = 0; j < fillSpaces; ++j) {
                this.buffer.append(' ');
            }
            lastXPos = sortedTextInfo.point.x + metrics.stringWidth(sortedTextInfo.text);
            this.buffer.append(sortedTextInfo.text);
        }
        this.buffer.append('\n');
        this.textInfos.clear();
    }

    public String getBuffer() {
        return this.buffer.toString();
    }

    @Override
    public void translate(int x, int y) {
        this.transX += x;
        this.transY += y;
    }

    @Override
    public Font getFont() {
        return this.lastFont;
    }

    @Override
    public Graphics create() {
        return this;
    }

    @Override
    public Rectangle getClipBounds() {
        return this.clip.getBounds();
    }

    @Override
    public Shape getClip() {
        return this.clip;
    }

    @Override
    public void setClip(Shape clip) {
        this.clip = clip;
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.fontMetrics;
    }

    @Override
    public void setClip(int x, int y, int width, int localHeight) {
        this.clip = new Rectangle(x, y, width, localHeight);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void clearRect(int x, int y, int width, int localHeight) {
    }

    @Override
    public void clipRect(int x, int y, int width, int localHeight) {
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
    }

    @Override
    public void drawOval(int x, int y, int width, int localHeight) {
    }

    @Override
    public void fillOval(int x, int y, int width, int localHeight) {
    }

    @Override
    public void fillRect(int x, int y, int width, int localHeight) {
    }

    @Override
    public void copyArea(int x, int y, int width, int localHeight, int dx, int dy) {
    }

    @Override
    public void drawArc(int x, int y, int width, int localHeight, int startAngle, int arcAngle) {
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int localHeight, int arcWidth, int arcHeight) {
    }

    @Override
    public void fillArc(int x, int y, int width, int localHeight, int startAngle, int arcAngle) {
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int localHeight, int arcWidth, int arcHeight) {
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
    }

    @Override
    public Color getColor() {
        return null;
    }

    @Override
    public void setColor(Color c) {
    }

    @Override
    public void setXORMode(Color c1) {
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return false;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int localHeight, ImageObserver observer) {
        return false;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return false;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return false;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int localHeight, Color bgcolor, ImageObserver observer) {
        return false;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return false;
    }

    @Override
    public void draw(Shape s) {
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return false;
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
    }

    @Override
    public void fill(Shape s) {
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return false;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    @Override
    public void setComposite(Composite comp) {
    }

    @Override
    public void setPaint(Paint paint) {
    }

    @Override
    public void setStroke(Stroke s) {
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return null;
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }

    @Override
    public void translate(double tx, double ty) {
    }

    @Override
    public void rotate(double theta) {
    }

    @Override
    public void rotate(double theta, double x, double y) {
    }

    @Override
    public void scale(double sx, double sy) {
    }

    @Override
    public void shear(double shx, double shy) {
    }

    @Override
    public void transform(AffineTransform Tx) {
    }

    @Override
    public void setTransform(AffineTransform Tx) {
    }

    @Override
    public AffineTransform getTransform() {
        return null;
    }

    @Override
    public Paint getPaint() {
        return null;
    }

    @Override
    public Composite getComposite() {
        return null;
    }

    @Override
    public void setBackground(Color color) {
    }

    @Override
    public Color getBackground() {
        return null;
    }

    @Override
    public Stroke getStroke() {
        return null;
    }

    @Override
    public void clip(Shape s) {
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return null;
    }
}

