/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4;

import ghidra.app.util.bin.BinaryReader;
import java.io.IOException;

public final class LEB128 {
    public static int decode32s(BinaryReader reader) throws IOException {
        long tmp = LEB128.decode(reader, true);
        if (tmp < Integer.MIN_VALUE || tmp > Integer.MAX_VALUE) {
            throw new IOException("LEB128 value out of range for java 32 bit signed int: " + Long.toString(tmp));
        }
        return (int)tmp;
    }

    public static int decode32u(BinaryReader reader) throws IOException {
        long tmp = LEB128.decode(reader, false);
        if (tmp < 0L || tmp > Integer.MAX_VALUE) {
            throw new IOException("LEB128 value out of range for java 32 bit unsigned int: " + Long.toUnsignedString(tmp));
        }
        return (int)tmp;
    }

    public static long decode(BinaryReader reader, boolean isSigned) throws IOException {
        int nextByte = 0;
        int shift = 0;
        long value = 0L;
        boolean overflow = false;
        do {
            nextByte = reader.readNextUnsignedByte();
            if (shift == 70 || !isSigned && shift == 63 && nextByte > 1) {
                overflow = true;
            }
            value |= (long)(nextByte & 0x7F) << shift;
            shift += 7;
        } while ((nextByte & 0x80) != 0);
        if (overflow) {
            throw new IOException("Unsupported LEB128 value, too large to fit in 64bit java long variable");
        }
        if (isSigned && shift < 64 && (nextByte & 0x40) != 0) {
            value |= (long)(-(1 << shift));
        }
        return value;
    }

    public static long decode(byte[] bytes, boolean isSigned) throws IOException {
        return LEB128.decode(bytes, 0, isSigned);
    }

    public static long decode(byte[] bytes, int offset, boolean isSigned) throws IOException {
        int nextByte = 0;
        int shift = 0;
        long value = 0L;
        for (int i = offset; i < bytes.length; ++i) {
            nextByte = bytes[i] & 0xFF;
            if (shift == 70 || !isSigned && shift == 63 && nextByte > 1) {
                throw new IOException("Unsupported LEB128 value, too large to fit in 64bit java long variable");
            }
            value |= (long)(nextByte & 0x7F) << shift;
            shift += 7;
            if ((nextByte & 0x80) == 0) break;
        }
        if (isSigned && shift < 64 && (nextByte & 0x40) != 0) {
            long tmp1 = 1L << shift;
            long tmp2 = -tmp1;
            value |= tmp2;
        }
        return value;
    }
}

