/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfoCommon;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DyldCacheSlideInfo2
extends DyldCacheSlideInfoCommon {
    private int page_size;
    private int page_starts_offset;
    private int page_starts_count;
    private int page_extras_offset;
    private int page_extras_count;
    private long delta_mask;
    private long value_add;
    private short[] page_starts_entries;
    private short[] page_extras_entries;

    public long getPageSize() {
        return (long)this.page_size & 0xFFFFFFFFFFFFFFFFL;
    }

    public long getPageStartsOffset() {
        return (long)this.page_starts_offset & 0xFFFFFFFFFFFFFFFFL;
    }

    public long getPageStartsCount() {
        return (long)this.page_starts_count & 0xFFFFFFFFFFFFFFFFL;
    }

    public long getPageExtrasOffset() {
        return (long)this.page_extras_offset & 0xFFFFFFFFFFFFFFFFL;
    }

    public long getPageExtrasCount() {
        return (long)this.page_extras_count & 0xFFFFFFFFFFFFFFFFL;
    }

    public long getDeltaMask() {
        return this.delta_mask;
    }

    public long getValueAdd() {
        return this.value_add;
    }

    public short[] getPageStartsEntries() {
        return this.page_starts_entries;
    }

    public short[] getPageExtrasEntries() {
        return this.page_extras_entries;
    }

    public DyldCacheSlideInfo2(BinaryReader reader) throws IOException {
        super(reader);
        this.page_size = reader.readNextInt();
        this.page_starts_offset = reader.readNextInt();
        this.page_starts_count = reader.readNextInt();
        this.page_extras_offset = reader.readNextInt();
        this.page_extras_count = reader.readNextInt();
        this.delta_mask = reader.readNextLong();
        this.value_add = reader.readNextLong();
        this.page_starts_entries = reader.readNextShortArray(this.page_starts_count);
        this.page_extras_entries = reader.readNextShortArray(this.page_extras_count);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_slide_info2", 0);
        struct.add(DWORD, "version", "");
        struct.add(DWORD, "page_size", "");
        struct.add(DWORD, "page_starts_offset", "");
        struct.add(DWORD, "page_starts_count", "");
        struct.add(DWORD, "page_extras_offset", "");
        struct.add(DWORD, "page_extras_count", "");
        struct.add(QWORD, "delta_mask", "");
        struct.add(QWORD, "value_add", "");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

