/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.Data;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import ghidra.util.classfinder.ExtensionPoint;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.math.BigInteger;

public abstract class FieldFactory
implements ExtensionPoint {
    public static final String FONT_OPTION_NAME = "BASE FONT";
    public static final Font DEFAULT_FIELD_FONT = new Font("monospaced", 0, 12);
    protected FieldFormatModel model;
    protected String name;
    protected int startX;
    protected int width;
    protected Color color;
    protected Color underlineColor = Color.BLUE;
    private FontMetrics defaultMetrics;
    private FontMetrics[] fontMetrics = new FontMetrics[4];
    protected Font baseFont;
    protected int style = -1;
    protected boolean enabled = true;
    protected HighlightProvider hlProvider;
    protected String colorOptionName;
    protected String styleOptionName;
    protected Options displayOptions;

    protected FieldFactory(String name, FieldFormatModel model, HighlightProvider highlightProvider, Options displayOptions, Options fieldOptions) {
        this.name = name;
        this.model = model;
        this.hlProvider = highlightProvider;
        this.colorOptionName = name + " Color";
        this.styleOptionName = name + " Style";
        this.width = 100;
        this.displayOptions = displayOptions;
        this.initDisplayOptions();
        fieldOptions.getOptions(name).setOptionsHelpLocation(new HelpLocation("CodeBrowserPlugin", name));
    }

    protected void initDisplayOptions() {
        this.baseFont = SystemUtilities.adjustForFontSizeOverride((Font)this.displayOptions.getFont(FONT_OPTION_NAME, DEFAULT_FIELD_FONT));
        this.displayOptions.registerOption(this.colorOptionName, (Object)Color.BLACK, null, "Sets the " + this.colorOptionName);
        this.displayOptions.registerOption(this.styleOptionName, (Object)-1, null, "Sets the " + this.style);
        this.color = this.displayOptions.getColor(this.colorOptionName, this.getDefaultColor());
        this.style = this.displayOptions.getInt(this.styleOptionName, -1);
        this.underlineColor = this.displayOptions.getColor(OptionsGui.UNDERLINE.getColorOptionName(), OptionsGui.UNDERLINE.getDefaultColor());
        this.setMetrics(this.baseFont);
    }

    public FieldFactory(String name) {
        this.name = name;
    }

    public void optionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        if (options == this.displayOptions) {
            this.displayOptionsChanged(options, optionName, oldValue, newValue);
        } else {
            this.fieldOptionsChanged(options, optionName, oldValue, newValue);
        }
    }

    public void servicesChanged() {
    }

    public abstract FieldFactory newInstance(FieldFormatModel var1, HighlightProvider var2, ToolOptions var3, ToolOptions var4);

    public void displayOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        if (optionName.equals(FONT_OPTION_NAME)) {
            this.baseFont = SystemUtilities.adjustForFontSizeOverride((Font)((Font)newValue));
            this.setMetrics(this.baseFont);
        } else if (optionName.equals(this.colorOptionName)) {
            this.color = (Color)newValue;
        } else if (optionName.equals(this.styleOptionName)) {
            this.style = options.getInt(optionName, -1);
            this.setMetrics(this.baseFont);
        } else if (optionName.equals(OptionsGui.UNDERLINE.getColorOptionName())) {
            this.underlineColor = (Color)newValue;
        }
        this.model.update();
    }

    public void fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
    }

    public String getFieldName() {
        return this.name;
    }

    public Color getDefaultColor() {
        return Color.BLACK;
    }

    public int getStartX() {
        return this.startX;
    }

    public void setStartX(int x) {
        this.startX = x;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public FieldFormatModel getFieldModel() {
        return this.model;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean state) {
        this.enabled = state;
        this.model.modelChanged();
    }

    public abstract ListingField getField(ProxyObj<?> var1, int var2);

    public abstract FieldLocation getFieldLocation(ListingField var1, BigInteger var2, int var3, ProgramLocation var4);

    public abstract ProgramLocation getProgramLocation(int var1, int var2, ListingField var3);

    public abstract boolean acceptsType(int var1, Class<?> var2);

    protected boolean hasSamePath(ListingField bf, ProgramLocation loc) {
        Object obj = bf.getProxy().getObject();
        if (obj instanceof Data) {
            Data data = (Data)obj;
            int[] path1 = data.getComponentPath();
            int[] path2 = loc.getComponentPath();
            if (path1 == null) {
                return path2 == null || path2.length == 0;
            }
            if (path2 == null) {
                return path1.length == 0;
            }
            if (path1.length != path2.length) {
                return false;
            }
            for (int i = 0; i < path2.length; ++i) {
                if (path1[i] == path2[i]) continue;
                return false;
            }
        }
        return true;
    }

    public String getFieldText() {
        return this.name;
    }

    public FontMetrics getMetrics() {
        return this.getMetrics(this.style);
    }

    protected FontMetrics getMetrics(int fontStyle) {
        if (fontStyle == -1) {
            return this.defaultMetrics;
        }
        return this.fontMetrics[fontStyle];
    }

    private void setMetrics(Font newFont) {
        this.defaultMetrics = Toolkit.getDefaultToolkit().getFontMetrics(newFont);
        for (int i = 0; i < this.fontMetrics.length; ++i) {
            Font font = new Font(newFont.getFamily(), i, newFont.getSize());
            this.fontMetrics[i] = Toolkit.getDefaultToolkit().getFontMetrics(font);
        }
    }
}

