/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.tree;

import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyGrammar;
import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyProduction;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyConstructorSemantic;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNonTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblySymbol;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseTreeNode;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AssemblyParseBranch
extends AssemblyParseTreeNode
implements Iterable<AssemblyParseTreeNode> {
    private final List<AssemblyParseTreeNode> substs = new ArrayList<AssemblyParseTreeNode>();
    private final AssemblyProduction prod;

    public AssemblyParseBranch(AssemblyGrammar grammar, AssemblyProduction prod) {
        super(grammar);
        this.prod = prod;
    }

    public int hashCode() {
        int result = this.prod.hashCode();
        for (AssemblyParseTreeNode n : this.substs) {
            result *= 31;
            result += n.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssemblyParseBranch that = (AssemblyParseBranch)obj;
        return this.substs.equals(that.substs);
    }

    public void addChild(AssemblyParseTreeNode child) {
        assert (this.expects().equals(child.getSym()));
        this.substs.add(0, child);
        child.setParent(this);
    }

    protected AssemblySymbol expects() {
        if (!this.isComplete()) {
            return (AssemblySymbol)this.prod.get(this.prod.size() - this.substs.size() - 1);
        }
        return null;
    }

    protected boolean isComplete() {
        return this.prod.size() == this.substs.size();
    }

    @Override
    public AssemblyNonTerminal getSym() {
        return this.prod.getLHS();
    }

    @Override
    protected void print(PrintStream out, String indent) {
        out.print(indent + this.getSym() + " := " + this.prod);
        Collection<AssemblyConstructorSemantic> sems = this.grammar.getSemantics(this.prod);
        if (!sems.isEmpty()) {
            out.print(" (" + StringUtils.join(sems, (String)", ") + ")");
        }
        out.println();
        for (AssemblyParseTreeNode s : this.substs) {
            s.print(out, "  " + indent);
        }
    }

    public String toString() {
        return ((AssemblyNonTerminal)this.prod.getLHS()).toString();
    }

    public AssemblyProduction getProduction() {
        return this.prod;
    }

    public List<AssemblyParseTreeNode> getSubstitutions() {
        return Collections.unmodifiableList(this.substs);
    }

    @Override
    public Iterator<AssemblyParseTreeNode> iterator() {
        return this.getSubstitutions().iterator();
    }

    public AssemblyParseTreeNode getSubstitution(int i) {
        return this.substs.get(i);
    }

    @Override
    public boolean isConstructor() {
        return true;
    }

    @Override
    public String generateString() {
        StringBuilder sb = new StringBuilder();
        for (AssemblyParseTreeNode node : this.substs) {
            sb.append(node.generateString());
        }
        return sb.toString();
    }
}

