/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.external;

import db.DBHandle;
import db.Record;
import db.RecordIterator;
import ghidra.program.database.ManagerDB;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.external.ExternalLocationDB;
import ghidra.program.database.external.OldExtNameAdapter;
import ghidra.program.database.external.OldExtRefAdapter;
import ghidra.program.database.function.FunctionManagerDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.symbol.CodeSymbol;
import ghidra.program.database.symbol.LibrarySymbol;
import ghidra.program.database.symbol.NamespaceManager;
import ghidra.program.database.symbol.SymbolDB;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Library;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalLocationIterator;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.LanguageTranslator;
import ghidra.util.Lock;
import ghidra.util.Msg;
import ghidra.util.datastruct.LongObjectHashtable;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ExternalManagerDB
implements ManagerDB,
ExternalManager {
    private AddressMap addrMap;
    private NamespaceManager scopeMgr;
    private SymbolManager symbolMgr;
    private FunctionManagerDB functionMgr;
    private ProgramDB program;
    private Lock lock;
    private OldExtNameAdapter oldNameAdapter;
    private OldExtRefAdapter oldExtRefAdapter;

    public ExternalManagerDB(DBHandle handle, AddressMap addrMap, int openMode, Lock lock, TaskMonitor monitor) throws CancelledException, IOException, VersionException {
        this.addrMap = addrMap;
        this.lock = lock;
        this.initializeOldAdapters(handle, openMode, monitor);
    }

    private void initializeOldAdapters(DBHandle handle, int openMode, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        try {
            this.oldNameAdapter = OldExtNameAdapter.getAdapter(handle, openMode, monitor);
            this.oldExtRefAdapter = OldExtRefAdapter.getAdapter(handle, openMode, monitor);
        }
        catch (VersionException versionException) {
            // empty catch block
        }
        if (this.oldNameAdapter != null && this.oldExtRefAdapter != null && openMode != 3) {
            throw new VersionException(true);
        }
    }

    @Override
    public void setProgram(ProgramDB program) {
        this.program = program;
        this.symbolMgr = (SymbolManager)program.getSymbolTable();
        this.functionMgr = (FunctionManagerDB)program.getFunctionManager();
        this.scopeMgr = program.getNamespaceManager();
    }

    @Override
    public void programReady(int openMode, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
        if (openMode != 3) {
            return;
        }
        if (this.upgradeOldExtRefAdapter(monitor)) {
            return;
        }
    }

    private boolean upgradeOldExtRefAdapter(TaskMonitor monitor) throws IOException, CancelledException {
        if (this.oldNameAdapter == null || this.oldExtRefAdapter == null) {
            return false;
        }
        monitor.setMessage("Processing Old External Names...");
        monitor.initialize((long)this.oldNameAdapter.getRecordCount());
        int cnt = 0;
        LongObjectHashtable nameMap = new LongObjectHashtable();
        RecordIterator iter = this.oldNameAdapter.getRecords();
        while (iter.hasNext()) {
            monitor.checkCanceled();
            Record rec = iter.next();
            String name = rec.getString(0);
            try {
                this.addExternalName(name, rec.getString(1), SourceType.USER_DEFINED);
                nameMap.put(rec.getKey(), (Object)name);
            }
            catch (DuplicateNameException duplicateNameException) {
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            monitor.setProgress((long)(++cnt));
        }
        AddressMap oldAddrMap = this.addrMap.getOldAddressMap();
        ReferenceManager refMgr = this.program.getReferenceManager();
        monitor.setMessage("Processing Old External References...");
        monitor.initialize((long)this.oldExtRefAdapter.getRecordCount());
        cnt = 0;
        iter = this.oldExtRefAdapter.getRecords();
        while (iter.hasNext()) {
            monitor.checkCanceled();
            Record rec = iter.next();
            Address fromAddr = oldAddrMap.decodeAddress(rec.getLongValue(0));
            short opIndex = rec.getShortValue(1);
            boolean userDefined = rec.getBooleanValue(2);
            String name = (String)nameMap.get(rec.getLongValue(3));
            if (name == null) continue;
            String label = rec.getString(4);
            Address addr = rec.getBooleanValue(6) ? oldAddrMap.decodeAddress(rec.getLongValue(5)) : null;
            try {
                refMgr.addExternalReference(fromAddr, name, label, addr, userDefined ? SourceType.USER_DEFINED : SourceType.IMPORTED, (int)opIndex, RefType.DATA);
            }
            catch (DuplicateNameException e) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            }
            catch (InvalidInputException e) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            }
            monitor.setProgress((long)(++cnt));
        }
        this.oldExtRefAdapter = null;
        return true;
    }

    @Override
    public void invalidateCache(boolean all) throws IOException {
    }

    @Override
    public void deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException {
    }

    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExternalLocation addExtLocation(String extLibraryName, String extLabel, Address extAddr, SourceType sourceType) throws InvalidInputException, DuplicateNameException {
        SourceType locSourceType = this.checkExternalLabel(extLabel, extAddr, sourceType);
        this.lock.acquire();
        try {
            Namespace libraryScope = this.getLibraryScope(extLibraryName);
            if (libraryScope == null) {
                libraryScope = this.addExternalName(extLibraryName, null, sourceType);
            }
            ExternalLocation externalLocation = this.addExtLocation(libraryScope, extLabel, extAddr, false, locSourceType, true);
            return externalLocation;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExternalLocation addExtLocation(Namespace extParentNamespace, String extLabel, Address extAddr, SourceType sourceType) throws InvalidInputException, DuplicateNameException {
        this.lock.acquire();
        try {
            ExternalLocation externalLocation = this.addExtLocation(extParentNamespace, extLabel, extAddr, false, sourceType, true);
            return externalLocation;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExternalLocation addExtLocation(Namespace extParentNamespace, String extLabel, Address extAddr, SourceType sourceType, boolean reuseExisting) throws InvalidInputException, DuplicateNameException {
        this.lock.acquire();
        try {
            ExternalLocation externalLocation = this.addExtLocation(extParentNamespace, extLabel, extAddr, false, sourceType, reuseExisting);
            return externalLocation;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExternalLocation addExtFunction(String extLibraryName, String extLabel, Address extAddr, SourceType sourceType) throws InvalidInputException, DuplicateNameException {
        SourceType locSourceType = this.checkExternalLabel(extLabel, extAddr, sourceType);
        this.lock.acquire();
        try {
            Namespace libraryScope = this.getLibraryScope(extLibraryName);
            if (libraryScope == null) {
                libraryScope = this.addExternalName(extLibraryName, null, sourceType != SourceType.DEFAULT ? sourceType : SourceType.ANALYSIS);
            }
            ExternalLocation externalLocation = this.addExtLocation(libraryScope, extLabel, extAddr, true, locSourceType, true);
            return externalLocation;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExternalLocation addExtFunction(Namespace extParentNamespace, String extLabel, Address extAddr, SourceType sourceType) throws InvalidInputException, DuplicateNameException {
        this.lock.acquire();
        try {
            ExternalLocation externalLocation = this.addExtLocation(extParentNamespace, extLabel, extAddr, true, sourceType, true);
            return externalLocation;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExternalLocation addExtFunction(Namespace extNamespace, String extLabel, Address extAddr, SourceType sourceType, boolean reuseExisting) throws InvalidInputException, DuplicateNameException {
        this.lock.acquire();
        try {
            ExternalLocation externalLocation = this.addExtLocation(extNamespace, extLabel, extAddr, true, sourceType, reuseExisting);
            return externalLocation;
        }
        finally {
            this.lock.release();
        }
    }

    private SourceType checkExternalLabel(String extLabel, Address extAddr, SourceType source) throws InvalidInputException {
        if (extLabel == null || extLabel.length() == 0) {
            extLabel = null;
        }
        if (extLabel == null && extAddr == null) {
            throw new InvalidInputException("Either an external label or address is required");
        }
        return extLabel == null ? SourceType.DEFAULT : source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalLocation addExtLocation(Namespace extNamespace, String extLabel, Address extAddr, boolean isFunction, SourceType sourceType, boolean reuseExisting) throws InvalidInputException, DuplicateNameException {
        if (extNamespace == null) {
            extNamespace = this.getLibraryScope("<EXTERNAL>");
            if (extNamespace == null) {
                extNamespace = this.addExternalLibraryName("<EXTERNAL>", SourceType.ANALYSIS);
            }
        } else if (!extNamespace.isExternal()) {
            throw new InvalidInputException("The namespace must be an external namespace.");
        }
        sourceType = this.checkExternalLabel(extLabel, extAddr, sourceType);
        if (extAddr != null && !extAddr.isLoadedMemoryAddress()) {
            throw new InvalidInputException("Invalid memory address");
        }
        this.lock.acquire();
        try {
            SymbolDB s;
            String extMemAddrString;
            ExternalLocationDB extLoc;
            if (sourceType == SourceType.DEFAULT) {
                extLabel = null;
            }
            if ((extLoc = (ExternalLocationDB)this.getExtLocation(extNamespace, extLabel, extAddr, reuseExisting)) != null && (extAddr != null || reuseExisting)) {
                if (extLabel != null && !extLabel.equals(extLoc.getLabel())) {
                    extLoc.setLabel(extLabel, sourceType);
                }
                if (isFunction) {
                    extLoc = (ExternalLocationDB)this.createFunction(extLoc).getExternalLocation();
                }
                ExternalLocationDB externalLocationDB = extLoc;
                return externalLocationDB;
            }
            Address externalSpaceAddress = this.symbolMgr.getNextExternalSymbolAddress();
            String string = extMemAddrString = extAddr != null ? extAddr.toString() : null;
            if (isFunction) {
                Function function = this.functionMgr.createExternalFunction(externalSpaceAddress, extLabel, extNamespace, extMemAddrString, sourceType);
                s = (SymbolDB)function.getSymbol();
            } else {
                s = (SymbolDB)this.symbolMgr.createCodeSymbol(externalSpaceAddress, extLabel, extNamespace, sourceType, extMemAddrString);
            }
            ExternalLocationDB externalLocationDB = new ExternalLocationDB(this, s);
            return externalLocationDB;
        }
        finally {
            this.lock.release();
        }
    }

    private ExternalLocation getExtLocation(Namespace library, String extLabel, Address extAddr, boolean reuseExisting) throws InvalidInputException {
        ExternalLocation match;
        if (extLabel != null && (extLabel.length() == 0 || SymbolUtilities.isReservedExternalDefaultName(extLabel, this.addrMap.getAddressFactory()))) {
            extLabel = null;
        }
        if ((match = this.findMatchingLocationByName(library, extLabel, extAddr, reuseExisting)) != null) {
            return match;
        }
        List<ExternalLocation> locations = this.getExternalLocations(library);
        if (extLabel == null) {
            return this.findMatchingLocationByAddress(locations, extAddr, reuseExisting);
        }
        return this.findMatchingLocationByOriginalImportName(locations, extLabel, extAddr);
    }

    private ExternalLocation findMatchingLocationByOriginalImportName(List<ExternalLocation> locations, String extLabel, Address extAddr) {
        if (extLabel != null && extAddr == null) {
            for (ExternalLocation externalLocation : locations) {
                if (!extLabel.equals(externalLocation.getOriginalImportedName())) continue;
                return externalLocation;
            }
        }
        return null;
    }

    private List<ExternalLocation> getExternalLocations(Namespace library) {
        ArrayList<ExternalLocation> list = new ArrayList<ExternalLocation>();
        SymbolIterator iter = this.symbolMgr.getSymbols(library);
        for (Symbol symbol : iter) {
            ExternalLocation extLoc = this.getExternalLocation(symbol);
            if (extLoc == null) continue;
            list.add(extLoc);
        }
        return list;
    }

    private ExternalLocation findMatchingLocationByName(Namespace libScope, String extLabel, Address extAddr, boolean reuseExisting) {
        if (extLabel == null) {
            return null;
        }
        List<ExternalLocation> externalLocations = this.getExternalLocations(libScope, extLabel);
        if (externalLocations.isEmpty()) {
            return null;
        }
        if (extAddr != null) {
            for (ExternalLocation externalLocation : externalLocations) {
                if (!extAddr.equals(externalLocation.getAddress())) continue;
                return externalLocation;
            }
            if (reuseExisting) {
                for (ExternalLocation externalLocation : externalLocations) {
                    if (externalLocation.getAddress() != null) continue;
                    return externalLocation;
                }
            }
            return null;
        }
        for (ExternalLocation externalLocation : externalLocations) {
            if (externalLocation.getAddress() != null) continue;
            return externalLocation;
        }
        return reuseExisting ? externalLocations.get(0) : null;
    }

    private ExternalLocation findMatchingLocationByAddress(List<ExternalLocation> locations, Address extAddr, boolean reuseExisting) {
        for (ExternalLocation externalLocation : locations) {
            if (!extAddr.equals(externalLocation.getAddress()) || !reuseExisting && externalLocation.getLabel() != null) continue;
            return externalLocation;
        }
        return null;
    }

    @Override
    public List<ExternalLocation> getExternalLocations(Namespace libScope, String extLabel) {
        ArrayList<ExternalLocation> externalLocations = new ArrayList<ExternalLocation>();
        List<Symbol> symbols = this.symbolMgr.getSymbols(extLabel, libScope);
        for (Symbol symbol : symbols) {
            ExternalLocation externalLocation = this.getExternalLocation(symbol);
            if (externalLocation == null) continue;
            externalLocations.add(externalLocation);
        }
        return externalLocations;
    }

    @Override
    public List<ExternalLocation> getExternalLocations(String libraryName, String label) {
        Namespace libraryScope = this.getLibraryScope(libraryName);
        if (libraryScope == null) {
            return Collections.emptyList();
        }
        return this.getExternalLocations(libraryScope, label);
    }

    @Override
    public ExternalLocation getUniqueExternalLocation(Namespace namespace, String label) {
        List<ExternalLocation> externalLocations = this.getExternalLocations(namespace, label);
        if (externalLocations.size() == 1) {
            return externalLocations.get(0);
        }
        return null;
    }

    @Override
    public ExternalLocation getUniqueExternalLocation(String libraryName, String label) {
        Namespace libScope = this.getLibraryScope(libraryName);
        if (libScope == null) {
            return null;
        }
        return this.getUniqueExternalLocation(libScope, label);
    }

    @Override
    public ExternalLocation getExternalLocation(String extName, String extLabel) {
        Namespace libScope = this.getLibraryScope(extName);
        return this.getExternalLocation(libScope, extLabel);
    }

    @Override
    public ExternalLocation getExternalLocation(Namespace extNamespace, String extLabel) {
        List<ExternalLocation> externalLocations = this.getExternalLocations(extNamespace, extLabel);
        if (externalLocations.isEmpty()) {
            return null;
        }
        return externalLocations.get(0);
    }

    public static String getDefaultExternalName(SymbolDB sym) {
        SymbolType type = sym.getSymbolType();
        if (type != SymbolType.LABEL && type != SymbolType.FUNCTION || !sym.isExternal()) {
            throw new AssertException();
        }
        ExternalLocationDB.ExternalData3 externalData3 = ExternalLocationDB.getExternalData3(sym);
        Address addr = externalData3.getAddress(sym.getProgram().getAddressFactory());
        if (addr == null) {
            throw new AssertException("External should not be default without memory address");
        }
        if (type == SymbolType.FUNCTION) {
            return SymbolUtilities.getDefaultExternalFunctionName(addr);
        }
        long dataTypeID = sym.getSymbolData1();
        DataType dt = dataTypeID < 0L ? null : sym.getProgram().getDataTypeManager().getDataType(dataTypeID);
        return SymbolUtilities.getDefaultExternalName(addr, dt);
    }

    ProgramDB getProgram() {
        return this.program;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalLocation getExtLocation(Address externalAddr) {
        if (externalAddr.getAddressSpace() != AddressSpace.EXTERNAL_SPACE) {
            throw new IllegalArgumentException("Expected external address");
        }
        this.lock.acquire();
        try {
            Symbol[] symbols = this.symbolMgr.getSymbols(externalAddr);
            if (symbols.length == 1) {
                ExternalLocationDB externalLocationDB = new ExternalLocationDB(this, (SymbolDB)symbols[0]);
                return externalLocationDB;
            }
            if (symbols.length > 2) {
                throw new AssertException("More than two symbols are not expected for external addresses: " + externalAddr);
            }
            ExternalLocation externalLocation = null;
            return externalLocation;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public ExternalLocation getExternalLocation(Symbol symbol) {
        if (!(symbol instanceof SymbolDB) || !symbol.isExternal()) {
            return null;
        }
        SymbolType symbolType = symbol.getSymbolType();
        if (symbolType == SymbolType.LABEL || symbolType == SymbolType.FUNCTION) {
            return this.getExtLocation(symbol.getAddress());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeExternalLocation(Address externalAddr) {
        this.lock.acquire();
        try {
            ExternalLocationDB loc = (ExternalLocationDB)this.getExtLocation(externalAddr);
            if (loc != null) {
                loc.getSymbol().delete();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    SymbolManager getSymbolManager() {
        return this.symbolMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeExternalLibrary(String name) {
        this.lock.acquire();
        try {
            Symbol s = this.symbolMgr.getLibrarySymbol(name);
            if (s != null) {
                if (this.symbolMgr.getChildren(s).hasNext()) {
                    boolean bl = false;
                    return bl;
                }
                s.delete();
            }
        }
        finally {
            this.lock.release();
        }
        return true;
    }

    @Override
    public void updateExternalLibraryName(String oldName, String newName, SourceType source) throws DuplicateNameException, InvalidInputException {
        Symbol s = this.symbolMgr.getLibrarySymbol(oldName);
        if (s != null) {
            s.setName(newName, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Library addExternalLibraryName(String name, SourceType source) throws DuplicateNameException, InvalidInputException {
        this.lock.acquire();
        try {
            Symbol librarySymbol = this.symbolMgr.getLibrarySymbol(name);
            if (librarySymbol != null) {
                Library library = (Library)librarySymbol.getObject();
                return library;
            }
            Library library = this.addExternalName(name, null, source);
            return library;
        }
        finally {
            this.lock.release();
        }
    }

    private Library addExternalName(String name, String pathname, SourceType source) throws DuplicateNameException, InvalidInputException {
        SymbolDB s = this.symbolMgr.createSpecialSymbol(Address.NO_ADDRESS, name, this.scopeMgr.getGlobalNamespace(), SymbolType.LIBRARY, -1L, 0, pathname, source);
        return (Library)s.getObject();
    }

    private Namespace getLibraryScope(String name) {
        Symbol s = this.symbolMgr.getLibrarySymbol(name);
        return s == null ? null : (Namespace)s.getObject();
    }

    @Override
    public boolean contains(String libraryName) {
        return this.symbolMgr.getLibrarySymbol(libraryName) != null;
    }

    @Override
    public String[] getExternalLibraryNames() {
        Symbol[] syms;
        ArrayList<String> list = new ArrayList<String>();
        for (Symbol s : syms = this.symbolMgr.getSymbols(Address.NO_ADDRESS)) {
            if (s.getSymbolType() != SymbolType.LIBRARY) continue;
            list.add(s.getName());
        }
        String[] names = new String[list.size()];
        list.toArray(names);
        return names;
    }

    @Override
    public Library getExternalLibrary(String name) {
        Symbol s = this.symbolMgr.getLibrarySymbol(name);
        return s != null ? (Library)s.getObject() : null;
    }

    @Override
    public String getExternalLibraryPath(String externalName) {
        SymbolDB s = (SymbolDB)this.symbolMgr.getLibrarySymbol(externalName);
        if (s instanceof LibrarySymbol) {
            return s.getSymbolData3();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExternalPath(String externalName, String externalPath, boolean userDefined) throws InvalidInputException {
        block8: {
            if ("<EXTERNAL>".equals(externalName)) {
                Msg.warn((Object)this, (Object)("Ignoring external library path for " + externalName));
                return;
            }
            this.validateExternalPath(externalPath);
            this.lock.acquire();
            try {
                SymbolDB s = (SymbolDB)this.symbolMgr.getLibrarySymbol(externalName);
                if (s == null) {
                    try {
                        this.addExternalName(externalName, externalPath, userDefined ? SourceType.USER_DEFINED : SourceType.IMPORTED);
                        break block8;
                    }
                    catch (DuplicateNameException e) {
                        throw new AssertException((Throwable)e);
                    }
                }
                if (s instanceof LibrarySymbol) {
                    s.setSymbolData3(externalPath);
                }
            }
            finally {
                this.lock.release();
            }
        }
    }

    private void validateExternalPath(String path) throws InvalidInputException {
        if (path == null) {
            return;
        }
        int len = path.length();
        if (len == 0 || path.charAt(0) != '/') {
            throw new InvalidInputException("Absolute path must begin with '/'");
        }
    }

    Function createFunction(ExternalLocationDB extLoc) {
        if (extLoc.isFunction()) {
            return extLoc.getFunction();
        }
        this.lock.acquire();
        try {
            SymbolDB symbol = (SymbolDB)extLoc.getSymbol();
            if (!(symbol instanceof CodeSymbol)) {
                Function function = null;
                return function;
            }
            String extData3 = symbol.getSymbolData3();
            String name = symbol.getName();
            Namespace namespace = symbol.getParentNamespace();
            Address extAddr = symbol.getAddress();
            SourceType source = symbol.getSource();
            ((CodeSymbol)symbol).delete(true);
            Function function = this.functionMgr.createExternalFunction(extAddr, name, namespace, extData3, source);
            return function;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Unexpected exception", e);
        }
        finally {
            this.lock.release();
        }
    }

    AddressMap getAddressMap() {
        return this.addrMap;
    }

    @Override
    public ExternalLocationIterator getExternalLocations(Address memoryAddress) {
        return new ExternalLocationDBIterator(this.symbolMgr.getExternalSymbols(), memoryAddress);
    }

    @Override
    public ExternalLocationIterator getExternalLocations(String externalName) {
        Namespace scope = this.getLibraryScope(externalName);
        if (scope != null) {
            return new ExternalLocationDBIterator(this.symbolMgr.getSymbols(scope));
        }
        return new ExternalLocationDBIterator();
    }

    public void setLanguage(LanguageTranslator translator, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Translate External Addresses...");
        AddressFactory oldAddrFactory = translator.getOldLanguage().getAddressFactory();
        SymbolIterator externalSymbols = this.symbolMgr.getExternalSymbols();
        while (externalSymbols.hasNext()) {
            Address addr;
            monitor.checkCanceled();
            SymbolDB s = (SymbolDB)externalSymbols.next();
            ExternalLocationDB.ExternalData3 externalData3 = ExternalLocationDB.getExternalData3(s);
            String addrStr = externalData3.getAddressString();
            if (addrStr == null || (addr = oldAddrFactory.getAddress(addrStr)) == null) continue;
            AddressSpace newAddressSpace = translator.getNewAddressSpace(addr.getAddressSpace().getName());
            if (newAddressSpace == null || !newAddressSpace.isLoadedMemorySpace()) {
                throw new AssertException("Failed to map external memory address: " + addrStr);
            }
            String newAddrStr = (addr = newAddressSpace.getAddress(addr.getOffset())).toString();
            if (newAddrStr.equals(addrStr)) continue;
            ExternalLocationDB.updateSymbolData3(s, externalData3.getOriginalImportedName(), newAddrStr);
        }
    }

    SymbolDB createSymbolForOriginalName(Address address, Namespace namespace, String oldName, SourceType oldType) throws InvalidInputException {
        return (SymbolDB)this.symbolMgr.createCodeSymbol(address, oldName, namespace, oldType, null);
    }

    private class ExternalLocationDBIterator
    implements ExternalLocationIterator {
        private SymbolIterator symIter;
        private Address matchingAddress;
        private ExternalLocation nextExtLoc;

        ExternalLocationDBIterator() {
        }

        ExternalLocationDBIterator(SymbolIterator symIter, Address matchingAddress) {
            this.symIter = symIter;
            this.matchingAddress = matchingAddress;
        }

        ExternalLocationDBIterator(SymbolIterator symIter) {
            this.symIter = symIter;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private ExternalLocation getValidExternalLocation(SymbolDB s) {
            ExternalLocation externalLocation = ExternalManagerDB.this.getExternalLocation(s);
            if (externalLocation == null) {
                return null;
            }
            if (this.matchingAddress == null) {
                return externalLocation;
            }
            if (this.matchingAddress.equals(externalLocation.getAddress())) {
                return externalLocation;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            if (this.symIter != null) {
                while (this.nextExtLoc == null && this.symIter.hasNext()) {
                    SymbolDB s = (SymbolDB)this.symIter.next();
                    this.nextExtLoc = this.getValidExternalLocation(s);
                }
            }
            return this.nextExtLoc != null;
        }

        @Override
        public ExternalLocation next() {
            if (this.hasNext()) {
                ExternalLocation tmpExtLoc = this.nextExtLoc;
                this.nextExtLoc = null;
                return tmpExtLoc;
            }
            return null;
        }
    }
}

