/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.framework.ShutdownHookRegistry;
import ghidra.framework.ShutdownPriority;
import ghidra.program.model.data.ArchiveType;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.BuiltInDataTypeClassExclusionFilter;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeDependencyException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.StandAloneDataTypeManager;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.UniversalID;
import ghidra.util.classfinder.ClassFilter;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.AssertException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.event.ChangeListener;

public class BuiltInDataTypeManager
extends StandAloneDataTypeManager {
    private static BuiltInDataTypeManager manager;
    private ChangeListener classSearcherListener = e -> this.refresh();

    public static synchronized BuiltInDataTypeManager getDataTypeManager() {
        if (manager == null) {
            manager = new BuiltInDataTypeManager();
            Thread cleanupTask = new Thread(() -> {
                if (manager != null) {
                    manager.dispose();
                    manager = null;
                }
            }, "Builtin DataType Manager Cleanup Thread");
            ShutdownHookRegistry.addShutdownHook((Runnable)cleanupTask, (ShutdownPriority)ShutdownPriority.DISPOSE_DATABASES.before());
        }
        return manager;
    }

    private BuiltInDataTypeManager() {
        super("BuiltInTypes");
        this.initialize();
    }

    @Override
    public synchronized int startTransaction(String description) {
        if (manager != null) {
            throw new UnsupportedOperationException("Built-in datatype manager may not be modified");
        }
        return super.startTransaction(description);
    }

    @Override
    public synchronized void endTransaction(int transactionID, boolean commit) {
        if (manager != null) {
            throw new UnsupportedOperationException();
        }
        super.endTransaction(transactionID, commit);
    }

    @Override
    public Category createCategory(CategoryPath path) {
        if (path != CategoryPath.ROOT) {
            throw new UnsupportedOperationException("Built-in category limited to root category only");
        }
        return super.createCategory(path);
    }

    private synchronized void dispose() {
        ClassSearcher.removeChangeListener((ChangeListener)this.classSearcherListener);
        super.close();
    }

    @Override
    public void close() {
    }

    private synchronized void refresh() {
        this.populateBuiltInTypes();
    }

    private void initialize() {
        try {
            this.populateBuiltInTypes();
        }
        catch (Throwable t) {
            Msg.showError((Object)this, null, (String)"Error", (Object)"Error populating Built In Data Types", (Throwable)t);
        }
        ClassSearcher.addChangeListener((ChangeListener)this.classSearcherListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateBuiltInTypes() {
        int id = super.startTransaction("Populate");
        try {
            ArrayList<DataType> list = new ArrayList<DataType>();
            BuiltInDataTypeClassExclusionFilter filter = new BuiltInDataTypeClassExclusionFilter();
            Set datatypes = ClassSearcher.getInstances(BuiltInDataType.class, (ClassFilter)filter);
            for (BuiltInDataType datatype : datatypes) {
                list.clear();
                this.findDataTypes(datatype.getName(), list);
                if (list.size() == 0) {
                    super.resolve(datatype, null);
                    continue;
                }
                if (!list.get(0).isEquivalent(datatype)) {
                    Msg.showError((Object)this, null, (String)"Invalid BuiltIn Data Type", (Object)("BuiltIn datatype name collision between " + datatype.getClass().getSimpleName() + " and " + list.get(0).getClass().getSimpleName() + ", both named '" + datatype.getName() + "'"));
                    continue;
                }
                if (list.size() == 1) continue;
                throw new AssertException("Should be no duplicate named nuilt-in types");
            }
        }
        finally {
            super.endTransaction(id, true);
        }
    }

    protected UniversalID resolveSourceArchiveID(DataType dataType) {
        if (dataType instanceof BuiltInDataType) {
            return DataTypeManager.BUILT_IN_ARCHIVE_UNIVERSAL_ID;
        }
        throw new IllegalArgumentException("Only Built-In data types can be resolved by the BuiltInTypes manager.");
    }

    @Override
    public ArchiveType getType() {
        return ArchiveType.BUILT_IN;
    }

    @Override
    public DataType resolve(DataType dataType, DataTypeConflictHandler handler) {
        return super.resolve(dataType, DataTypeConflictHandler.BUILT_IN_MANAGER_HANDLER);
    }

    @Override
    public DataType addDataType(DataType originalDataType, DataTypeConflictHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setName(String name) throws InvalidNameException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void associateDataTypeWithArchive(DataType datatype, SourceArchive archive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(DataType dataType, TaskMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataType replaceDataType(DataType existingDt, DataType replacementDt, boolean updateCategoryPath) throws DataTypeDependencyException {
        throw new UnsupportedOperationException();
    }
}

