/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.data.ArrayStringable;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeWithCharset;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.data.WideCharDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.StringUtilities;

public class WideChar32DataType
extends BuiltIn
implements ArrayStringable,
DataTypeWithCharset {
    private static final long serialVersionUID = 1L;
    public static final WideChar32DataType dataType = new WideChar32DataType();

    public WideChar32DataType() {
        this(null);
    }

    public WideChar32DataType(DataTypeManager dtm) {
        super(null, "wchar32", dtm);
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public boolean isDynamicallySized() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Wide-Character (32-bit/UTF32)";
    }

    @Override
    protected SettingsDefinition[] getBuiltInSettingsDefinitions() {
        return WideCharDataType.DEFAULT_WIDE_CHAR_SETTINGS;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new WideChar32DataType(dtm);
    }

    @Override
    public String getMnemonic(Settings settings) {
        return "wchar32";
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return new StringDataInstance(this, settings, buf, this.getLength()).getCharRepresentation();
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        try {
            return new Scalar(32, buf.getInt(0), true);
        }
        catch (MemoryAccessException memoryAccessException) {
            return null;
        }
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return Scalar.class;
    }

    @Override
    public String getDefaultLabelPrefix(MemBuffer buf, Settings settings, int length, DataTypeDisplayOptions options) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("WCHAR32_");
        try {
            int val = buf.getInt(0);
            if (StringUtilities.isAsciiChar((int)val)) {
                strBuf.append((char)val);
            } else {
                strBuf.append(Integer.toHexString(val));
                strBuf.append('h');
            }
        }
        catch (MemoryAccessException e) {
            strBuf.append("??");
        }
        return strBuf.toString();
    }

    @Override
    public String getDefaultLabelPrefix() {
        return "WCHAR32";
    }

    @Override
    public boolean hasStringValue(Settings settings) {
        return true;
    }

    @Override
    public String getArrayDefaultLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        return new StringDataInstance(this, settings, buf, len).getLabel("u_", "UNI", "UNICODE", options);
    }

    @Override
    public String getArrayDefaultOffcutLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options, int offcutOffset) {
        return new StringDataInstance(this, settings, buf, len).getOffcutLabelString("u_", "UNI", "UNICODE", options, offcutOffset);
    }

    @Override
    public String getCharsetName(Settings settings) {
        return "UTF-32";
    }
}

