/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionLocation;

public class FunctionCallFixupFieldLocation
extends FunctionLocation {
    private String callFixupName;

    public FunctionCallFixupFieldLocation(Program program, Address locationAddr, Address functionAddr, String callFixupName, int charOffset) {
        super(program, locationAddr, functionAddr, 0, 0, charOffset);
        this.callFixupName = callFixupName;
    }

    public FunctionCallFixupFieldLocation() {
    }

    public String getCallFixupName() {
        return this.callFixupName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.callFixupName == null ? 0 : this.callFixupName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionCallFixupFieldLocation other = (FunctionCallFixupFieldLocation)obj;
        return !(this.callFixupName == null ? other.callFixupName != null : !this.callFixupName.equals(other.callFixupName));
    }

    @Override
    public String toString() {
        return super.toString() + ", Function Call-Fixup: " + this.callFixupName;
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putString("_FUNCTION_CALLFIXUP_STRING", this.callFixupName);
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        this.callFixupName = obj.getString("_FUNCTION_CALLFIXUP_STRING", null);
    }
}

