/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.sparseimage;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.sparseimage.SparseImageDecompressor;
import ghidra.file.formats.sparseimage.SparseImageFileSystemFactory;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileCacheEntry;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@FileSystemInfo(type="simg", description="Android Sparse Image (simg)", factory=SparseImageFileSystemFactory.class)
public class SparseImageFileSystem
implements GFileSystem {
    private final FSRLRoot fsFSRL;
    private final FSRL containerFSRL;
    private final FileSystemRefManager refManager = new FileSystemRefManager((GFileSystem)this);
    private final FileSystemService fsService;
    private GFileImpl root;
    private GFileImpl payload;
    private long containerSize;

    public SparseImageFileSystem(FSRLRoot fsFSRL, FSRL containerFSRL, FileSystemService fsService, TaskMonitor monitor) throws CancelledException, IOException {
        this.fsFSRL = fsFSRL;
        this.fsService = fsService;
        this.root = GFileImpl.fromFilename((GFileSystem)this, null, null, (boolean)true, (long)-1L, (FSRL)fsFSRL.withPath("/"));
        this.containerFSRL = containerFSRL;
        File containerFile = fsService.getFile(containerFSRL, monitor);
        this.containerSize = containerFile.length();
        FileCacheEntry pli = this.getPayloadInfo(monitor);
        String payloadName = containerFSRL.getName() + ".raw";
        FSRL payloadFSRL = this.root.getFSRL().appendPath(payloadName).withMD5(pli.md5);
        this.payload = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)payloadName, (boolean)false, (long)pli.file.length(), (FSRL)payloadFSRL);
    }

    public void close() throws IOException {
        this.refManager.onClose();
        this.payload = null;
    }

    public boolean isClosed() {
        return this.payload == null;
    }

    public String getName() {
        return this.fsFSRL.getContainer().getName();
    }

    public FSRLRoot getFSRL() {
        return this.fsFSRL;
    }

    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }

    public GFileImpl lookup(String path) throws IOException {
        if (path == null || path.equals("/")) {
            return this.root;
        }
        if (path.equals(this.payload.getFSRL().getPath())) {
            return this.payload;
        }
        return null;
    }

    private FileCacheEntry getPayloadInfo(TaskMonitor monitor) throws CancelledException, IOException {
        return this.fsService.getDerivedFilePush(this.containerFSRL, "sparse", os -> {
            try (ByteProvider provider = this.fsService.getByteProvider(this.containerFSRL, monitor);){
                SparseImageDecompressor sid = new SparseImageDecompressor(provider, os);
                sid.decompress(monitor);
            }
        }, monitor);
    }

    public InputStream getInputStream(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        if (this.payload.equals((Object)file)) {
            FileCacheEntry pli = this.getPayloadInfo(monitor);
            return new FileInputStream(pli.file);
        }
        return null;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        if (directory == null || this.root.equals((Object)directory)) {
            return Arrays.asList(this.payload);
        }
        return Collections.emptyList();
    }

    public String getInfo(GFile file, TaskMonitor monitor) {
        if (this.payload.equals((Object)file)) {
            return FSUtilities.infoMapToString(this.getInfoMap());
        }
        return null;
    }

    public Map<String, String> getInfoMap() {
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        info.put("Name", this.payload.getName());
        info.put("Size", Long.toString(this.payload.getLength()));
        info.put("Compressed Size", Long.toString(this.containerSize));
        info.put("MD5", this.payload.getFSRL().getMD5());
        return info;
    }
}

