/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.tasks;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeTask;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.List;
import javax.swing.tree.TreePath;

public class GTreeExpandAllTask
extends GTreeTask {
    private final GTreeNode root;

    public GTreeExpandAllTask(GTree tree, GTreeNode node) {
        super(tree);
        this.root = node;
    }

    public void run(TaskMonitor monitor) {
        int max = 100;
        monitor.initialize((long)max);
        monitor.setMessage("Expanding nodes...");
        try {
            this.expandNode(this.root, monitor);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    protected void expandNode(GTreeNode node, TaskMonitor monitor) throws CancelledException {
        if (node.isLeaf()) {
            return;
        }
        monitor.checkCanceled();
        List<GTreeNode> allChildren = node.getChildren();
        if (allChildren.size() == 0) {
            return;
        }
        TreePath treePath = node.getTreePath();
        if (!this.jTree.isExpanded(treePath)) {
            this.expandPath(treePath, monitor);
        }
        for (GTreeNode child : allChildren) {
            monitor.checkCanceled();
            this.expandNode(child, monitor);
        }
        monitor.incrementProgress(1L);
    }

    private void expandPath(final TreePath treePath, final TaskMonitor monitor) {
        this.runOnSwingThread(new Runnable(){

            @Override
            public void run() {
                if (monitor.isCancelled()) {
                    return;
                }
                GTreeExpandAllTask.this.jTree.expandPath(treePath);
            }
        });
    }
}

