/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import db.buffers.DataBuffer;
import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.help.Help;
import docking.help.HelpService;
import docking.util.AnimationUtils;
import docking.util.image.ToolIconURL;
import docking.widgets.OptionDialog;
import generic.jar.ResourceFile;
import generic.util.WindowUtilities;
import ghidra.framework.Application;
import ghidra.framework.LoggingInitialization;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.main.FrontEndable;
import ghidra.framework.main.ProjectDataPanel;
import ghidra.framework.main.datatree.ChangedFilesDialog;
import ghidra.framework.main.datatree.CheckInTask;
import ghidra.framework.main.logviewer.event.FVEvent;
import ghidra.framework.main.logviewer.event.FVEventListener;
import ghidra.framework.main.logviewer.model.ChunkModel;
import ghidra.framework.main.logviewer.model.ChunkReader;
import ghidra.framework.main.logviewer.ui.FileViewer;
import ghidra.framework.main.logviewer.ui.FileWatcher;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectListener;
import ghidra.framework.model.ProjectManager;
import ghidra.framework.model.Tool;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginClassManager;
import ghidra.framework.plugintool.util.PluginDescription;
import ghidra.framework.plugintool.util.PluginException;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.preferences.Preferences;
import ghidra.framework.project.tool.GhidraTool;
import ghidra.framework.project.tool.GhidraToolTemplate;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.bean.GGlassPane;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskListener;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.GenericXMLOutputter;
import ghidra.util.xml.XmlUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class FrontEndTool
extends PluginTool
implements OptionsChangeListener {
    public static final String AUTOMATICALLY_SAVE_TOOLS = "Automatically Save Tools";
    private static final String USE_ALERT_ANIMATION_OPTION_NAME = "Use Notification Animation";
    private static final String ENABLE_COMPRESSED_DATABUFFER_OUTPUT = "Use DataBuffer Output Compression";
    private static final int MIN_HEIGHT = 600;
    private static final String GHIDRA_SHOW_WHATS_NEW = "GhidraShowWhatsNew";
    private static final String GHIDRA_MAIN_PANEL_DIVIDER_LOC = "GhidraMainPanelDividerLocation";
    private static final String FRONT_END_TOOL_XML_NAME = "FRONTEND";
    private static final String FRONT_END_FILE_NAME = "FrontEndTool.xml";
    private static final String CONFIGURE_GROUP = "Configure";
    private WeakSet<ProjectListener> listeners;
    private FrontEndPlugin plugin;
    private ComponentProvider compProvider;
    private LogComponentProvider logProvider;
    private WindowListener windowListener;
    private DockingAction configureToolAction;
    private PluginClassManager pluginClassManager;

    public FrontEndTool(ProjectManager pm) {
        super(null, pm, null, null, false, false, false);
        this.setToolName("Project Window");
        this.listeners = WeakDataStructureFactory.createCopyOnWriteWeakSet();
        this.addFrontEndPlugin();
        this.createActions();
        this.loadToolConfigurationFromDisk();
        this.ensureSize();
        this.windowListener = new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                FrontEndTool.this.setDividerLocation();
                FrontEndTool.this.getToolFrame().removeWindowListener(FrontEndTool.this.windowListener);
            }
        };
        JFrame toolFrame = this.getToolFrame();
        toolFrame.addWindowListener(this.windowListener);
        AppInfo.setFrontEndTool(this);
        AppInfo.setActiveProject(this.getProject());
    }

    private void ensureSize() {
        JFrame frame = this.getToolFrame();
        Dimension size = frame.getSize();
        if (size.height < 600) {
            size.height = 600;
            Point center = WindowUtilities.centerOnScreen((Dimension)size);
            frame.setBounds(center.x, center.y, size.width, size.height);
        }
    }

    @Override
    public PluginClassManager getPluginClassManager() {
        if (this.pluginClassManager == null) {
            this.pluginClassManager = new PluginClassManager(FrontEndable.class, null);
        }
        return this.pluginClassManager;
    }

    public void selectFiles(Set<DomainFile> files) {
        this.plugin.selectFiles(files);
    }

    private void loadToolConfigurationFromDisk() {
        File saveFile = new File(Application.getUserSettingsDirectory(), FRONT_END_FILE_NAME);
        if (!saveFile.exists()) {
            this.addFrontEndablePlugins();
            return;
        }
        try {
            FileInputStream is = new FileInputStream(saveFile);
            SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
            Element root = sax.build((InputStream)is).getRootElement();
            GhidraToolTemplate template = new GhidraToolTemplate((Element)root.getChildren().get(0), saveFile.getAbsolutePath());
            this.refresh(template);
        }
        catch (JDOMException e) {
            Msg.showError((Object)this, null, (String)"Error", (Object)"Error in XML reading front end configuration", (Throwable)e);
        }
        catch (IOException e) {
            Msg.showError((Object)this, null, (String)"Error", (Object)"Error reading front end configuration", (Throwable)e);
        }
    }

    void saveToolConfigurationToDisk() {
        ToolTemplate template = this.saveToolToToolTemplate();
        Element root = new Element(FRONT_END_TOOL_XML_NAME);
        root.addContent((Content)template.saveToXml());
        File saveFile = new File(Application.getUserSettingsDirectory(), FRONT_END_FILE_NAME);
        try {
            FileOutputStream os = new FileOutputStream(saveFile);
            Document doc = new Document(root);
            GenericXMLOutputter xmlOut = new GenericXMLOutputter();
            xmlOut.output(doc, (OutputStream)os);
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            Msg.showError((Object)this, null, (String)"Error", (Object)"Error saving front end configuration", (Throwable)e);
        }
    }

    private void addFrontEndPlugin() {
        this.plugin = new FrontEndPlugin(this);
        this.plugin.setProjectManager(this.getProjectManager());
        try {
            this.addPlugin(this.plugin);
        }
        catch (PluginException e) {
            Msg.showError((Object)this, (Component)this.getToolFrame(), (String)"Can't Create Project Window", (Object)e.getMessage(), (Throwable)((Object)e));
        }
        this.compProvider = this.plugin.getFrontEndProvider();
        this.showComponentHeader(this.compProvider, false);
    }

    private void initFrontEndOptions() {
        boolean autoSave;
        ToolOptions options = this.getOptions("Tool");
        HelpLocation help = new HelpLocation("Tool", "Save_Tool");
        options.registerOption(AUTOMATICALLY_SAVE_TOOLS, (Object)true, help, "When enabled tools will be saved when they are closed");
        options.registerOption(USE_ALERT_ANIMATION_OPTION_NAME, (Object)true, help, "Signals that user notifications should be animated.  This makes notifications more distinguishable.");
        options.registerOption(ENABLE_COMPRESSED_DATABUFFER_OUTPUT, (Object)Boolean.FALSE, help, "When enabled data buffers sent to Ghidra Server are compressed (see server configuration for other direction)");
        GhidraTool.autoSave = autoSave = options.getBoolean(AUTOMATICALLY_SAVE_TOOLS, true);
        boolean animationEnabled = options.getBoolean(USE_ALERT_ANIMATION_OPTION_NAME, true);
        AnimationUtils.setAnimationEnabled((boolean)animationEnabled);
        boolean compressDataBuffers = options.getBoolean(ENABLE_COMPRESSED_DATABUFFER_OUTPUT, false);
        DataBuffer.enableCompressedSerializationOutput((boolean)compressDataBuffers);
        options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (AUTOMATICALLY_SAVE_TOOLS.equals(optionName)) {
            GhidraTool.autoSave = (Boolean)newValue;
        } else if (USE_ALERT_ANIMATION_OPTION_NAME.equals(optionName)) {
            AnimationUtils.setAnimationEnabled((boolean)((Boolean)newValue));
        } else if (ENABLE_COMPRESSED_DATABUFFER_OUTPUT.equals(optionName)) {
            DataBuffer.enableCompressedSerializationOutput((boolean)((Boolean)newValue));
        }
    }

    @Override
    public void exit() {
        this.saveToolConfigurationToDisk();
        this.plugin.exitGhidra();
    }

    @Override
    public void close() {
        this.exit();
    }

    public void setActiveProject(Project project) {
        if (this.isDisposed) {
            return;
        }
        ToolOptions options = this.getOptions("Tool");
        options.removeOptionsChangeListener((OptionsChangeListener)this);
        this.configureToolAction.setEnabled(true);
        this.setProject(project);
        AppInfo.setActiveProject(project);
        this.plugin.setActiveProject(project);
        this.initFrontEndOptions();
    }

    public void addProjectListener(ProjectListener l) {
        this.listeners.add((Object)l);
    }

    public void removeProjectListener(ProjectListener l) {
        this.listeners.remove((Object)l);
    }

    boolean checkRepositoryConnected(PluginTool tool) {
        RepositoryAdapter repository = tool.getProject().getRepository();
        if (repository != null && !repository.verifyConnection()) {
            if (OptionDialog.showYesNoDialog((Component)tool.getToolFrame(), (String)"Lost Connection to Server", (String)"The connection to the Ghidra Server has been lost.\nDo you want to reconnect now?") == 1) {
                try {
                    repository.connect();
                    return true;
                }
                catch (NotConnectedException e) {
                    return false;
                }
                catch (IOException e) {
                    ClientUtil.handleException((RepositoryAdapter)repository, (Exception)e, (String)"Repository Connection", (Component)tool.getToolFrame());
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public void checkIn(PluginTool tool, DomainFile domainFile, TaskListener taskListener) {
        ArrayList<DomainFile> list = new ArrayList<DomainFile>();
        list.add(domainFile);
        this.checkIn(tool, list, taskListener, tool.getToolFrame());
    }

    public void checkIn(PluginTool tool, List<DomainFile> fileList, TaskListener taskListener, Component parent) {
        if (!this.checkRepositoryConnected(tool)) {
            return;
        }
        ArrayList<DomainFile> changedList = new ArrayList<DomainFile>();
        ArrayList<DomainFile> list = new ArrayList<DomainFile>();
        for (int i = 0; i < fileList.size(); ++i) {
            DomainFile df = fileList.get(i);
            if (df == null || !df.canCheckin() || !this.canCloseDomainFile(df)) continue;
            list.add(df);
            if (!df.isChanged()) continue;
            changedList.add(df);
        }
        if (changedList.size() > 0) {
            ChangedFilesDialog dialog = new ChangedFilesDialog(tool, changedList);
            dialog.setCancelToolTipText("Cancel Check In");
            if (!dialog.showDialog()) {
                Msg.info((Object)this, (Object)"Checkin canceled");
                return;
            }
            for (int i = 0; i < changedList.size(); ++i) {
                DomainFile df = changedList.get(i);
                if (!df.isChanged()) continue;
                list.remove(df);
            }
        }
        if (list.size() > 0) {
            tool.execute(new CheckInTask(tool, list, parent));
        } else {
            Msg.showError((Object)this, (Component)tool.getToolFrame(), (String)"Checkin Failed", (Object)"Unable to checkin file(s)");
        }
    }

    public void merge(PluginTool tool, DomainFile domainFile, TaskListener taskListener) {
        ArrayList<DomainFile> list = new ArrayList<DomainFile>();
        list.add(domainFile);
        this.merge(tool, list, taskListener);
    }

    public void merge(PluginTool tool, List<DomainFile> fileList, TaskListener taskListener) {
        if (!this.checkRepositoryConnected(tool)) {
            return;
        }
        ArrayList<DomainFile> list = new ArrayList<DomainFile>();
        ArrayList<DomainFile> changedList = new ArrayList<DomainFile>();
        for (int i = 0; i < fileList.size(); ++i) {
            DomainFile df = fileList.get(i);
            if (df == null || !df.canMerge() || !this.canCloseDomainFile(df)) continue;
            list.add(df);
            if (!df.isChanged()) continue;
            changedList.add(df);
        }
        if (changedList.size() > 0) {
            ChangedFilesDialog dialog = new ChangedFilesDialog(tool, changedList);
            dialog.setCancelToolTipText("Cancel Merge");
            if (!dialog.showDialog()) {
                Msg.info((Object)this, (Object)"Merge canceled");
                return;
            }
            for (int i = 0; i < changedList.size(); ++i) {
                DomainFile df = changedList.get(i);
                if (!df.isChanged()) continue;
                list.remove(df);
            }
        }
        if (list.size() > 0) {
            this.execute(new MergeTask(tool, list, taskListener));
        } else {
            Msg.showError((Object)this, (Component)tool.getToolFrame(), (String)"Update Failed", (Object)"Unable to update file(s)");
        }
    }

    public void setVisible(boolean visibility) {
        if (visibility) {
            super.setVisible(visibility);
            this.plugin.rebuildRecentMenus();
            this.checkWhatsNewPreference();
        } else {
            super.setVisible(visibility);
            AppInfo.setFrontEndTool(null);
            AppInfo.setActiveProject(null);
            this.dispose();
        }
    }

    public void setBusy(boolean busy) {
        JFrame rootFrame = this.winMgr.getRootFrame();
        Component glassPane = rootFrame.getGlassPane();
        if (!(glassPane instanceof GGlassPane)) {
            Msg.debug((Object)this, (Object)"Found root frame without a GhidraGlassPane registered!");
            return;
        }
        GGlassPane dockingGlassPane = (GGlassPane)glassPane;
        dockingGlassPane.setBusy(busy);
    }

    private void addManageExtensionsAction() {
        DockingAction installExtensionsAction = new DockingAction("Extensions", "Project Window"){

            public void actionPerformed(ActionContext context) {
                FrontEndTool.this.showExtensions();
                FrontEndTool.this.extensionTableProvider.setHelpLocation(new HelpLocation("FrontEndPlugin", "Extensions"));
            }

            public boolean isEnabledForContext(ActionContext context) {
                return FrontEndTool.this.isConfigurable();
            }
        };
        MenuData menuData = new MenuData(new String[]{"&File", "Install Extensions..."}, null, CONFIGURE_GROUP);
        menuData.setMenuSubGroup("Configure2");
        installExtensionsAction.setMenuBarData(menuData);
        installExtensionsAction.setHelpLocation(new HelpLocation("FrontEndPlugin", "Extensions"));
        installExtensionsAction.setEnabled(true);
        this.addAction((DockingActionIf)installExtensionsAction);
    }

    private void addManagePluginsAction() {
        this.configureToolAction = new DockingAction("Configure Tool", "Project Window"){

            public void actionPerformed(ActionContext context) {
                FrontEndTool.this.showConfig(false, false);
                FrontEndTool.this.manageDialog.setHelpLocation(new HelpLocation("FrontEndPlugin", FrontEndTool.CONFIGURE_GROUP));
            }

            public boolean isEnabledForContext(ActionContext context) {
                return FrontEndTool.this.isConfigurable();
            }
        };
        MenuData menuData = new MenuData(new String[]{"&File", "Configure..."}, null, CONFIGURE_GROUP);
        menuData.setMenuSubGroup("Configure1");
        this.configureToolAction.setMenuBarData(menuData);
        this.configureToolAction.setHelpLocation(new HelpLocation("FrontEndPlugin", CONFIGURE_GROUP));
        this.configureToolAction.setEnabled(true);
        this.addAction((DockingActionIf)this.configureToolAction);
    }

    @Override
    public ToolTemplate getToolTemplate(boolean includeConfigState) {
        FrontEndToolTemplate toolTemplate = new FrontEndToolTemplate(this.getIconURL(), this.saveToXml(includeConfigState), this.getSupportedDataTypes());
        return toolTemplate;
    }

    Iterable<ProjectListener> getListeners() {
        return this.listeners;
    }

    ComponentProvider getProvider() {
        return this.compProvider;
    }

    SaveState getSaveableDisplayData() {
        SaveState saveState = new SaveState();
        this.plugin.writeDataState(saveState);
        return saveState;
    }

    void setSaveableDisplayData(SaveState saveState) {
        this.plugin.readDataState(saveState);
    }

    private void addFrontEndablePlugins() {
        ArrayList<String> classNames = new ArrayList<String>();
        for (Class pluginClass : ClassSearcher.getClasses(Plugin.class, c -> FrontEndable.class.isAssignableFrom((Class<?>)c))) {
            boolean isBadCategory;
            PluginDescription pd = PluginDescription.getPluginDescription(pluginClass);
            String category = pd.getCategory();
            boolean bl = isBadCategory = category.equals("Examples") || category.equals("Testing");
            if (pd.getStatus() != PluginStatus.RELEASED || isBadCategory) continue;
            classNames.add(pluginClass.getName());
        }
        try {
            this.addPlugins(classNames.toArray(new String[classNames.size()]));
        }
        catch (PluginException e) {
            Msg.showError((Object)this, (Component)this.getToolFrame(), (String)"Plugin Error", (Object)"Error restoring front-end plugins", (Throwable)((Object)e));
        }
    }

    private void refresh(ToolTemplate tc) {
        this.listeners = WeakDataStructureFactory.createCopyOnWriteWeakSet();
        List<Plugin> list = this.getManagedPlugins();
        list.remove(this.plugin);
        Plugin[] plugins = new Plugin[list.size()];
        plugins = list.toArray(plugins);
        this.removePlugins(plugins);
        Element root = tc.saveToXml();
        Element elem = root.getChild("TOOL");
        this.restoreOptionsFromXml(elem);
        try {
            this.restorePluginsFromXml(elem);
        }
        catch (PluginException e) {
            Msg.showError((Object)this, (Component)this.getToolFrame(), (String)"Error Restoring Front-end Plugins", (Object)e.getMessage(), (Throwable)((Object)e));
        }
        this.winMgr.restoreFromXML(tc.getToolElement());
        this.setConfigChanged(false);
    }

    private void createActions() {
        this.addExitAction();
        this.addManagePluginsAction();
        this.addManageExtensionsAction();
        this.addOptionsAction();
        this.addHelpActions();
        DockingAction action = new DockingAction("Show Log", "Tool"){

            public void actionPerformed(ActionContext context) {
                FrontEndTool.this.showGhidraUserLogFile();
            }
        };
        action.setMenuBarData(new MenuData(new String[]{"&Help", "Show Log"}, null, "BBB"));
        action.setEnabled(true);
        this.addAction((DockingActionIf)action);
    }

    private void setDividerLocation() {
        String dividerLocStr = Preferences.getProperty((String)GHIDRA_MAIN_PANEL_DIVIDER_LOC);
        if (dividerLocStr != null) {
            int dividerLoc = this.parse(dividerLocStr, -1);
            ProjectDataPanel pdp = this.plugin.getProjectDataPanel();
            pdp.setDividerLocation(dividerLoc);
            pdp.invalidate();
            this.getToolFrame().validate();
        }
    }

    private int parse(String value, int defaultValue) {
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private void checkWhatsNewPreference() {
        if (SystemUtilities.isInDevelopmentMode() || SystemUtilities.isInTestingMode()) {
            return;
        }
        HelpService help = Help.getHelpService();
        String showWhatsNewStribng = Preferences.getProperty((String)GHIDRA_SHOW_WHATS_NEW, (String)"true");
        boolean showWhatsNew = Boolean.parseBoolean(showWhatsNewStribng);
        if (!showWhatsNew) {
            return;
        }
        Preferences.setProperty((String)GHIDRA_SHOW_WHATS_NEW, (String)"false");
        Preferences.store();
        ResourceFile installDir = Application.getInstallationDirectory();
        ResourceFile whatsNewFile = new ResourceFile(installDir, "docs/WhatsNew.html");
        try {
            URL url = whatsNewFile.toURL();
            help.showHelp(url);
        }
        catch (MalformedURLException e) {
            Msg.debug((Object)this, (Object)"Unable to show the What's New help page", (Throwable)e);
        }
    }

    @Override
    public boolean canCloseDomainFile(DomainFile df) {
        Tool[] tools;
        for (Tool tool : tools = this.getProject().getToolManager().getRunningTools()) {
            DomainFile[] files;
            for (DomainFile domainFile : files = tool.getDomainFiles()) {
                if (df != domainFile) continue;
                return tool.canCloseDomainFile(df);
            }
        }
        return true;
    }

    void showGhidraUserLogFile() {
        File logFile = LoggingInitialization.getApplicationLogFile();
        if (logFile == null) {
            return;
        }
        if (this.logProvider == null) {
            this.logProvider = new LogComponentProvider(this, logFile);
            this.showDialog((DialogComponentProvider)this.logProvider, this.getToolFrame());
            return;
        }
        if (this.logProvider.isShowing()) {
            this.logProvider.toFront();
        } else {
            this.showDialog((DialogComponentProvider)this.logProvider, this.getToolFrame());
        }
    }

    private static class FrontEndToolTemplate
    extends GhidraToolTemplate {
        FrontEndToolTemplate(ToolIconURL iconURL, Element element, Class<?>[] supportedDataTypes) {
            super(iconURL, element, supportedDataTypes);
        }
    }

    private class MergeTask
    extends Task {
        private List<DomainFile> list;
        private PluginTool tool;
        private TaskListener taskListener;
        private boolean wasCanceled;

        MergeTask(PluginTool tool, List<DomainFile> list, TaskListener taskListener) {
            super("Merge", true, true, true);
            this.tool = tool;
            this.list = list;
            this.taskListener = taskListener;
        }

        public void run(TaskMonitor monitor) {
            String currentName = null;
            try {
                for (int i = 0; i < this.list.size() && !monitor.isCancelled(); ++i) {
                    DomainFile df = this.list.get(i);
                    currentName = df.getName();
                    monitor.setMessage("Initiating Merging for " + currentName);
                    df.merge(true, monitor);
                }
            }
            catch (VersionException e) {
                Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Error During Merge Process", (Object)("Versioned file was created with newer version of Ghidra: " + currentName));
            }
            catch (CancelledException e) {
                this.wasCanceled = true;
                Msg.info((Object)((Object)this), (Object)"Merge Process was canceled");
            }
            catch (IOException e) {
                ClientUtil.handleException((RepositoryAdapter)FrontEndTool.this.getProject().getRepository(), (Exception)e, (String)"Merge Process", (Component)this.tool.getToolFrame());
            }
            this.notifyTaskListener();
        }

        private void notifyTaskListener() {
            SystemUtilities.runSwingNow(() -> {
                if (this.wasCanceled) {
                    this.taskListener.taskCancelled((Task)this);
                } else {
                    this.taskListener.taskCompleted((Task)this);
                }
            });
        }
    }

    private static class LogComponentProvider
    extends DialogComponentProvider {
        private final File logFile;
        private Dimension defaultSize = new Dimension(600, 400);
        private FileWatcher watcher;

        LogComponentProvider(PluginTool tool, File logFile) {
            super("Ghidra User Log", false, false, false, false);
            this.logFile = logFile;
            this.addWorkPanel(this.buildWorkPanel());
        }

        protected void dialogClosed() {
            if (this.watcher != null) {
                this.watcher.stop();
            }
        }

        protected void dialogShown() {
            if (this.watcher != null) {
                this.watcher.start();
            }
        }

        private JPanel buildWorkPanel() {
            JPanel panel = new JPanel(new BorderLayout()){

                @Override
                public Dimension getPreferredSize() {
                    return defaultSize;
                }
            };
            try {
                FVEventListener eventListener = new FVEventListener();
                ChunkModel model = new ChunkModel();
                ChunkReader reader = new ChunkReader(this.logFile, model);
                FileViewer viewer = new FileViewer(reader, model, eventListener);
                panel.add(viewer);
                panel.setVisible(true);
                this.watcher = new FileWatcher(this.logFile, eventListener);
                this.watcher.start();
                FVEvent loadEvt = new FVEvent(FVEvent.EventType.SCROLL_END, null);
                eventListener.send(loadEvt);
            }
            catch (IOException e) {
                Msg.error((Object)((Object)this), (Object)"Exception reading log file", (Throwable)e);
            }
            return panel;
        }
    }
}

