/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.xml.writer;

import com.jeta.forms.store.jml.dom.JMLNode;
import com.jeta.forms.store.jml.dom.TextJMLNode;
import com.jeta.forms.store.xml.XMLUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;

public class XMLWriter {
    private Writer m_writer;
    private static final int DEFAULT_INDENT = 1;
    private int m_indent_pos = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void write(Writer writer, JMLNode jMLNode) throws IOException {
        this.m_writer = writer;
        this.m_writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write(jMLNode);
    }

    private void write(JMLNode jMLNode) throws IOException {
        if (!$assertionsDisabled && jMLNode == null) {
            throw new AssertionError();
        }
        this.indent();
        if (jMLNode instanceof TextJMLNode) {
            TextJMLNode textJMLNode = (TextJMLNode)jMLNode;
            if (textJMLNode.getTextValue() != null) {
                this.m_writer.write(XMLUtils.escape(textJMLNode.getTextValue()));
            }
        } else {
            int n;
            this.m_writer.write(10);
            for (n = 0; n < this.m_indent_pos; ++n) {
                this.m_writer.write(32);
            }
            this.m_writer.write(60);
            this.m_writer.write(jMLNode.getNodeName());
            this.m_writer.write(32);
            this.writeAttributes(jMLNode);
            if (jMLNode.getChildCount() == 0) {
                this.m_writer.write(47);
                this.m_writer.write(">");
            } else {
                this.m_writer.write(">");
                for (n = 0; n < jMLNode.getChildCount(); ++n) {
                    JMLNode jMLNode2 = jMLNode.getNode(n);
                    this.write(jMLNode2);
                }
                if (jMLNode.getChildCount() > 0 && !(jMLNode.getNode(jMLNode.getChildCount() - 1) instanceof TextJMLNode)) {
                    this.m_writer.write(10);
                    for (n = 0; n < this.m_indent_pos; ++n) {
                        this.m_writer.write(32);
                    }
                }
                this.m_writer.write("</");
                this.m_writer.write(jMLNode.getNodeName());
                this.m_writer.write(62);
            }
        }
        this.unindent();
    }

    private void writeAttributes(JMLNode jMLNode) throws IOException {
        Collection collection = jMLNode.getAttributeNames();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = jMLNode.getAttribute(string);
            this.m_writer.write(string);
            this.m_writer.write("=\"");
            this.m_writer.write(XMLUtils.escape(string2));
            this.m_writer.write("\"");
            if (!iterator.hasNext()) continue;
            this.m_writer.write(32);
        }
    }

    private void indent() {
        ++this.m_indent_pos;
    }

    private void unindent() {
        --this.m_indent_pos;
    }

    static {
        $assertionsDisabled = !XMLWriter.class.desiredAssertionStatus();
    }
}

