/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.codeInsight.folding.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import org.jetbrains.kotlin.com.intellij.codeInsight.folding.impl.JavaFoldingBuilderBase;
import org.jetbrains.kotlin.com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import org.jetbrains.kotlin.com.intellij.lang.folding.FoldingDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.editor.FoldingGroup;
import org.jetbrains.kotlin.com.intellij.openapi.project.IndexNotReadyException;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaToken;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;

class ClosureFolding {
    @NotNull
    private final PsiAnonymousClass myAnonymousClass;
    @NotNull
    private final PsiNewExpression myNewExpression;
    @Nullable
    private final PsiClass myBaseClass;
    @NotNull
    private final JavaFoldingBuilderBase myBuilder;
    @NotNull
    private final PsiMethod myMethod;
    @NotNull
    final PsiCodeBlock methodBody;
    private final boolean myQuick;

    private ClosureFolding(@NotNull PsiAnonymousClass anonymousClass2, @NotNull PsiNewExpression newExpression, boolean quick, @Nullable PsiClass baseClass, @NotNull JavaFoldingBuilderBase builder, @NotNull PsiMethod method, @NotNull PsiCodeBlock methodBody) {
        if (anonymousClass2 == null) {
            ClosureFolding.$$$reportNull$$$0(0);
        }
        if (newExpression == null) {
            ClosureFolding.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            ClosureFolding.$$$reportNull$$$0(2);
        }
        if (method == null) {
            ClosureFolding.$$$reportNull$$$0(3);
        }
        if (methodBody == null) {
            ClosureFolding.$$$reportNull$$$0(4);
        }
        this.myAnonymousClass = anonymousClass2;
        this.myNewExpression = newExpression;
        this.myQuick = quick;
        this.myBaseClass = baseClass;
        this.myBuilder = builder;
        this.myMethod = method;
        this.methodBody = methodBody;
    }

    @Nullable
    List<FoldingDescriptor> process(@NotNull Document document) {
        int rangeEnd;
        if (document == null) {
            ClosureFolding.$$$reportNull$$$0(5);
        }
        PsiJavaToken lbrace = this.methodBody.getLBrace();
        PsiJavaToken rbrace = this.methodBody.getRBrace();
        PsiElement classRBrace = this.myAnonymousClass.getRBrace();
        if (lbrace == null || rbrace == null || classRBrace == null) {
            return null;
        }
        CharSequence seq = document.getCharsSequence();
        int rangeStart = lbrace.getTextRange().getEndOffset();
        String contents = ClosureFolding.getClosureContents(rangeStart, rangeEnd = ClosureFolding.getContentRangeEnd(document, rbrace, classRBrace), seq);
        if (contents == null) {
            return null;
        }
        String header = this.getFoldingHeader();
        if (this.showSingleLineFolding(document, contents, header)) {
            return this.createDescriptors(classRBrace, ClosureFolding.trimStartSpaces(seq, rangeStart), ClosureFolding.trimTailSpaces(seq, rangeEnd), header + " ", " }");
        }
        return this.createDescriptors(classRBrace, rangeStart, rangeEnd, header, "}");
    }

    private static int trimStartSpaces(@NotNull CharSequence seq, int rangeStart) {
        if (seq == null) {
            ClosureFolding.$$$reportNull$$$0(6);
        }
        return CharArrayUtil.shiftForward(seq, rangeStart, " \n\t");
    }

    private static int trimTailSpaces(@NotNull CharSequence seq, int rangeEnd) {
        if (seq == null) {
            ClosureFolding.$$$reportNull$$$0(7);
        }
        return CharArrayUtil.shiftBackward(seq, rangeEnd - 1, " \n\t") + 1;
    }

    private static int getContentRangeEnd(@NotNull Document document, @NotNull PsiJavaToken rbrace, @NotNull PsiElement classRBrace) {
        int rangeEnd;
        int methodEndLine;
        int methodEndLineStart;
        CharSequence seq;
        if (document == null) {
            ClosureFolding.$$$reportNull$$$0(8);
        }
        if (rbrace == null) {
            ClosureFolding.$$$reportNull$$$0(9);
        }
        if (classRBrace == null) {
            ClosureFolding.$$$reportNull$$$0(10);
        }
        if ("}".equals((seq = document.getCharsSequence()).subSequence(methodEndLineStart = document.getLineStartOffset(methodEndLine = document.getLineNumber(rangeEnd = rbrace.getTextRange().getStartOffset())), document.getLineEndOffset(methodEndLine)).toString().trim())) {
            int classEndStart = classRBrace.getTextRange().getStartOffset();
            int classEndCol = classEndStart - document.getLineStartOffset(document.getLineNumber(classEndStart));
            return classEndCol + methodEndLineStart;
        }
        return rangeEnd;
    }

    private boolean showSingleLineFolding(@NotNull Document document, @NotNull String contents, @NotNull String header) {
        if (document == null) {
            ClosureFolding.$$$reportNull$$$0(11);
        }
        if (contents == null) {
            ClosureFolding.$$$reportNull$$$0(12);
        }
        if (header == null) {
            ClosureFolding.$$$reportNull$$$0(13);
        }
        return contents.indexOf(10) < 0 && this.myBuilder.fitsRightMargin(this.myAnonymousClass, document, this.getClosureStartOffset(), this.getClosureEndOffset(), header.length() + contents.length() + 5);
    }

    private int getClosureEndOffset() {
        return this.myNewExpression.getTextRange().getEndOffset();
    }

    private int getClosureStartOffset() {
        return this.myNewExpression.getTextRange().getStartOffset();
    }

    @Nullable
    private List<FoldingDescriptor> createDescriptors(@NotNull PsiElement classRBrace, int rangeStart, int rangeEnd, @NotNull String header, @NotNull String footer) {
        if (classRBrace == null) {
            ClosureFolding.$$$reportNull$$$0(14);
        }
        if (header == null) {
            ClosureFolding.$$$reportNull$$$0(15);
        }
        if (footer == null) {
            ClosureFolding.$$$reportNull$$$0(16);
        }
        if (rangeStart >= rangeEnd) {
            return null;
        }
        FoldingGroup group = FoldingGroup.newGroup("lambda");
        ArrayList<FoldingDescriptor> foldElements = new ArrayList<FoldingDescriptor>();
        foldElements.add(new FoldingDescriptor(this.myNewExpression.getNode(), new TextRange(this.getClosureStartOffset(), rangeStart), group, header, JavaCodeFoldingSettings.getInstance().isCollapseLambdas(), Collections.emptySet()));
        if (rangeEnd + 1 < this.getClosureEndOffset()) {
            foldElements.add(new FoldingDescriptor(classRBrace.getNode(), new TextRange(rangeEnd, this.getClosureEndOffset()), group, footer, JavaCodeFoldingSettings.getInstance().isCollapseLambdas(), Collections.emptySet()));
        }
        return foldElements;
    }

    @Nullable
    private static String getClosureContents(int rangeStart, int rangeEnd, @NotNull CharSequence seq) {
        int lastLineEnd;
        int firstLineStart;
        if (seq == null) {
            ClosureFolding.$$$reportNull$$$0(17);
        }
        if ((firstLineStart = CharArrayUtil.shiftForward(seq, rangeStart, " \t")) < seq.length() - 1 && seq.charAt(firstLineStart) == '\n') {
            ++firstLineStart;
        }
        if ((lastLineEnd = CharArrayUtil.shiftBackward(seq, rangeEnd - 1, " \t")) > 0 && seq.charAt(lastLineEnd) == '\n') {
            --lastLineEnd;
        }
        if (lastLineEnd < firstLineStart) {
            return null;
        }
        return seq.subSequence(firstLineStart, lastLineEnd).toString();
    }

    @NotNull
    private String getFoldingHeader() {
        String methodName = this.shouldShowMethodName() ? this.myMethod.getName() : "";
        String type2 = this.myQuick ? "" : this.getOptionalLambdaType();
        String params = StringUtil.join(this.myMethod.getParameterList().getParameters(), psiParameter -> psiParameter.getName(), ", ");
        String string2 = type2 + methodName + "(" + params + ") " + this.myBuilder.rightArrow() + " {";
        if (string2 == null) {
            ClosureFolding.$$$reportNull$$$0(18);
        }
        return string2;
    }

    @Nullable
    static ClosureFolding prepare(@NotNull PsiAnonymousClass anonymousClass2, boolean quick, @NotNull JavaFoldingBuilderBase builder) {
        PsiElement parent2;
        if (anonymousClass2 == null) {
            ClosureFolding.$$$reportNull$$$0(19);
        }
        if (builder == null) {
            ClosureFolding.$$$reportNull$$$0(20);
        }
        if ((parent2 = anonymousClass2.getParent()) instanceof PsiNewExpression && ClosureFolding.hasNoArguments((PsiNewExpression)parent2)) {
            PsiMethod method;
            PsiCodeBlock body2;
            PsiClass baseClass = quick ? null : anonymousClass2.getBaseClassType().resolve();
            if (ClosureFolding.hasOnlyOneLambdaMethod(anonymousClass2, !quick) && (quick || ClosureFolding.seemsLikeLambda(baseClass, anonymousClass2)) && (body2 = (method = anonymousClass2.getMethods()[0]).getBody()) != null) {
                return new ClosureFolding(anonymousClass2, (PsiNewExpression)parent2, quick, baseClass, builder, method, body2);
            }
        }
        return null;
    }

    private static boolean hasNoArguments(@NotNull PsiNewExpression expression2) {
        PsiExpressionList argumentList2;
        if (expression2 == null) {
            ClosureFolding.$$$reportNull$$$0(21);
        }
        return (argumentList2 = expression2.getArgumentList()) != null && argumentList2.isEmpty();
    }

    private static boolean hasOnlyOneLambdaMethod(@NotNull PsiAnonymousClass anonymousClass2, boolean checkResolve) {
        PsiField[] fields2;
        if (anonymousClass2 == null) {
            ClosureFolding.$$$reportNull$$$0(22);
        }
        if (!((fields2 = anonymousClass2.getFields()).length == 0 || fields2.length == 1 && "serialVersionUID".equals(fields2[0].getName()) && fields2[0].hasModifierProperty("static"))) {
            return false;
        }
        if (anonymousClass2.getInitializers().length != 0 || anonymousClass2.getInnerClasses().length != 0 || anonymousClass2.getMethods().length != 1) {
            return false;
        }
        PsiMethod method = anonymousClass2.getMethods()[0];
        if (method.hasModifierProperty("synchronized")) {
            return false;
        }
        if (checkResolve) {
            for (PsiClassType type2 : method.getThrowsList().getReferencedTypes()) {
                if (type2.resolve() != null) continue;
                return false;
            }
        }
        return true;
    }

    static boolean seemsLikeLambda(@Nullable PsiClass baseClass, @NotNull PsiElement context2) {
        if (context2 == null) {
            ClosureFolding.$$$reportNull$$$0(23);
        }
        if (baseClass == null || !PsiUtil.hasDefaultConstructor(baseClass, true)) {
            return false;
        }
        return !PsiUtil.isLanguageLevel8OrHigher(context2) || !LambdaUtil.isFunctionalClass(baseClass);
    }

    @NotNull
    private String getOptionalLambdaType() {
        String baseClassName;
        if (this.myBuilder.shouldShowExplicitLambdaType(this.myAnonymousClass, this.myNewExpression) && (baseClassName = ObjectUtils.assertNotNull(this.myAnonymousClass.getBaseClassType().resolve()).getName()) != null) {
            String string2 = "(" + baseClassName + ") ";
            if (string2 == null) {
                ClosureFolding.$$$reportNull$$$0(24);
            }
            return string2;
        }
        return "";
    }

    private boolean shouldShowMethodName() {
        if (this.myBaseClass == null || !this.myBaseClass.hasModifierProperty("abstract")) {
            return true;
        }
        for (PsiMethod method : this.myBaseClass.getMethods()) {
            if (!method.hasModifierProperty("abstract")) continue;
            return false;
        }
        try {
            return OverrideImplementExploreUtil.getMethodSignaturesToImplement(this.myBaseClass).isEmpty();
        }
        catch (IndexNotReadyException e) {
            return true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 24: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anonymousClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 2: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodBody";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: 
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seq";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rbrace";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classRBrace";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "footer";
                break;
            }
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/codeInsight/folding/impl/ClosureFolding";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/codeInsight/folding/impl/ClosureFolding";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingHeader";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionalLambdaType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "trimStartSpaces";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "trimTailSpaces";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getContentRangeEnd";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showSingleLineFolding";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptors";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getClosureContents";
                break;
            }
            case 18: 
            case 24: {
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "hasNoArguments";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "hasOnlyOneLambdaMethod";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "seemsLikeLambda";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 18: 
            case 24: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

