/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree.fir;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirWhenSubject;
import org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.diagnostics.FirSimpleDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.impl.FirErrorExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirOperatorCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirTypeOperatorCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirWhenSubjectExpressionImpl;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\bH\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0004J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\u0014\u0010\u0017\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/fir/WhenEntry;", "", "conditions", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "firBlock", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "isElse", "", "(Ljava/util/List;Lorg/jetbrains/kotlin/fir/expressions/FirBlock;Z)V", "getConditions", "()Ljava/util/List;", "getFirBlock", "()Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toFirWhenCondition", "subject", "Lorg/jetbrains/kotlin/fir/FirWhenSubject;", "toFirWhenConditionWithoutSubject", "toString", "", "lightTree"})
public final class WhenEntry {
    @NotNull
    private final List<FirExpression> conditions;
    @NotNull
    private final FirBlock firBlock;
    private final boolean isElse;

    @NotNull
    public final FirExpression toFirWhenCondition(@NotNull FirWhenSubject subject) {
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        FirExpression firCondition = null;
        for (FirExpression condition : this.conditions) {
            FirExpression firConditionElement = this.toFirWhenCondition(condition, subject);
            FirExpression firExpression2 = firCondition;
            firCondition = firExpression2 == null ? firConditionElement : (FirExpression)ConversionUtilsKt.generateLazyLogicalOperation(firCondition, firConditionElement, false, null);
        }
        FirExpression firExpression3 = firCondition;
        if (firExpression3 == null) {
            Intrinsics.throwNpe();
        }
        return firExpression3;
    }

    private final FirExpression toFirWhenCondition(@NotNull FirExpression $this$toFirWhenCondition, FirWhenSubject subject) {
        FirElement firElement;
        FirWhenSubjectExpressionImpl firSubjectExpression = new FirWhenSubjectExpressionImpl(null, subject);
        FirExpression firExpression2 = $this$toFirWhenCondition;
        if (firExpression2 instanceof FirOperatorCallImpl) {
            FirExpression firExpression3 = $this$toFirWhenCondition;
            boolean bl = false;
            boolean bl2 = false;
            FirOperatorCallImpl $this$apply = (FirOperatorCallImpl)firExpression3;
            boolean bl3 = false;
            $this$apply.getArguments().add(0, firSubjectExpression);
            firElement = firExpression3;
        } else if (firExpression2 instanceof FirFunctionCall) {
            FirExpression firExpression4 = ((FirFunctionCall)$this$toFirWhenCondition).getExplicitReceiver();
            if (firExpression4 == null) {
                Intrinsics.throwNpe();
            }
            FirExpression firExpression5 = firExpression4;
            boolean isNegate = Intrinsics.areEqual((Object)((FirFunctionCall)$this$toFirWhenCondition).getCalleeReference().getName(), (Object)OperatorNameConventions.NOT);
            firElement = ConversionUtilsKt.generateContainsOperation(firExpression5, firSubjectExpression, isNegate, null, null);
        } else if (firExpression2 instanceof FirTypeOperatorCallImpl) {
            FirExpression firExpression6 = $this$toFirWhenCondition;
            boolean bl = false;
            boolean bl4 = false;
            FirTypeOperatorCallImpl $this$apply = (FirTypeOperatorCallImpl)firExpression6;
            boolean bl5 = false;
            Collection collection = $this$apply.getArguments();
            FirWhenSubjectExpressionImpl firWhenSubjectExpressionImpl = firSubjectExpression;
            boolean bl6 = false;
            collection.add(firWhenSubjectExpressionImpl);
            firElement = firExpression6;
        } else {
            firElement = new FirErrorExpressionImpl(null, new FirSimpleDiagnostic("Unsupported when condition: " + $this$toFirWhenCondition.getClass(), DiagnosticKind.Syntax));
        }
        return (FirExpression)firElement;
    }

    @NotNull
    public final FirExpression toFirWhenConditionWithoutSubject() {
        FirExpression condition = (FirExpression)CollectionsKt.first(this.conditions);
        return condition instanceof FirOperatorCallImpl ? (FirExpression)CollectionsKt.first(((FirOperatorCallImpl)condition).getArguments()) : (FirExpression)new FirErrorExpressionImpl(null, new FirSimpleDiagnostic("No expression in condition with expression", DiagnosticKind.Syntax));
    }

    @NotNull
    public final List<FirExpression> getConditions() {
        return this.conditions;
    }

    @NotNull
    public final FirBlock getFirBlock() {
        return this.firBlock;
    }

    public final boolean isElse() {
        return this.isElse;
    }

    public WhenEntry(@NotNull List<? extends FirExpression> conditions2, @NotNull FirBlock firBlock, boolean isElse) {
        Intrinsics.checkParameterIsNotNull(conditions2, (String)"conditions");
        Intrinsics.checkParameterIsNotNull((Object)firBlock, (String)"firBlock");
        this.conditions = conditions2;
        this.firBlock = firBlock;
        this.isElse = isElse;
    }

    public /* synthetic */ WhenEntry(List list2, FirBlock firBlock, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(list2, firBlock, bl);
    }

    @NotNull
    public final List<FirExpression> component1() {
        return this.conditions;
    }

    @NotNull
    public final FirBlock component2() {
        return this.firBlock;
    }

    public final boolean component3() {
        return this.isElse;
    }

    @NotNull
    public final WhenEntry copy(@NotNull List<? extends FirExpression> conditions2, @NotNull FirBlock firBlock, boolean isElse) {
        Intrinsics.checkParameterIsNotNull(conditions2, (String)"conditions");
        Intrinsics.checkParameterIsNotNull((Object)firBlock, (String)"firBlock");
        return new WhenEntry(conditions2, firBlock, isElse);
    }

    public static /* synthetic */ WhenEntry copy$default(WhenEntry whenEntry, List list2, FirBlock firBlock, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            list2 = whenEntry.conditions;
        }
        if ((n & 2) != 0) {
            firBlock = whenEntry.firBlock;
        }
        if ((n & 4) != 0) {
            bl = whenEntry.isElse;
        }
        return whenEntry.copy(list2, firBlock, bl);
    }

    @NotNull
    public String toString() {
        return "WhenEntry(conditions=" + this.conditions + ", firBlock=" + this.firBlock + ", isElse=" + this.isElse + ")";
    }

    public int hashCode() {
        List<FirExpression> list2 = this.conditions;
        FirBlock firBlock = this.firBlock;
        int n = ((list2 != null ? ((Object)list2).hashCode() : 0) * 31 + (firBlock != null ? firBlock.hashCode() : 0)) * 31;
        int n2 = this.isElse ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        return n + n2;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof WhenEntry)) break block3;
                WhenEntry whenEntry = (WhenEntry)object;
                if (!Intrinsics.areEqual(this.conditions, whenEntry.conditions) || !Intrinsics.areEqual((Object)this.firBlock, (Object)whenEntry.firBlock) || this.isElse != whenEntry.isElse) break block3;
            }
            return true;
        }
        return false;
    }
}

