/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.jicofo.ConferenceStore;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.jigasi.JigasiDetector;
import org.jitsi.jicofo.metrics.JicofoMetricsContainer;
import org.jitsi.jicofo.xmpp.AbstractIqHandler;
import org.jitsi.jicofo.xmpp.IqProcessingResult;
import org.jitsi.jicofo.xmpp.IqRequest;
import org.jitsi.jicofo.xmpp.UtilKt;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.metrics.MetricsContainer;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.xmpp.extensions.rayo.DialIq;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.id.StandardStanzaIdSource;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002#$B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0016J>\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00042\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Lorg/jitsi/jicofo/xmpp/JigasiIqHandler;", "Lorg/jitsi/jicofo/xmpp/AbstractIqHandler;", "Lorg/jitsi/xmpp/extensions/rayo/DialIq;", "connections", "", "Lorg/jivesoftware/smack/AbstractXMPPConnection;", "conferenceStore", "Lorg/jitsi/jicofo/ConferenceStore;", "jigasiDetector", "Lorg/jitsi/jicofo/jigasi/JigasiDetector;", "(Ljava/util/Set;Lorg/jitsi/jicofo/ConferenceStore;Lorg/jitsi/jicofo/jigasi/JigasiDetector;)V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "stanzaIdSource", "Lorg/jivesoftware/smack/packet/id/StandardStanzaIdSource;", "kotlin.jvm.PlatformType", "stats", "Lorg/jitsi/jicofo/xmpp/JigasiIqHandler$Stats;", "statsJson", "Lorg/jitsi/utils/OrderedJsonObject;", "getStatsJson", "()Lorg/jitsi/utils/OrderedJsonObject;", "handleRequest", "Lorg/jitsi/jicofo/xmpp/IqProcessingResult;", "request", "Lorg/jitsi/jicofo/xmpp/IqRequest;", "inviteJigasi", "", "conferenceRegions", "", "retryCount", "", "exclude", "", "Lorg/jxmpp/jid/Jid;", "Companion", "Stats", "jicofo"})
public final class JigasiIqHandler
extends AbstractIqHandler<DialIq> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConferenceStore conferenceStore;
    @NotNull
    private final JigasiDetector jigasiDetector;
    @NotNull
    private final Logger logger;
    private final StandardStanzaIdSource stanzaIdSource;
    @NotNull
    private final Stats stats;
    @NotNull
    private static final StandardStanzaIdSource.Factory stanzaIdSourceFactory = new StandardStanzaIdSource.Factory();

    public JigasiIqHandler(@NotNull Set<? extends AbstractXMPPConnection> connections, @NotNull ConferenceStore conferenceStore, @NotNull JigasiDetector jigasiDetector) {
        Intrinsics.checkNotNullParameter(connections, "connections");
        Intrinsics.checkNotNullParameter(conferenceStore, "conferenceStore");
        Intrinsics.checkNotNullParameter(jigasiDetector, "jigasiDetector");
        super(connections, "dial", "urn:xmpp:rayo:1", SetsKt.setOf(IQ.Type.set), null, 16, null);
        this.conferenceStore = conferenceStore;
        this.jigasiDetector = jigasiDetector;
        this.logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
        this.stanzaIdSource = stanzaIdSourceFactory.constructStanzaIdSource();
        this.stats = new Stats();
    }

    @NotNull
    public final OrderedJsonObject getStatsJson() {
        return this.stats.toJson();
    }

    @Override
    @NotNull
    public IqProcessingResult handleRequest(@NotNull IqRequest<DialIq> request) {
        Intrinsics.checkNotNullParameter(request, "request");
        EntityBareJid entityBareJid = request.getIq().getFrom().asEntityBareJidIfPossible();
        if (entityBareJid == null) {
            IqProcessingResult.RejectedWithError rejectedWithError;
            IqProcessingResult.RejectedWithError it = rejectedWithError = new IqProcessingResult.RejectedWithError(request, StanzaError.Condition.bad_request);
            boolean bl = false;
            this.logger.warn("Rejected request with invalid conferenceJid: " + request.getIq().getFrom());
            Stats.Companion.getRejectedRequests().inc();
            return rejectedWithError;
        }
        EntityBareJid conferenceJid = entityBareJid;
        JitsiMeetConference jitsiMeetConference = this.conferenceStore.getConference(conferenceJid);
        if (jitsiMeetConference == null) {
            IqProcessingResult.RejectedWithError it;
            IqProcessingResult.RejectedWithError it2 = it = new IqProcessingResult.RejectedWithError(request, StanzaError.Condition.item_not_found);
            boolean bl = false;
            this.logger.warn("Rejected request for non-existent conference: " + conferenceJid);
            Stats.Companion.getRejectedRequests().inc();
            return it;
        }
        JitsiMeetConference conference = jitsiMeetConference;
        if (!conference.acceptJigasiRequest(request.getIq().getFrom())) {
            IqProcessingResult.RejectedWithError rejectedWithError;
            IqProcessingResult.RejectedWithError it = rejectedWithError = new IqProcessingResult.RejectedWithError(request, StanzaError.Condition.forbidden);
            boolean bl = false;
            this.logger.warn("Rejected request from unauthorized user: " + request.getIq().getFrom());
            Stats.Companion.getRejectedRequests().inc();
            return rejectedWithError;
        }
        this.logger.info("Accepted jigasi request from " + request.getIq().getFrom() + ": " + request.getIq().toXML());
        Stats.Companion.getAcceptedRequests().inc();
        TaskPools.Companion.getIoPool().execute(() -> JigasiIqHandler.handleRequest$lambda-3(this, request, conference));
        return new IqProcessingResult.AcceptedWithNoResponse();
    }

    /*
     * WARNING - void declaration
     */
    private final void inviteJigasi(IqRequest<DialIq> request, Set<String> conferenceRegions, int retryCount, List<? extends Jid> exclude) {
        IQ responseFromJigasi;
        IQ iQ;
        DialIq dialIq;
        Jid jid = this.jigasiDetector.selectSipJigasi(exclude, (Collection<String>)conferenceRegions);
        if (jid == null) {
            JigasiIqHandler $this$inviteJigasi_u24lambda_u2d4 = this;
            boolean bl = false;
            $this$inviteJigasi_u24lambda_u2d4.logger.warn("Request failed, no instances available: " + request.getIq().toXML());
            XMPPConnection xMPPConnection = request.getConnection();
            ErrorIQ errorIQ = IQ.createErrorResponse((IQ)request.getIq(), StanzaError.getBuilder(StanzaError.Condition.service_unavailable).build());
            Intrinsics.checkNotNullExpressionValue(errorIQ, "createErrorResponse(\n   \u2026build()\n                )");
            UtilKt.tryToSendStanza(xMPPConnection, errorIQ);
            $this$inviteJigasi_u24lambda_u2d4.stats.noInstanceAvailable();
            return;
        }
        Jid jigasiJid = jid;
        this.logger.info("Selected " + jigasiJid + " (request from " + request.getIq().getFrom() + ")");
        DialIq $this$inviteJigasi_u24lambda_u2d5 = dialIq = new DialIq(request.getIq());
        boolean bl = false;
        $this$inviteJigasi_u24lambda_u2d5.setFrom(null);
        $this$inviteJigasi_u24lambda_u2d5.setTo(jigasiJid);
        $this$inviteJigasi_u24lambda_u2d5.setStanzaId(this.stanzaIdSource.getNewStanzaId());
        DialIq requestToJigasi = dialIq;
        try {
            iQ = UtilKt.sendIqAndGetResponse(this.jigasiDetector.getXmppConnection(), requestToJigasi);
        }
        catch (SmackException.NotConnectedException e) {
            this.logger.error("Request failed,  XMPP not connected: " + request.getIq().toXML());
            this.stats.xmppNotConnected();
            return;
        }
        IQ iQ2 = responseFromJigasi = iQ;
        if (iQ2 == null ? true : iQ2 instanceof ErrorIQ) {
            if (responseFromJigasi == null) {
                this.logger.warn("Jigasi instance timed out: " + jigasiJid);
                Stats.Companion.getSingleInstanceTimeouts().inc();
            } else {
                this.logger.warn("Jigasi instance returned error (" + jigasiJid + "): " + responseFromJigasi.toXML());
                Stats.Companion.getSingleInstanceErrors().inc();
            }
            if (retryCount > 0) {
                this.logger.info("Will retry up to " + retryCount + " more times.");
                Stats.Companion.getRetries().inc();
                this.inviteJigasi(request, conferenceRegions, retryCount - 1, CollectionsKt.plus((Collection)exclude, jigasiJid));
            } else {
                StanzaError.Condition condition = responseFromJigasi == null ? StanzaError.Condition.remote_server_timeout : StanzaError.Condition.undefined_condition;
                this.logger.warn("Request failed, all instances failed.");
                this.stats.allInstancesFailed();
                XMPPConnection xMPPConnection = request.getConnection();
                ErrorIQ errorIQ = IQ.createErrorResponse((IQ)request.getIq(), StanzaError.getBuilder(condition).build());
                Intrinsics.checkNotNullExpressionValue(errorIQ, "createErrorResponse(requ\u2026ilder(condition).build())");
                UtilKt.tryToSendStanza(xMPPConnection, errorIQ);
            }
        } else {
            void $this$inviteJigasi_u24lambda_u2d6;
            IQ iQ3;
            IQ iQ4 = iQ3 = responseFromJigasi;
            XMPPConnection xMPPConnection = request.getConnection();
            boolean bl2 = false;
            $this$inviteJigasi_u24lambda_u2d6.setFrom(null);
            $this$inviteJigasi_u24lambda_u2d6.setTo(request.getIq().getFrom());
            $this$inviteJigasi_u24lambda_u2d6.setStanzaId(request.getIq().getStanzaId());
            UtilKt.tryToSendStanza(xMPPConnection, iQ3);
            return;
        }
    }

    static /* synthetic */ void inviteJigasi$default(JigasiIqHandler jigasiIqHandler, IqRequest iqRequest, Set set, int n, List list, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 2;
        }
        if ((n2 & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        jigasiIqHandler.inviteJigasi(iqRequest, set, n, list);
    }

    private static final void handleRequest$lambda-3(JigasiIqHandler this$0, IqRequest $request, JitsiMeetConference $conference) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($request, "$request");
        Intrinsics.checkNotNullParameter($conference, "$conference");
        try {
            Set<String> set = $conference.getBridgeRegions();
            Intrinsics.checkNotNullExpressionValue(set, "conference.bridgeRegions");
            JigasiIqHandler.inviteJigasi$default(this$0, $request, set, 0, null, 12, null);
        }
        catch (Exception e) {
            this$0.logger.warn("Failed to invite jigasi", e);
            XMPPConnection xMPPConnection = $request.getConnection();
            ErrorIQ errorIQ = IQ.createErrorResponse($request.getIq(), StanzaError.Condition.internal_server_error);
            Intrinsics.checkNotNullExpressionValue(errorIQ, "createErrorResponse(requ\u2026on.internal_server_error)");
            UtilKt.tryToSendStanza(xMPPConnection, errorIQ);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jitsi/jicofo/xmpp/JigasiIqHandler$Companion;", "", "()V", "stanzaIdSourceFactory", "Lorg/jivesoftware/smack/packet/id/StandardStanzaIdSource$Factory;", "jicofo"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jitsi/jicofo/xmpp/JigasiIqHandler$Stats;", "", "()V", "requestsFailedAllInstancesFailed", "Ljava/util/concurrent/atomic/AtomicInteger;", "requestsFailedNoInstanceAvailable", "requestsFailedXmppNotConnected", "allInstancesFailed", "", "noInstanceAvailable", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "xmppNotConnected", "Companion", "jicofo"})
    public static final class Stats {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final AtomicInteger requestsFailedNoInstanceAvailable = new AtomicInteger();
        @NotNull
        private final AtomicInteger requestsFailedXmppNotConnected = new AtomicInteger();
        @NotNull
        private final AtomicInteger requestsFailedAllInstancesFailed = new AtomicInteger();
        @NotNull
        private static final String prefix = "jigasi_iq_handler";
        @NotNull
        private static final CounterMetric rejectedRequests = MetricsContainer.registerCounter$default(JicofoMetricsContainer.Companion.getInstance(), "jigasi_iq_handler_rejected_requests", "User requests which were rejected (e.g. not authorized, bad request).", 0L, 4, null);
        @NotNull
        private static final CounterMetric acceptedRequests = MetricsContainer.registerCounter$default(JicofoMetricsContainer.Companion.getInstance(), "jigasi_iq_handler_accepted_requests", "User requests which were accepted.", 0L, 4, null);
        @NotNull
        private static final CounterMetric retries = MetricsContainer.registerCounter$default(JicofoMetricsContainer.Companion.getInstance(), "jigasi_iq_handler_retries", "Requests retried with a different jigasi instance.", 0L, 4, null);
        @NotNull
        private static final CounterMetric singleInstanceErrors = MetricsContainer.registerCounter$default(JicofoMetricsContainer.Companion.getInstance(), "jigasi_iq_handler_instance_errors", "Errors received from jigasi instances.", 0L, 4, null);
        @NotNull
        private static final CounterMetric singleInstanceTimeouts = MetricsContainer.registerCounter$default(JicofoMetricsContainer.Companion.getInstance(), "jigasi_iq_handler_instance_timeouts", "Timeouts for requests sent to jigasi instances.", 0L, 4, null);

        public final int noInstanceAvailable() {
            return this.requestsFailedNoInstanceAvailable.incrementAndGet();
        }

        public final int xmppNotConnected() {
            return this.requestsFailedXmppNotConnected.incrementAndGet();
        }

        public final int allInstancesFailed() {
            return this.requestsFailedAllInstancesFailed.incrementAndGet();
        }

        @NotNull
        public final OrderedJsonObject toJson() {
            OrderedJsonObject orderedJsonObject;
            OrderedJsonObject $this$toJson_u24lambda_u2d0 = orderedJsonObject = Companion.statsJson();
            boolean bl = false;
            ((Map)$this$toJson_u24lambda_u2d0).put("requests_failed_no_instance", this.requestsFailedNoInstanceAvailable.get());
            ((Map)$this$toJson_u24lambda_u2d0).put("requests_failed_xmpp_not_connected", this.requestsFailedXmppNotConnected.get());
            return orderedJsonObject;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jitsi/jicofo/xmpp/JigasiIqHandler$Stats$Companion;", "", "()V", "acceptedRequests", "Lorg/jitsi/metrics/CounterMetric;", "getAcceptedRequests", "()Lorg/jitsi/metrics/CounterMetric;", "prefix", "", "rejectedRequests", "getRejectedRequests", "retries", "getRetries", "singleInstanceErrors", "getSingleInstanceErrors", "singleInstanceTimeouts", "getSingleInstanceTimeouts", "statsJson", "Lorg/jitsi/utils/OrderedJsonObject;", "jicofo"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CounterMetric getRejectedRequests() {
                return rejectedRequests;
            }

            @NotNull
            public final CounterMetric getAcceptedRequests() {
                return acceptedRequests;
            }

            @NotNull
            public final CounterMetric getRetries() {
                return retries;
            }

            @NotNull
            public final CounterMetric getSingleInstanceErrors() {
                return singleInstanceErrors;
            }

            @NotNull
            public final CounterMetric getSingleInstanceTimeouts() {
                return singleInstanceTimeouts;
            }

            @NotNull
            public final OrderedJsonObject statsJson() {
                OrderedJsonObject orderedJsonObject;
                OrderedJsonObject $this$statsJson_u24lambda_u2d0 = orderedJsonObject = new OrderedJsonObject();
                boolean bl = false;
                $this$statsJson_u24lambda_u2d0.put("rejected_requests", Companion.getRejectedRequests().get());
                $this$statsJson_u24lambda_u2d0.put("accepted_requests", Companion.getAcceptedRequests().get());
                $this$statsJson_u24lambda_u2d0.put("retries", Companion.getRetries().get());
                $this$statsJson_u24lambda_u2d0.put("instance_errors", Companion.getSingleInstanceErrors().get());
                $this$statsJson_u24lambda_u2d0.put("instance_timeout", Companion.getSingleInstanceTimeouts().get());
                return orderedJsonObject;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

