/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rest;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.jetbrains.annotations.NotNull;
import org.jitsi.health.HealthCheckService;
import org.jitsi.health.Result;

@Path(value="/about/health")
public class Health {
    @NotNull
    private final HealthCheckService healthCheckService;

    public Health(@NotNull HealthCheckService healthCheckService) {
        this.healthCheckService = healthCheckService;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getHealth() {
        Result result2 = this.healthCheckService.getResult();
        if (!result2.getSuccess()) {
            int status = result2.getResponseCode() != null ? result2.getResponseCode() : (result2.getHardFailure() ? 500 : 503);
            Response.ResponseBuilder response = Response.status(status);
            if (result2.getMessage() != null) {
                response.entity(result2.getMessage());
            }
            return response.build();
        }
        return Response.ok().build();
    }
}

