/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import com.thaiopensource.relaxng.jarv.VerifierFactoryImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import nokogiri.NokogiriService;
import nokogiri.XmlSchema;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.anno.JRubyClass;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

@JRubyClass(name={"Nokogiri::XML::RelaxNG"}, parent="Nokogiri::XML::Schema")
public class XmlRelaxng
extends XmlSchema {
    private Verifier verifier;

    public XmlRelaxng(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    private void setVerifier(Verifier verifier) {
        this.verifier = verifier;
    }

    static XmlSchema createSchemaInstance(ThreadContext threadContext, RubyClass rubyClass, Source source, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.getRuntime();
        XmlRelaxng xmlRelaxng = (XmlRelaxng)NokogiriService.XML_RELAXNG_ALLOCATOR.allocate(ruby, rubyClass);
        if (iRubyObject == null) {
            iRubyObject = XmlRelaxng.defaultParseOptions(threadContext.getRuntime());
        }
        xmlRelaxng.setInstanceVariable("@errors", (IRubyObject)ruby.newEmptyArray());
        xmlRelaxng.setInstanceVariable("@parse_options", iRubyObject);
        try {
            Schema schema = xmlRelaxng.getSchema(source, threadContext);
            xmlRelaxng.setVerifier(schema.newVerifier());
            return xmlRelaxng;
        }
        catch (VerifierConfigurationException verifierConfigurationException) {
            throw threadContext.getRuntime().newRuntimeError("Could not parse document: " + verifierConfigurationException.getMessage());
        }
    }

    private Schema getSchema(Source source, ThreadContext threadContext) {
        InputStream inputStream;
        Source source2;
        VerifierFactoryImpl verifierFactoryImpl = new VerifierFactoryImpl();
        if (source instanceof StreamSource) {
            source2 = (StreamSource)source;
            inputStream = ((StreamSource)source2).getInputStream();
        } else {
            source2 = (DOMSource)source;
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            try {
                TransformerFactory.newInstance().newTransformer().transform(source2, streamResult);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw threadContext.getRuntime().newRuntimeError("Could not parse document: " + transformerConfigurationException.getMessage());
            }
            catch (TransformerException transformerException) {
                throw threadContext.getRuntime().newRuntimeError("Could not parse document: " + transformerException.getMessage());
            }
            try {
                inputStream = new ByteArrayInputStream(stringWriter.toString().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw threadContext.getRuntime().newRuntimeError("Could not parse document: " + unsupportedEncodingException.getMessage());
            }
        }
        try {
            return verifierFactoryImpl.compileSchema(inputStream);
        }
        catch (VerifierConfigurationException verifierConfigurationException) {
            throw threadContext.getRuntime().newRuntimeError("Could not parse document: " + verifierConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw threadContext.getRuntime().newRuntimeError("Could not parse document: " + sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw threadContext.getRuntime().newIOError(iOException.getClass() + ": " + iOException.getMessage());
        }
    }

    @Override
    protected void setErrorHandler(ErrorHandler errorHandler) {
        this.verifier.setErrorHandler(errorHandler);
    }

    @Override
    protected void validate(Document document) throws SAXException, IOException {
        this.verifier.verify((Node)document);
    }
}

