/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.LongBuffer;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkSwapchainCreateInfoKHR;

public class KHRDisplaySwapchain {
    public static final int VK_KHR_DISPLAY_SWAPCHAIN_SPEC_VERSION = 10;
    public static final String VK_KHR_DISPLAY_SWAPCHAIN_EXTENSION_NAME = "VK_KHR_display_swapchain";
    public static final int VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR = 1000003000;
    public static final int VK_ERROR_INCOMPATIBLE_DISPLAY_KHR = -1000003001;

    protected KHRDisplaySwapchain() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsDevice(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_KHR_DISPLAY_SWAPCHAIN_EXTENSION_NAME) && VK.checkExtension(VK_KHR_DISPLAY_SWAPCHAIN_EXTENSION_NAME, VK.isSupported(provider, "vkCreateSharedSwapchainsKHR", caps));
    }

    public static int nvkCreateSharedSwapchainsKHR(VkDevice device, int swapchainCount, long pCreateInfos, long pAllocator, long pSwapchains) {
        long __functionAddress = device.getCapabilities().vkCreateSharedSwapchainsKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            VkSwapchainCreateInfoKHR.validate(pCreateInfos, swapchainCount);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        return JNI.callPPPPI((long)device.address(), (int)swapchainCount, (long)pCreateInfos, (long)pAllocator, (long)pSwapchains, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateSharedSwapchainsKHR(VkDevice device, @NativeType(value="VkSwapchainCreateInfoKHR const *") VkSwapchainCreateInfoKHR.Buffer pCreateInfos, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkSwapchainKHR *") LongBuffer pSwapchains) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSwapchains, (int)pCreateInfos.remaining());
        }
        return KHRDisplaySwapchain.nvkCreateSharedSwapchainsKHR(device, pCreateInfos.remaining(), pCreateInfos.address(), MemoryUtil.memAddressSafe((Pointer)pAllocator), MemoryUtil.memAddress((LongBuffer)pSwapchains));
    }

    @NativeType(value="VkResult")
    public static int vkCreateSharedSwapchainsKHR(VkDevice device, @NativeType(value="VkSwapchainCreateInfoKHR const *") VkSwapchainCreateInfoKHR.Buffer pCreateInfos, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkSwapchainKHR *") long[] pSwapchains) {
        long __functionAddress = device.getCapabilities().vkCreateSharedSwapchainsKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pSwapchains, (int)pCreateInfos.remaining());
            VkSwapchainCreateInfoKHR.validate(pCreateInfos.address(), pCreateInfos.remaining());
            if (pAllocator != null) {
                VkAllocationCallbacks.validate(pAllocator.address());
            }
        }
        return JNI.callPPPPI((long)device.address(), (int)pCreateInfos.remaining(), (long)pCreateInfos.address(), (long)MemoryUtil.memAddressSafe((Pointer)pAllocator), (long[])pSwapchains, (long)__functionAddress);
    }
}

