/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct HmdMatrix33_t")
public class HmdMatrix33
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M;

    public HmdMatrix33(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), HmdMatrix33.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float[9]")
    public FloatBuffer m() {
        return HmdMatrix33.nm(this.address());
    }

    public float m(int index) {
        return HmdMatrix33.nm(this.address(), index);
    }

    public HmdMatrix33 m(@NativeType(value="float[9]") FloatBuffer value) {
        HmdMatrix33.nm(this.address(), value);
        return this;
    }

    public HmdMatrix33 m(int index, float value) {
        HmdMatrix33.nm(this.address(), index, value);
        return this;
    }

    public HmdMatrix33 set(HmdMatrix33 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static HmdMatrix33 malloc() {
        return (HmdMatrix33)HmdMatrix33.wrap(HmdMatrix33.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static HmdMatrix33 calloc() {
        return (HmdMatrix33)HmdMatrix33.wrap(HmdMatrix33.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static HmdMatrix33 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (HmdMatrix33)HmdMatrix33.wrap(HmdMatrix33.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static HmdMatrix33 create(long address) {
        return (HmdMatrix33)HmdMatrix33.wrap(HmdMatrix33.class, (long)address);
    }

    @Nullable
    public static HmdMatrix33 createSafe(long address) {
        return address == 0L ? null : (HmdMatrix33)HmdMatrix33.wrap(HmdMatrix33.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)HmdMatrix33.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)HmdMatrix33.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)HmdMatrix33.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = HmdMatrix33.__create((int)capacity, (int)SIZEOF);
        return (Buffer)HmdMatrix33.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)HmdMatrix33.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)HmdMatrix33.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static HmdMatrix33 mallocStack() {
        return HmdMatrix33.mallocStack(MemoryStack.stackGet());
    }

    public static HmdMatrix33 callocStack() {
        return HmdMatrix33.callocStack(MemoryStack.stackGet());
    }

    public static HmdMatrix33 mallocStack(MemoryStack stack) {
        return (HmdMatrix33)HmdMatrix33.wrap(HmdMatrix33.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static HmdMatrix33 callocStack(MemoryStack stack) {
        return (HmdMatrix33)HmdMatrix33.wrap(HmdMatrix33.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return HmdMatrix33.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return HmdMatrix33.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)HmdMatrix33.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)HmdMatrix33.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static FloatBuffer nm(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)M), (int)9);
    }

    public static float nm(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)M + Checks.check((int)index, (int)9) * 4L);
    }

    public static void nm(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)9);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((FloatBuffer)value), (long)(struct + (long)M), (long)(value.remaining() * 4));
    }

    public static void nm(long struct, int index, float value) {
        UNSAFE.putFloat(null, struct + (long)M + Checks.check((int)index, (int)9) * 4L, value);
    }

    static {
        Struct.Layout layout = HmdMatrix33.__struct((Struct.Member[])new Struct.Member[]{HmdMatrix33.__array((int)4, (int)9)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<HmdMatrix33, Buffer>
    implements NativeResource {
        private static final HmdMatrix33 ELEMENT_FACTORY = HmdMatrix33.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected HmdMatrix33 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float[9]")
        public FloatBuffer m() {
            return HmdMatrix33.nm(this.address());
        }

        public float m(int index) {
            return HmdMatrix33.nm(this.address(), index);
        }

        public Buffer m(@NativeType(value="float[9]") FloatBuffer value) {
            HmdMatrix33.nm(this.address(), value);
            return this;
        }

        public Buffer m(int index, float value) {
            HmdMatrix33.nm(this.address(), index, value);
            return this;
        }
    }
}

